/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataExporter;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.utils.XmlProvider;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class XmlExportTest
extends AmqpClientTestSupport {
    @Test
    public void testTextMessage() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setDurable(true);
        message.setText("TEST");
        sender.send(message);
        sender.close();
        connection.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        Document document = XmlProvider.newDocumentBuilder().parse(new ByteArrayInputStream(xmlOutputStream.toByteArray()));
        Assertions.assertNotNull((Object)XPathFactory.newInstance().newXPath().compile("//property[@name='JMS_AMQP_ORIGINAL_ENCODING' and @value='5']").evaluate(document, XPathConstants.NODE));
        Assertions.assertNotNull((Object)XPathFactory.newInstance().newXPath().compile("//property[@name='JMS_AMQP_HEADER' and @value='true']").evaluate(document, XPathConstants.NODE));
        Assertions.assertNotNull((Object)XPathFactory.newInstance().newXPath().compile("//property[@name='JMS_AMQP_HEADERDURABLE' and @value='true']").evaluate(document, XPathConstants.NODE));
    }
}

