/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Collections;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.ha.PrimaryOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Test;

public class AMQPClusterReplicaTest
extends AmqpClientTestSupport {
    protected static final int NODE_1_PORT = 5673;
    protected static final int NODE_2_PORT = 5674;

    @Test
    public void testReplicaWithCluster() throws Exception {
        ActiveMQServer node_1 = this.createNode1(MessageLoadBalancingType.ON_DEMAND);
        ActiveMQServer node_2 = this.createNode2(MessageLoadBalancingType.ON_DEMAND);
        this.server.start();
        node_1.getConfiguration().addAMQPConnection(new AMQPBrokerConnectConfiguration("mirror", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100).addConnectionElement(new AMQPMirrorBrokerConnectionElement().setDurable(true)));
        node_1.start();
        node_2.start();
        this.configureAddressAndQueue(node_1);
        this.configureAddressAndQueue(node_2);
        AMQPClusterReplicaTest.waitForTopology(node_1, 2);
        AMQPClusterReplicaTest.waitForTopology(node_2, 2);
        ClientSessionFactory sessionFactory = this.addSessionFactory(this.getNode1ServerLocator().createSessionFactory());
        ClientSession session = this.addClientSession(sessionFactory.createSession());
        this.sendMessages(session, this.addClientProducer(session.createProducer("test")), 10);
        sessionFactory = this.addSessionFactory(this.getNode2ServerLocator().createSessionFactory());
        session = this.addClientSession(sessionFactory.createSession());
        session.start();
        this.receiveMessages(this.addClientConsumer(session.createConsumer("test")), 0, 10, true);
        Wait.waitFor(() -> node_1.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_mirror").getMessageCount() == 0L);
        Wait.assertEquals((long)0L, () -> this.server.locateQueue("test").getMessageCount());
    }

    @Test
    public void testReplicaWithClusterTargetStrict() throws Exception {
        ActiveMQServer node_1 = this.createNode1(MessageLoadBalancingType.STRICT);
        ActiveMQServer node_2 = this.createNode2(MessageLoadBalancingType.STRICT);
        this.server.stop();
        this.server.getConfiguration().addAMQPConnection(new AMQPBrokerConnectConfiguration("mirror1", "tcp://localhost:5673").setReconnectAttempts(-1).setRetryInterval(100).addConnectionElement(new AMQPMirrorBrokerConnectionElement().setDurable(true)));
        this.server.start();
        node_1.start();
        node_2.start();
        this.configureAddressAndQueue(node_1);
        this.configureAddressAndQueue(this.server);
        this.configureAddressAndQueue(node_2);
        AMQPClusterReplicaTest.waitForTopology(node_1, 2);
        AMQPClusterReplicaTest.waitForTopology(node_2, 2);
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = session.createQueue("test");
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)session.createTextMessage("hello"));
        }
        Queue node1Queue = node_1.locateQueue("test");
        Wait.assertEquals((Long)10L, () -> ((Queue)node1Queue).getMessageCount(), (long)5000L, (long)10L);
        connection.close();
    }

    private ServerLocator getNode1ServerLocator() throws Exception {
        return this.addServerLocator(ActiveMQClient.createServerLocator((String)"tcp://localhost:5673"));
    }

    private ServerLocator getNode2ServerLocator() throws Exception {
        return this.addServerLocator(ActiveMQClient.createServerLocator((String)"tcp://localhost:5674"));
    }

    private ActiveMQServer createNode1(MessageLoadBalancingType loadBalancingType) throws Exception {
        ActiveMQServer node_1 = this.createServer(5673, false);
        ClusterConnectionConfiguration clusterConfiguration = new ClusterConnectionConfiguration().setName("cluster").setConnectorName("node1").setMessageLoadBalancingType(loadBalancingType).setStaticConnectors(Collections.singletonList("node2"));
        node_1.setIdentity("node_1");
        node_1.getConfiguration().setName("node_1").setHAPolicyConfiguration((HAPolicyConfiguration)new PrimaryOnlyPolicyConfiguration()).addConnectorConfiguration("node1", "tcp://localhost:5673").addConnectorConfiguration("node2", "tcp://localhost:5674").addClusterConfiguration(clusterConfiguration);
        return node_1;
    }

    private ActiveMQServer createNode2(MessageLoadBalancingType loadBalancingType) throws Exception {
        ActiveMQServer node_2 = this.createServer(5674, false);
        ClusterConnectionConfiguration clusterConfiguration = new ClusterConnectionConfiguration().setName("cluster").setConnectorName("node2").setMessageLoadBalancingType(loadBalancingType).setStaticConnectors(Collections.singletonList("node1"));
        node_2.setIdentity("node_2");
        node_2.getConfiguration().setName("node_2").setHAPolicyConfiguration((HAPolicyConfiguration)new PrimaryOnlyPolicyConfiguration()).addConnectorConfiguration("node1", "tcp://localhost:5673").addConnectorConfiguration("node2", "tcp://localhost:5674").addClusterConfiguration(clusterConfiguration);
        return node_2;
    }

    private void configureAddressAndQueue(ActiveMQServer node) throws Exception {
        node.addAddressInfo(new AddressInfo("test").setAutoCreated(false));
        node.getAddressSettingsRepository().addMatch("test", (Object)new AddressSettings().setRedistributionDelay(0L));
        node.createQueue(QueueConfiguration.of((String)"test").setAddress("test").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }
}

