/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalUpdateCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPSyncMirrorTest
extends AmqpClientTestSupport {
    Logger logger = LoggerFactory.getLogger(AMQPSyncMirrorTest.class);
    private static final String SLOW_SERVER_NAME = "slow";
    private static final int SLOW_SERVER_PORT = 5673;
    private ActiveMQServer slowServer;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Test
    public void testPersistedSendAMQP() throws Exception {
        this.testPersistedSend("AMQP", false, 100);
    }

    @Test
    public void testPersistedSendAMQPLarge() throws Exception {
        this.testPersistedSend("AMQP", false, 204800);
    }

    @Test
    public void testPersistedSendCore() throws Exception {
        this.testPersistedSend("CORE", false, 100);
    }

    @Test
    public void testPersistedSendCoreLarge() throws Exception {
        this.testPersistedSend("CORE", false, 204800);
    }

    @Test
    public void testPersistedSendAMQPTXLarge() throws Exception {
        this.testPersistedSend("AMQP", true, 204800);
    }

    @Test
    public void testPersistedSendAMQPTX() throws Exception {
        this.testPersistedSend("AMQP", true, 100);
    }

    @Test
    public void testPersistedSendCoreTX() throws Exception {
        this.testPersistedSend("CORE", true, 100);
    }

    @Test
    public void testPersistedSendCoreTXLarge() throws Exception {
        this.testPersistedSend("CORE", true, 204800);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPersistedSend(String protocol, boolean transactional, int messageSize) throws Exception {
        ReusableLatch sendPending = new ReusableLatch(0);
        Semaphore semSend = new Semaphore(1);
        Semaphore semAck = new Semaphore(1);
        AtomicInteger errors = new AtomicInteger(0);
        try {
            int NUMBER_OF_MESSAGES = 10;
            AtomicInteger countStored = new AtomicInteger(0);
            this.slowServer = this.createServerWithCallbackStorage(5673, SLOW_SERVER_NAME, (isUpdate, isTX, txId, id, recordType, persister, record) -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("StorageCallback::slow isUpdate={}, isTX={}, txID={}, id={},recordType={}, record={}", new Object[]{isUpdate, isTX, txId, id, recordType, record});
                }
                if (transactional && isTX) {
                    try {
                        if (countStored.get() > 0) {
                            countStored.incrementAndGet();
                            this.logger.debug("semSend.tryAcquire");
                            if (semSend.tryAcquire(20L, TimeUnit.SECONDS)) {
                                this.logger.debug("acquired TX, now release");
                                semSend.release();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
                if (recordType == 33) {
                    this.logger.debug("slow ACK REF");
                    try {
                        if (semAck.tryAcquire(20L, TimeUnit.SECONDS)) {
                            semAck.release();
                            this.logger.debug("slow acquired ACK semaphore");
                        } else {
                            this.logger.debug("Semaphore wasn't acquired");
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
                if (recordType == 45 || recordType == 30) {
                    try {
                        countStored.incrementAndGet();
                        if (!transactional) {
                            this.logger.debug("semSend.tryAcquire");
                            if (semSend.tryAcquire(20L, TimeUnit.SECONDS)) {
                                this.logger.debug("acquired non TX now release");
                                semSend.release();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn(e.getMessage(), (Throwable)e);
                        errors.incrementAndGet();
                    }
                }
            });
            this.slowServer.setIdentity("slowServer");
            this.server.setIdentity("server");
            ExecutorService pool = Executors.newFixedThreadPool(5);
            this.runAfter(pool::shutdown);
            this.configureMirrorTowardsSlow(this.server);
            this.slowServer.getConfiguration().setName(SLOW_SERVER_NAME);
            this.server.getConfiguration().setName("fast");
            this.slowServer.start();
            this.server.start();
            this.waitForServerToStart(this.slowServer);
            this.waitForServerToStart(this.server);
            this.server.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
            this.server.createQueue(QueueConfiguration.of((String)this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
            Wait.waitFor(() -> this.slowServer.locateQueue(this.getQueueName()) != null);
            Queue replicatedQueue = this.slowServer.locateQueue(this.getQueueName());
            ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5672");
            if (factory instanceof ActiveMQConnectionFactory) {
                ((ActiveMQConnectionFactory)factory).getServerLocator().setBlockOnAcknowledge(true);
            }
            Connection connection = factory.createConnection();
            this.runAfter(() -> ((Connection)connection).close());
            Session session = connection.createSession(transactional, transactional ? 0 : 2);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
            connection.start();
            producer.setDeliveryMode(2);
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < messageSize; ++i) {
                buffer.append("large Buffer...");
            }
            String bodyMessage = buffer.toString();
            for (int i = 0; i < 10; ++i) {
                this.logger.debug("===>>> send message {}", (Object)i);
                int theI = i;
                sendPending.countUp();
                this.logger.debug("semSend.acquire");
                semSend.acquire();
                if (!transactional) {
                    pool.execute(() -> {
                        try {
                            this.logger.debug("Entering non TX send with sendPending = {}", (Object)sendPending.getCount());
                            TextMessage message = session.createTextMessage(bodyMessage);
                            message.setStringProperty("strProperty", "" + theI);
                            producer.send((Message)message);
                            sendPending.countDown();
                            this.logger.debug("leaving non TX send with sendPending = {}", (Object)sendPending.getCount());
                        }
                        catch (Throwable e) {
                            this.logger.warn(e.getMessage(), e);
                            errors.incrementAndGet();
                        }
                    });
                } else {
                    CountDownLatch sendDone = new CountDownLatch(1);
                    pool.execute(() -> {
                        try {
                            TextMessage message = session.createTextMessage(bodyMessage);
                            message.setStringProperty("strProperty", "" + theI);
                            producer.send((Message)message);
                        }
                        catch (Throwable e) {
                            errors.incrementAndGet();
                            this.logger.warn(e.getMessage(), e);
                        }
                        sendDone.countDown();
                    });
                    Wait.assertEquals((long)i, () -> ((Queue)replicatedQueue).getMessageCount());
                    Assertions.assertTrue((boolean)sendDone.await(10L, TimeUnit.SECONDS));
                    pool.execute(() -> {
                        try {
                            session.commit();
                            sendPending.countDown();
                        }
                        catch (Throwable e) {
                            this.logger.warn(e.getMessage(), e);
                        }
                    });
                }
                Assertions.assertFalse((boolean)sendPending.await(10L, TimeUnit.MILLISECONDS), (String)"sendPending.await() not supposed to succeed");
                this.logger.debug("semSend.release");
                semSend.release();
                Assertions.assertTrue((boolean)sendPending.await(10L, TimeUnit.SECONDS));
                Wait.assertEquals((long)(i + 1), () -> ((Queue)replicatedQueue).getMessageCount());
            }
            if (!transactional) {
                Wait.assertEquals((int)10, countStored::get);
            }
            Wait.assertEquals((long)10L, () -> ((Queue)replicatedQueue).getMessageCount());
            connection.start();
            Session clientSession = transactional ? connection.createSession(true, 1) : connection.createSession(false, 2);
            MessageConsumer consumer = clientSession.createConsumer((Destination)clientSession.createQueue(this.getQueueName()));
            for (int i = 0; i < 10; ++i) {
                this.logger.debug("===<<< Receiving message {}", (Object)i);
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                semAck.acquire();
                CountDownLatch countDownLatch = new CountDownLatch(1);
                pool.execute(() -> {
                    try {
                        if (transactional) {
                            clientSession.commit();
                        } else {
                            message.acknowledge();
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn(e.getMessage(), (Throwable)e);
                        errors.incrementAndGet();
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
                if (!transactional && protocol.equals("AMQP")) {
                    this.logger.debug("non transactional and amqp is always asynchronous. No need to verify anything");
                } else {
                    Assertions.assertFalse((boolean)countDownLatch.await(10L, TimeUnit.MILLISECONDS));
                }
                semAck.release();
                Assertions.assertTrue((boolean)countDownLatch.await(10L, TimeUnit.SECONDS));
                Wait.assertEquals((long)(10 - i - 1), () -> ((Queue)replicatedQueue).getMessageCount());
            }
            Assertions.assertEquals((int)0, (int)errors.get());
        }
        finally {
            semAck.release();
            semSend.release();
        }
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        ActiveMQServer server = this.createServerWithCallbackStorage(5672, "fastServer", (isUpdate, isTX, txId, id, recordType, persister, record) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("StorageCallback::fast isUpdate={}, isTX={}, txID={}, id={},recordType={}, record={}", new Object[]{isUpdate, isTX, txId, id, recordType, record});
            }
        });
        this.addServer(server);
        return server;
    }

    private void configureMirrorTowardsSlow(ActiveMQServer source) {
        AMQPBrokerConnectConfiguration connection = new AMQPBrokerConnectConfiguration("mirror", "tcp://localhost:5673").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replication = new AMQPMirrorBrokerConnectionElement().setDurable(true).setSync(true).setMessageAcknowledgements(true);
        connection.addElement((AMQPBrokerConnectionElement)replication);
        source.getConfiguration().addAMQPConnection(connection);
    }

    private ActiveMQServer createServerWithCallbackStorage(int port, String name, final StorageCallback storageCallback) throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        ActiveMQServerImpl server = new ActiveMQServerImpl((Configuration)this.createBasicConfig(port), this.mBeanServer, (ActiveMQSecurityManager)securityManager){

            protected StorageManager createStorageManager() {
                return AMQPSyncMirrorTest.this.createCallbackStorageManager(this.getConfiguration(), this.getCriticalAnalyzer(), this.executorFactory, this.scheduledPool, this.ioExecutorFactory, this.ioCriticalErrorListener, storageCallback);
            }
        };
        server.getConfiguration().setName(name);
        server.getConfiguration().getAcceptorConfigurations().clear();
        server.getConfiguration().getAcceptorConfigurations().add(this.addAcceptorConfiguration(this.slowServer, port));
        server.getConfiguration().setMessageExpiryScanPeriod(-1L);
        server.getConfiguration().setJMXManagementEnabled(true);
        this.configureAddressPolicy((ActiveMQServer)server);
        this.configureBrokerSecurity((ActiveMQServer)server);
        this.addServer((ActiveMQServer)server);
        return server;
    }

    private StorageManager createCallbackStorageManager(Configuration configuration, CriticalAnalyzer criticalAnalyzer, ExecutorFactory executorFactory, ScheduledExecutorService scheduledPool, ExecutorFactory ioExecutorFactory, IOCriticalErrorListener ioCriticalErrorListener, final StorageCallback storageCallback) {
        return new JournalStorageManager(configuration, criticalAnalyzer, executorFactory, scheduledPool, ioExecutorFactory, ioCriticalErrorListener){

            protected Journal createMessageJournal(Configuration config, IOCriticalErrorListener criticalErrorListener, int fileSize) {
                return new JournalImpl(this.ioExecutorFactory, fileSize, config.getJournalMinFiles(), config.getJournalPoolFiles(), config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), config.getJournalFileOpenTimeout(), this.journalFF, "activemq-data", "amq", this.journalFF.getMaxIO(), 0, criticalErrorListener, config.getJournalMaxAtticFiles()){

                    public void appendAddRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
                        storageCallback.storage(false, false, txID, id, recordType, persister, record);
                        super.appendAddRecordTransactional(txID, id, recordType, persister, record);
                    }

                    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion callback) throws Exception {
                        storageCallback.storage(false, false, -1L, id, recordType, persister, record);
                        super.appendAddRecord(id, recordType, persister, record, sync, callback);
                    }

                    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
                        storageCallback.storage(true, false, -1L, id, recordType, null, record);
                        super.appendUpdateRecord(id, recordType, record, sync);
                    }

                    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
                        storageCallback.storage(true, false, txID, id, recordType, null, record);
                        super.appendUpdateRecordTransactional(txID, id, recordType, record);
                    }

                    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
                        storageCallback.storage(false, true, txID, txID, (byte)0, null, null);
                        super.appendCommitRecord(txID, sync, callback, lineUpContext);
                    }

                    public void tryAppendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync, boolean replaceableUpdate, JournalUpdateCallback updateCallback, IOCompletion callback) throws Exception {
                        storageCallback.storage(true, false, -1L, -1L, recordType, persister, record);
                        super.tryAppendUpdateRecord(id, recordType, persister, record, sync, replaceableUpdate, updateCallback, callback);
                    }
                };
            }
        };
    }

    @Test
    public void testSimpleACK_TX_AMQP() throws Exception {
        this.testSimpleAckSync("AMQP", true, false, 1024);
    }

    @Test
    public void testSimpleACK_TX_CORE() throws Exception {
        this.testSimpleAckSync("CORE", true, false, 1024);
    }

    @Test
    public void testSimpleACK_NoTX_AMQP() throws Exception {
        this.testSimpleAckSync("AMQP", false, false, 1024);
    }

    @Test
    public void testSimpleACK_NoTX_CORE() throws Exception {
        this.testSimpleAckSync("CORE", false, false, 1024);
    }

    @Test
    public void testSimpleACK_NoTX_CORE_Large() throws Exception {
        this.testSimpleAckSync("CORE", false, false, 261120);
    }

    @Test
    public void testSimpleACK_TX_CORE_Large() throws Exception {
        this.testSimpleAckSync("CORE", true, false, 261120);
    }

    @Test
    public void testSimple_Core_Individual_Large() throws Exception {
        this.testSimpleAckSync("CORE", false, true, 261120);
    }

    @Test
    public void testSimple_Core_Individual() throws Exception {
        this.testSimpleAckSync("CORE", false, true, 1024);
    }

    public void testSimpleAckSync(String protocol, boolean tx, boolean individualAck, int messageSize) throws Exception {
        AtomicInteger errors = new AtomicInteger(0);
        int NUMBER_OF_MESSAGES = 10;
        this.slowServer = this.createServerWithCallbackStorage(5673, SLOW_SERVER_NAME, (isUpdate, isTX, txId, id, recordType, persister, record) -> {});
        this.slowServer.setIdentity("slowServer");
        this.server.setIdentity("server");
        ExecutorService pool = Executors.newFixedThreadPool(5);
        this.runAfter(pool::shutdown);
        this.configureMirrorTowardsSlow(this.server);
        this.slowServer.getConfiguration().setName(SLOW_SERVER_NAME);
        this.server.getConfiguration().setName("fast");
        this.slowServer.start();
        this.server.start();
        this.waitForServerToStart(this.slowServer);
        this.waitForServerToStart(this.server);
        Wait.waitFor(() -> this.server.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_mirror") != null, (long)5000L);
        Queue snf = this.server.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_mirror");
        Assertions.assertNotNull((Object)snf);
        Assertions.assertEquals((Object)AddressFullMessagePolicy.BLOCK, (Object)snf.getPagingStore().getAddressFullMessagePolicy());
        this.server.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server.createQueue(QueueConfiguration.of((String)this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        Wait.waitFor(() -> this.slowServer.locateQueue(this.getQueueName()) != null);
        Queue replicatedQueue = this.slowServer.locateQueue(this.getQueueName());
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5672");
        if (factory instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)factory).getServerLocator().setBlockOnAcknowledge(true);
        }
        Connection connection = factory.createConnection();
        this.runAfter(() -> ((Connection)connection).close());
        Session session = connection.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        connection.start();
        producer.setDeliveryMode(2);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < messageSize; ++i) {
            buffer.append("large Buffer...");
        }
        String bodyMessage = buffer.toString();
        for (int i = 0; i < 10; ++i) {
            int theI = i;
            TextMessage message = session.createTextMessage(bodyMessage);
            message.setStringProperty("strProperty", "" + theI);
            producer.send((Message)message);
            Wait.assertEquals((long)(i + 1), () -> ((Queue)replicatedQueue).getMessageCount(), (long)5000L);
        }
        Wait.assertEquals((long)10L, () -> ((Queue)replicatedQueue).getMessageCount());
        connection.start();
        Session clientSession = connection.createSession(tx, tx ? 0 : (individualAck ? 101 : 2));
        MessageConsumer consumer = clientSession.createConsumer((Destination)clientSession.createQueue(this.getQueueName()));
        for (int i = 0; i < 10; ++i) {
            Message message = consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            message.acknowledge();
            if (tx) {
                clientSession.commit();
            }
            Wait.assertEquals((long)(10 - i - 1), () -> ((Queue)replicatedQueue).getMessageCount(), (long)5000L);
        }
        Assertions.assertEquals((int)0, (int)errors.get());
    }

    private static interface StorageCallback {
        public void storage(boolean var1, boolean var2, long var3, long var5, byte var7, Persister var8, Object var9);
    }
}

