/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.largemessages;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.tests.integration.amqp.largemessages.AMQPLargeMessagesTestUtil;
import org.apache.activemq.artemis.tests.integration.amqp.largemessages.AmqpReplicatedTestSupport;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpReplicatedLargeMessageTest
extends AmqpReplicatedTestSupport {
    private String smallFrameLive = new String("tcp://localhost:5682");
    private String smallFrameBackup = new String("tcp://localhost:5682");

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.createReplicatedConfigs();
        this.primaryConfig.setResolveProtocols(true).addAcceptorConfiguration("amqp", this.smallFrameLive + "?protocols=AMQP;useEpoll=false;maxFrameSize=512");
        this.backupConfig.setResolveProtocols(true).addAcceptorConfiguration("amqp", this.smallFrameBackup + "?protocols=AMQP;useEpoll=false;maxFrameSize=512");
        this.primaryServer.start();
        this.backupServer.start();
        this.primaryServer.getServer().addAddressInfo(new AddressInfo(this.getQueueName(), RoutingType.ANYCAST));
        this.primaryServer.getServer().createQueue(QueueConfiguration.of((SimpleString)this.getQueueName()).setRoutingType(RoutingType.ANYCAST));
        AmqpReplicatedLargeMessageTest.waitForRemoteBackupSynchronization(this.backupServer.getServer());
    }

    public SimpleString getQueueName() {
        return SimpleString.of((String)"replicatedTest");
    }

    @Test
    @Timeout(value=60L)
    public void testSimpleSend() throws Exception {
        try {
            ActiveMQServer server = this.primaryServer.getServer();
            int size = 102400;
            AmqpClient client = this.createAmqpClient(new URI(this.smallFrameLive));
            AmqpConnection connection = client.createConnection();
            this.addConnection(connection);
            connection.setMaxFrameSize(2048);
            connection.connect();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName().toString());
            Queue queueView = server.locateQueue(this.getQueueName());
            Assertions.assertNotNull((Object)queueView);
            Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
            session.begin();
            for (int m = 0; m < 100; ++m) {
                AmqpMessage message = new AmqpMessage();
                message.setDurable(true);
                message.setApplicationProperty("i", "m " + m);
                byte[] bytes = new byte[size];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = 122;
                }
                message.setBytes(bytes);
                sender.send(message);
            }
            session.commit();
            AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(server);
            connection.close();
            this.primaryServer.crash(new ClientSession[0]);
            Wait.assertTrue(this.backupServer::isActive);
            server = this.backupServer.getServer();
            client = this.createAmqpClient(new URI(this.smallFrameBackup));
            connection = client.createConnection();
            this.addConnection(connection);
            connection.setMaxFrameSize(2048);
            connection.connect();
            session = connection.createSession();
            queueView = server.locateQueue(this.getQueueName());
            Wait.assertEquals((long)100L, () -> ((Queue)queueView).getMessageCount());
            AmqpReceiver receiver = session.createReceiver(this.getQueueName().toString());
            receiver.flow(100);
            for (int i = 0; i < 100; ++i) {
                AmqpMessage msgReceived = receiver.receive(10L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)msgReceived);
                Data body = (Data)msgReceived.getWrappedMessage().getBody();
                byte[] bodyArray = body.getValue().getArray();
                for (int bI = 0; bI < size; ++bI) {
                    Assertions.assertEquals((byte)122, (byte)bodyArray[bI]);
                }
                msgReceived.accept(true);
            }
            receiver.flow(1);
            Assertions.assertNull((Object)receiver.receiveNoWait());
            receiver.close();
            connection.close();
            Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
            this.validateNoFilesOnLargeDir(this.getLargeMessagesDir(0, true), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testCloseFilesOnTarget() throws Exception {
        try {
            ActiveMQServer server = this.primaryServer.getServer();
            int size = 102400;
            AmqpClient client = this.createAmqpClient(new URI(this.smallFrameLive));
            AmqpConnection connection = client.createConnection();
            this.addConnection(connection);
            connection.setMaxFrameSize(2048);
            connection.connect();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName().toString());
            Queue queueView = server.locateQueue(this.getQueueName());
            Assertions.assertNotNull((Object)queueView);
            Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
            session.begin();
            for (int m = 0; m < 100; ++m) {
                AmqpMessage message = new AmqpMessage();
                message.setDurable(true);
                message.setApplicationProperty("i", "m " + m);
                byte[] bytes = new byte[size];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = 122;
                }
                message.setBytes(bytes);
                sender.send(message);
            }
            session.commit();
            AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(server);
            queueView = server.locateQueue(this.getQueueName());
            Wait.assertEquals((long)100L, () -> ((Queue)queueView).getMessageCount());
            SharedNothingBackupActivation activation = (SharedNothingBackupActivation)this.backupServer.getServer().getActivation();
            Wait.assertEquals((int)0, () -> activation.getReplicationEndpoint().getLargeMessages().size(), (long)5000L);
            AmqpReceiver receiver = session.createReceiver(this.getQueueName().toString());
            receiver.flow(100);
            for (int i = 0; i < 100; ++i) {
                AmqpMessage msgReceived = receiver.receive(10L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)msgReceived);
                Data body = (Data)msgReceived.getWrappedMessage().getBody();
                byte[] bodyArray = body.getValue().getArray();
                for (int bI = 0; bI < size; ++bI) {
                    Assertions.assertEquals((byte)122, (byte)bodyArray[bI]);
                }
                msgReceived.accept(true);
            }
            receiver.flow(1);
            Assertions.assertNull((Object)receiver.receiveNoWait());
            receiver.close();
            connection.close();
            Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
            this.validateNoFilesOnLargeDir(this.getLargeMessagesDir(0, false), 0);
            this.validateNoFilesOnLargeDir(this.getLargeMessagesDir(0, true), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

