/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeTestAccessor;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCreateJmsDestinationTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String QUEUE_NAME = "test";
    ClientSessionFactory factory;
    ClientSession clientSession;

    @Test
    public void testAutoCreateOnSendToQueue() throws Exception {
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)queue);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            TextMessage mess = session.createTextMessage("msg" + i);
            producer.send((Message)mess);
        }
        producer.close();
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 100; ++i) {
            Message m = messageConsumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
        }
        Assertions.assertNotNull((Object)this.server.getManagementService().getResource("address.test"));
        Assertions.assertNotNull((Object)this.server.getManagementService().getResource("queue.test"));
        connection.close();
    }

    @Test
    public void testAutoCreateOnSendToFQQN() throws Exception {
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        String queueName = RandomUtil.randomString();
        String addressName = RandomUtil.randomString();
        jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)CompositeAddress.toFullyQualified((String)addressName, (String)queueName));
        MessageProducer producer = session.createProducer((Destination)queue);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            TextMessage mess = session.createTextMessage("msg" + i);
            producer.send((Message)mess);
        }
        producer.close();
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 100; ++i) {
            Message m = messageConsumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
        }
        Assertions.assertNotNull((Object)this.server.getManagementService().getResource("address." + addressName));
        Assertions.assertNotNull((Object)this.server.getManagementService().getResource("queue." + queueName));
        connection.close();
    }

    @Test
    public void testAutoCreateOnSendToQueueAnonymousProducer() throws Exception {
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)QUEUE_NAME);
        MessageProducer producer = session.createProducer(null);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            TextMessage mess = session.createTextMessage("msg" + i);
            producer.send((Destination)queue, (Message)mess);
        }
        producer.close();
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 100; ++i) {
            Message m = messageConsumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
        }
        connection.close();
    }

    @Test
    public void testAutoCreateOnSendToFQQNAnonymousProducer() throws Exception {
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        String queueName = RandomUtil.randomString();
        String addressName = RandomUtil.randomString();
        jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)CompositeAddress.toFullyQualified((String)addressName, (String)queueName));
        MessageProducer producer = session.createProducer(null);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            TextMessage mess = session.createTextMessage("msg" + i);
            producer.send((Destination)queue, (Message)mess);
        }
        producer.close();
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 100; ++i) {
            Message m = messageConsumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
        }
        connection.close();
    }

    @Test
    public void testAutoCreateOnSendToQueueSecurity() throws Exception {
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addUser("guest", "guest");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().setDefaultUser("guest");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addRole("guest", "rejectAll");
        Role role = new Role("rejectAll", false, false, false, false, false, false, false, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("#", roles);
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)QUEUE_NAME);
        try {
            session.createProducer((Destination)queue);
            Assertions.fail((String)"Sending a message here should throw a JMSSecurityException");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof JMSSecurityException));
        }
        connection.close();
    }

    @Test
    public void testAutoCreateOnSendToTopic() throws Exception {
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        Topic topic = ActiveMQJMSClient.createTopic((String)QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.send((Message)session.createTextMessage("msg"));
        connection.close();
        Assertions.assertNotNull((Object)this.server.getManagementService().getResource("address.test"));
    }

    @Test
    public void testAutoCreateOnConsumeFromQueue() throws Exception {
        Connection connection = null;
        connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)QUEUE_NAME);
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        connection.start();
        Message m = messageConsumer.receive(500L);
        Assertions.assertNull((Object)m);
        Queue q = (Queue)this.server.getPostOffice().getBinding(SimpleString.of((String)QUEUE_NAME)).getBindable();
        Assertions.assertEquals((long)0L, (long)q.getMessageCount());
        Assertions.assertEquals((long)0L, (long)q.getMessagesAdded());
        connection.close();
    }

    @Test
    public void testAutoCreateOnConsumeFromFQQN() throws Exception {
        Connection connection = null;
        connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        String queueName = RandomUtil.randomString();
        String addressName = RandomUtil.randomString();
        jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)CompositeAddress.toFullyQualified((String)addressName, (String)queueName));
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        connection.start();
        Message m = messageConsumer.receive(500L);
        Assertions.assertNull((Object)m);
        Queue q = (Queue)this.server.getPostOffice().getBinding(SimpleString.of((String)queueName)).getBindable();
        Assertions.assertEquals((long)0L, (long)q.getMessageCount());
        Assertions.assertEquals((long)0L, (long)q.getMessagesAdded());
        connection.close();
    }

    @Test
    public void testAutoCreateOnSubscribeToTopic() throws Exception {
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        String topicName = "test-" + UUID.randomUUID().toString();
        Topic topic = ActiveMQJMSClient.createTopic((String)topicName);
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.send((Message)session.createTextMessage("msg"));
        connection.start();
        Assertions.assertNotNull((Object)consumer.receive(500L));
        Assertions.assertNotNull((Object)this.server.getManagementService().getResource("address." + topicName));
        connection.close();
        PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
        PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
        Wait.assertTrue(() -> this.server.getManagementService().getResource("address." + topicName) == null);
    }

    @Test
    public void testAutoCreateOnDurableSubscribeToTopic() throws Exception {
        Connection connection = this.cf.createConnection();
        connection.setClientID("myClientID");
        Session session = connection.createSession(false, 1);
        Topic topic = ActiveMQJMSClient.createTopic((String)QUEUE_NAME);
        MessageConsumer consumer = session.createDurableConsumer(topic, "myDurableSub");
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.send((Message)session.createTextMessage("msg"));
        connection.start();
        Assertions.assertNotNull((Object)consumer.receive(500L));
        connection.close();
        Assertions.assertNotNull((Object)this.server.getManagementService().getResource("address.test"));
        Assertions.assertNotNull((Object)this.server.locateQueue(SimpleString.of((String)"myClientID.myDurableSub")));
    }

    @Test
    public void testTemporaryTopic() throws Exception {
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        ActiveMQTemporaryTopic topic = (ActiveMQTemporaryTopic)session.createTemporaryTopic();
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.send((Message)session.createTextMessage("msg"));
        connection.start();
        Assertions.assertNotNull((Object)consumer.receive(500L));
        SimpleString topicAddress = topic.getSimpleAddress();
        consumer.close();
        Assertions.assertNotNull((Object)this.server.locateQueue(topicAddress));
        topic.delete();
        connection.close();
        Assertions.assertNull((Object)this.server.locateQueue(topicAddress));
    }

    @Test
    public void testAutoCreateOnReconnect() throws Exception {
        Connection connection = this.cf.createConnection();
        this.runAfter(() -> ((ActiveMQConnectionFactory)this.cf).close());
        this.runAfter(() -> ((Connection)connection).close());
        connection.start();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)QUEUE_NAME);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send(session.createMessage());
        Assertions.assertNotNull((Object)consumer.receive(500L));
        this.server.stop();
        this.server.start();
        this.waitForServerToStart(this.server);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.getTotalConsumerCount() == 1L, (long)3000L, (long)100L));
        producer.send(session.createMessage());
        Assertions.assertNotNull((Object)consumer.receive(500L));
        connection.close();
    }

    @Test
    public void testAutoCreateOnTopic() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        Connection connection = factory.createConnection();
        SimpleString addressName = UUIDGenerator.getInstance().generateSimpleStringUUID();
        logger.debug("Address is {}", (Object)addressName);
        this.clientSession.createAddress(addressName, RoutingType.MULTICAST, false);
        ActiveMQTopic topic = new ActiveMQTopic(addressName.toString());
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)topic);
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)session.createTextMessage("hello"));
        }
        Assertions.assertTrue((boolean)((ActiveMQDestination)topic).isCreated());
    }

    @Test
    @Timeout(value=30L)
    public void testAutoCreateOnAddressOnly() throws Exception {
        this.server.getAddressSettingsRepository().clear();
        AddressSettings settings = new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        try (Connection connection = factory.createConnection();){
            SimpleString addressName = UUIDGenerator.getInstance().generateSimpleStringUUID();
            logger.debug("Address is {}", (Object)addressName);
            ActiveMQQueue queue = new ActiveMQQueue(addressName.toString());
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(null);
            try {
                producer.send((Destination)queue, (Message)session.createTextMessage("hello"));
                Assertions.fail((String)"Expected to throw exception here");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            Assertions.assertFalse((boolean)((ActiveMQDestination)queue).isCreated());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testAutoCreateOnAddressOnlyDuringProducerCreate() throws Exception {
        this.server.getAddressSettingsRepository().clear();
        AddressSettings settings = new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        Connection connection = factory.createConnection();
        SimpleString addressName = UUIDGenerator.getInstance().generateSimpleStringUUID();
        this.clientSession.createAddress(addressName, RoutingType.ANYCAST, true);
        ActiveMQQueue queue = new ActiveMQQueue(addressName.toString());
        Session session = connection.createSession(false, 1);
        try {
            MessageProducer producer = session.createProducer((Destination)queue);
            Assertions.fail((String)"Exception expected");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)((ActiveMQDestination)queue).isCreated());
    }

    @Test
    @Timeout(value=30L)
    public void testAutoCreateOnAddressOnlyDuringProducerCreateQueueSucceed() throws Exception {
        this.server.getAddressSettingsRepository().clear();
        AddressSettings settings = new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        ConnectionFactory factory = this.cf;
        try (Connection connection = factory.createConnection();){
            SimpleString addressName = UUIDGenerator.getInstance().generateSimpleStringUUID();
            this.clientSession.createAddress(addressName, RoutingType.ANYCAST, true);
            ActiveMQQueue queue = new ActiveMQQueue(addressName.toString());
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            Assertions.assertNotNull((Object)this.server.locateQueue(addressName));
            Assertions.assertTrue((boolean)((ActiveMQDestination)queue).isCreated());
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addUser("guest", "guest");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().setDefaultUser("guest");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addRole("guest", "allowAll");
        Role role = new Role("allowAll", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("#", roles);
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"tcp://localhost:61616");
        this.factory = locator.createSessionFactory();
        this.clientSession = this.factory.createSession();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.clientSession.close();
        this.factory.close();
        super.tearDown();
    }

    @Override
    protected boolean useSecurity() {
        return true;
    }
}

