/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeTestAccessor;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCreateTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString queueA = SimpleString.of((String)"queueA");
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        AddressSettings settings = new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true)).setAutoDeleteQueues(Boolean.valueOf(true));
        this.server.getConfiguration().getAddressSettings().clear();
        this.server.getConfiguration().getAddressSettings().put("#", settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreateDeleteRecreate() throws Exception {
        Assertions.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultAddressQueueScanPeriod(), (long)this.server.getConfiguration().getAddressQueueScanPeriod(), (String)"Supposed to use default configuration on this test");
        this.server.start();
        int THREADS = 40;
        ExecutorService executor = Executors.newFixedThreadPool(THREADS);
        try {
            String QUEUE_NAME = this.getName();
            AtomicInteger errors = new AtomicInteger(0);
            for (int i = 0; i < 50; ++i) {
                ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
                logger.debug("*******************************************************************************************************************************");
                logger.debug("run {}", (Object)i);
                CyclicBarrier barrier = new CyclicBarrier(THREADS + 1);
                CountDownLatch done = new CountDownLatch(THREADS);
                Runnable consumerThread = () -> {
                    try (Connection connection = cf.createConnection();){
                        Session session = connection.createSession(false, 1);
                        barrier.await(10L, TimeUnit.SECONDS);
                        jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
                        MessageConsumer consumer = session.createConsumer((Destination)queue);
                        connection.start();
                    }
                    catch (Throwable e) {
                        logger.warn(e.getMessage(), e);
                        errors.incrementAndGet();
                    }
                    finally {
                        done.countDown();
                    }
                };
                for (int t = 0; t < THREADS; ++t) {
                    executor.execute(consumerThread);
                }
                barrier.await(10L, TimeUnit.SECONDS);
                Assertions.assertTrue((boolean)done.await(10L, TimeUnit.SECONDS));
                Assertions.assertEquals((int)0, (int)errors.get());
                try (Connection connection = cf.createConnection();){
                    Session session = connection.createSession(false, 1);
                    jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
                    MessageConsumer consumer = session.createConsumer((Destination)queue);
                    connection.start();
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.send((Message)session.createTextMessage("hello"));
                    Assertions.assertNotNull((Object)consumer.receive(5000L));
                    continue;
                }
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testSweep() throws Exception {
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        this.server.start();
        String QUEUE_NAME = "autoCreateAndRecreate";
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
        }
        connection = cf.createConnection();
        try {
            Queue serverQueue = this.server.locateQueue(QUEUE_NAME);
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertTrue((boolean)serverQueue.isSwept());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Wait.assertFalse(() -> ((Queue)serverQueue).isSwept());
            connection.start();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        AddressInfo info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)QUEUE_NAME));
        Assertions.assertNotNull((Object)info);
        Assertions.assertTrue((boolean)info.isAutoCreated());
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224112"}));
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ224112"}));
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{QUEUE_NAME}), (String)"Queue name should be mentioned on logs");
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
        }
    }

    @Test
    public void testSweepAddress() throws Exception {
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        AddressSettings settings = new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(true)).setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteAddressesDelay(10L).setAutoDeleteQueuesDelay(10L);
        this.server.getConfiguration().getAddressSettings().clear();
        this.server.getConfiguration().getAddressSettings().put("#", settings);
        this.server.start();
        String ADDRESS_NAME = this.getName();
        AddressInfo info = new AddressInfo(ADDRESS_NAME).addRoutingType(RoutingType.MULTICAST).setAutoCreated(true);
        this.server.getPostOffice().addAddressInfo(info);
        info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)ADDRESS_NAME));
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(ADDRESS_NAME);
            session.createConsumer((Destination)topic);
        }
        AddressInfo infoRef = info;
        Wait.assertTrue(() -> infoRef.getBindingRemovedTimestamp() != -1L);
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
            Thread.sleep(50L);
            Assertions.assertFalse((boolean)info.isSwept());
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
            Assertions.assertTrue((boolean)info.isSwept());
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
        }
    }

    @Test
    public void testNegativeSweepAddress() throws Exception {
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        AddressSettings settings = new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(true)).setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteAddressesDelay(10L).setAutoDeleteQueuesDelay(10L);
        this.server.getConfiguration().getAddressSettings().clear();
        this.server.getConfiguration().getAddressSettings().put("#", settings);
        this.server.start();
        String ADDRESS_NAME = this.getName();
        AddressInfo info = new AddressInfo(ADDRESS_NAME).addRoutingType(RoutingType.MULTICAST).setAutoCreated(true);
        this.server.getPostOffice().addAddressInfo(info);
        info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)ADDRESS_NAME));
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(ADDRESS_NAME);
            session.createConsumer((Destination)topic);
        }
        AddressInfo infoRef = info;
        Wait.assertTrue(() -> infoRef.getBindingRemovedTimestamp() != -1L);
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
            Thread.sleep(50L);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
            Assertions.assertTrue((boolean)info.isSwept());
            try (Connection connection = cf.createConnection();){
                Session session = connection.createSession(false, 1);
                Topic topic = session.createTopic(ADDRESS_NAME);
                session.createConsumer((Destination)topic);
                PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
                Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
                Assertions.assertFalse((boolean)info.isSwept());
            }
        }
    }

    @Test
    public void testNegativeSweepBecauseOfConsumer() throws Exception {
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        this.server.start();
        String QUEUE_NAME = this.getName();
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
        }
        AddressInfo info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)QUEUE_NAME));
        Assertions.assertNotNull((Object)info);
        Assertions.assertTrue((boolean)info.isAutoCreated());
        try (Connection connection = cf.createConnection();
             AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Queue serverQueue = this.server.locateQueue(QUEUE_NAME);
            Assertions.assertTrue((boolean)serverQueue.isSwept());
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224112"}));
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertFalse((boolean)serverQueue.isSwept());
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224112"}));
        }
    }

    @Test
    public void testNegativeSweepBecauseOfSend() throws Exception {
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        this.server.start();
        String QUEUE_NAME = this.getName();
        ConnectionFactory cf = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
        }
        AddressInfo info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)QUEUE_NAME));
        Assertions.assertNotNull((Object)info);
        Assertions.assertTrue((boolean)info.isAutoCreated());
        try (Connection connection = cf.createConnection();
             AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(QUEUE_NAME);
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Queue serverQueue = this.server.locateQueue(QUEUE_NAME);
            Assertions.assertTrue((boolean)serverQueue.isSwept());
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224112"}));
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("hello"));
            Wait.assertEquals((long)1L, () -> ((Queue)serverQueue).getMessageCount());
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertFalse((boolean)serverQueue.isSwept());
            PostOfficeTestAccessor.reapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224112"}));
        }
    }

    @Test
    public void testCleanupAfterRebootOpenWire() throws Exception {
        this.testCleanupAfterReboot("OPENWIRE", false);
    }

    @Test
    public void testCleanupAfterRebootCore() throws Exception {
        this.testCleanupAfterReboot("CORE", true);
    }

    @Test
    public void testCleanupAfterRebootAMQP() throws Exception {
        this.testCleanupAfterReboot("AMQP", false);
    }

    public void testCleanupAfterReboot(String protocol, boolean useDelay) throws Exception {
        jakarta.jms.Queue queue;
        Session session;
        if (useDelay) {
            this.server.getAddressSettingsRepository().addMatch(this.getName(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoDeleteAddressesDelay(TimeUnit.DAYS.toMillis(1L)).setAutoDeleteQueuesDelay(TimeUnit.DAYS.toMillis(1L)));
        }
        this.server.getConfiguration().setAddressQueueScanPeriod(-1L);
        this.server.start();
        String QUEUE_NAME = "QUEUE_" + this.getName();
        String TOPIC_NAME = "TOPIC_" + this.getName();
        ConnectionFactory cf = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session2 = connection.createSession(false, 1);
            jakarta.jms.Queue queue2 = session2.createQueue(QUEUE_NAME);
            MessageConsumer consumer = session2.createConsumer((Destination)queue2);
            connection.start();
        }
        AddressInfo info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)QUEUE_NAME));
        Assertions.assertNotNull((Object)info);
        Assertions.assertTrue((boolean)info.isAutoCreated());
        this.server.stop();
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            this.server.start();
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ224113"}));
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ224112"}));
        }
        String randomString = "random " + RandomUtil.randomString();
        try (Connection connection = cf.createConnection();){
            session = connection.createSession(false, 1);
            queue = session.createQueue(QUEUE_NAME);
            Topic topic = session.createTopic(TOPIC_NAME);
            MessageProducer producer = session.createProducer(null);
            producer.send((Destination)queue, (Message)session.createTextMessage(randomString));
            producer.send((Destination)topic, (Message)session.createTextMessage(randomString));
        }
        info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)QUEUE_NAME));
        Assertions.assertNotNull((Object)info);
        Assertions.assertTrue((boolean)info.isAutoCreated());
        info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)TOPIC_NAME));
        Assertions.assertNotNull((Object)info);
        Assertions.assertTrue((boolean)info.isAutoCreated());
        this.server.stop();
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            this.server.start();
            Assertions.assertFalse((boolean)loggerHandler.matchText("AMQ224113.*" + QUEUE_NAME));
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224112"}));
            Assertions.assertTrue((boolean)loggerHandler.matchText("AMQ224113.*" + TOPIC_NAME));
        }
        info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)QUEUE_NAME));
        Assertions.assertNotNull((Object)info);
        Assertions.assertTrue((boolean)info.isAutoCreated());
        info = this.server.getPostOffice().getAddressInfo(SimpleString.of((String)TOPIC_NAME));
        Assertions.assertNull((Object)info);
        Queue serverQueue = this.server.locateQueue(QUEUE_NAME);
        Wait.assertEquals((long)1L, () -> ((Queue)serverQueue).getMessageCount());
        connection = cf.createConnection();
        try {
            session = connection.createSession(false, 1);
            connection.start();
            queue = session.createQueue(QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            Assertions.assertEquals((Object)randomString, (Object)message.getText());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

