/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeTestAccessor;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AutoDeleteAddressTest
extends ActiveMQTestBase {
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString queueA = SimpleString.of((String)"queueA");
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.getConfiguration().setAddressQueueScanPeriod(0L);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
    }

    @Test
    public void testAutoDeleteAutoCreatedAddress() throws Exception {
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        Assertions.assertNotNull((Object)this.server.getAddressInfo(this.addressA));
        this.cf.createSession().createConsumer(this.queueA).close();
        PostOfficeTestAccessor.sweepAndReapAddresses((PostOfficeImpl)this.server.getPostOffice());
        Wait.assertTrue(() -> this.server.getAddressInfo(this.addressA) == null);
    }

    @Test
    public void testNegativeAutoDeleteAutoCreatedAddress() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(false)));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        Assertions.assertNotNull((Object)this.server.getAddressInfo(this.addressA));
        this.cf.createSession().createConsumer(this.queueA).close();
        PostOfficeTestAccessor.sweepAndReapAddresses((PostOfficeImpl)this.server.getPostOffice());
        Assertions.assertNotNull((Object)this.server.getAddressInfo(this.addressA));
    }

    @Test
    public void testAutoDeleteAutoCreatedAddressSkipUsageCheckWithDelay() throws Exception {
        long DELAY = 1500L;
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteAddressesSkipUsageCheck(true).setAutoDeleteAddressesDelay(1500L));
        this.server.addAddressInfo(new AddressInfo(this.addressA).setAutoCreated(true));
        long start = System.currentTimeMillis();
        Assertions.assertNotNull((Object)this.server.getAddressInfo(this.addressA));
        while (System.currentTimeMillis() - start <= 1500L) {
            PostOfficeTestAccessor.sweepAndReapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertNotNull((Object)this.server.getAddressInfo(this.addressA));
            Thread.sleep(100L);
        }
        PostOfficeTestAccessor.sweepAndReapAddresses((PostOfficeImpl)this.server.getPostOffice());
        Assertions.assertNull((Object)this.server.getAddressInfo(this.addressA));
    }

    @Test
    public void testAutoDeleteAddressWithWildcardAddress() throws Exception {
        String prefix = "topic";
        this.server.getAddressSettingsRepository().addMatch(prefix + ".#", (Object)new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteAddressesSkipUsageCheck(true));
        String wildcardAddress = prefix + ".#";
        String queue = RandomUtil.randomString();
        int MESSAGE_COUNT = 10;
        CountDownLatch latch = new CountDownLatch(10);
        this.server.createQueue(QueueConfiguration.of((String)queue).setAddress(wildcardAddress).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        ClientSession consumerSession = this.cf.createSession();
        ClientConsumer consumer = consumerSession.createConsumer(queue);
        consumer.setMessageHandler(message -> latch.countDown());
        consumerSession.start();
        ClientSession producerSession = this.cf.createSession();
        ClientProducer producer = producerSession.createProducer();
        ArrayList<CallSite> addresses = new ArrayList<CallSite>();
        for (int i = 0; i < 10; ++i) {
            String string = prefix + "." + RandomUtil.randomString();
            addresses.add((CallSite)((Object)string));
            this.server.addAddressInfo(new AddressInfo(string).setAutoCreated(true));
            producer.send(string, (Message)producerSession.createMessage(false));
        }
        producerSession.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        for (String string : addresses) {
            Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)string)));
            Wait.assertTrue(() -> Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(SimpleString.of((String)string)), (long)2000L, (long)100L);
        }
        PostOfficeTestAccessor.sweepAndReapAddresses((PostOfficeImpl)this.server.getPostOffice());
        for (String string : addresses) {
            Assertions.assertNull((Object)this.server.getAddressInfo(SimpleString.of((String)string)));
            Wait.assertFalse(() -> Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(SimpleString.of((String)string)), (long)2000L, (long)100L);
        }
        consumerSession.close();
    }
}

