/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConcurrentCreateDeleteProduceTest
extends ActiveMQTestBase {
    volatile boolean running = true;
    private final SimpleString ADDRESS = SimpleString.of((String)"ADQUEUE");
    AtomicInteger sequence = new AtomicInteger(0);
    private ActiveMQServer server;
    private ServerLocator locator;
    private static final int PAGE_MAX = 102400;
    private static final int PAGE_SIZE = 10240;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false).setJournalSyncTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L, new HashMap<String, AddressSettings>());
        this.server.start();
        this.locator = this.createNonHALocator(false).setBlockOnDurableSend(false).setBlockOnAcknowledge(true);
    }

    @Test
    public void testConcurrentProduceCreateAndDelete() throws Throwable {
        int i;
        this.locator.setBlockOnDurableSend(false).setBlockOnNonDurableSend(false);
        ClientSessionFactory factory = this.locator.createSessionFactory();
        ClientSession session = factory.createSession(true, true);
        ClientProducer producer = session.createProducer(this.ADDRESS);
        Queue serverQueue = this.server.createQueue(QueueConfiguration.of((String)"everPage").setAddress(this.ADDRESS).setRoutingType(RoutingType.ANYCAST));
        serverQueue.getPageSubscription().getPagingStore().startPaging();
        Consumer[] consumers = new Consumer[10];
        for (i = 0; i < consumers.length; ++i) {
            consumers[i] = new Consumer();
            consumers[i].start();
        }
        for (i = 0; i < 1500 && this.running; ++i) {
            producer.send((Message)session.createMessage(true));
        }
        session.close();
        this.running = false;
        for (Consumer consumer : consumers) {
            consumer.join();
            if (consumer.ex == null) continue;
            throw consumer.ex;
        }
    }

    class Consumer
    extends Thread {
        volatile Throwable ex;

        Consumer() {
        }

        @Override
        public void run() {
            try {
                ClientSessionFactory factory = ConcurrentCreateDeleteProduceTest.this.locator.createSessionFactory();
                ClientSession session = factory.createSession(false, false);
                session.start();
                int msgcount = 0;
                for (int i = 0; i < 100 && ConcurrentCreateDeleteProduceTest.this.running; ++i) {
                    SimpleString queueName = ConcurrentCreateDeleteProduceTest.this.ADDRESS.concat("_" + ConcurrentCreateDeleteProduceTest.this.sequence.incrementAndGet());
                    session.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(ConcurrentCreateDeleteProduceTest.this.ADDRESS));
                    ClientConsumer consumer = session.createConsumer(queueName);
                    while (ConcurrentCreateDeleteProduceTest.this.running) {
                        ClientMessage msg = consumer.receive(500L);
                        if (msg == null) {
                            if (!ConcurrentCreateDeleteProduceTest.this.running) break;
                            continue;
                        }
                        if (msgcount++ != 500) continue;
                        msgcount = 0;
                        break;
                    }
                    consumer.close();
                    session.commit();
                    session.deleteQueue(queueName);
                }
                session.close();
            }
            catch (Throwable e) {
                this.ex = e;
                e.printStackTrace();
                ConcurrentCreateDeleteProduceTest.this.running = false;
            }
        }
    }
}

