/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.QueueFactoryImpl;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HangConsumerTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ActiveMQServer server;
    private final SimpleString QUEUE = SimpleString.of((String)"ConsumerTestQueue");
    private Queue queue;
    private ServerLocator locator;
    ReusableLatch inCall = new ReusableLatch(1);
    Semaphore callbackSemaphore = new Semaphore(1);

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig().setMessageExpiryScanPeriod(10L);
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        this.server = this.addServer((ActiveMQServer)new MyActiveMQServer(config, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager));
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHangOnDelivery() throws Exception {
        this.queue = this.server.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setRoutingType(RoutingType.ANYCAST));
        try {
            ClientSessionFactory factory = this.locator.createSessionFactory();
            ClientSession sessionProducer = factory.createSession(false, false, false);
            ServerLocator consumerLocator = this.createInVMNonHALocator();
            ClientSessionFactory factoryConsumer = consumerLocator.createSessionFactory();
            ClientSession sessionConsumer = factoryConsumer.createSession();
            ClientProducer producer = sessionProducer.createProducer(this.QUEUE);
            ClientConsumer consumer = sessionConsumer.createConsumer(this.QUEUE);
            producer.send((Message)sessionProducer.createMessage(true));
            this.blockConsumers();
            sessionProducer.commit();
            sessionConsumer.start();
            this.awaitBlocking();
            producer.send((Message)sessionProducer.createMessage(true));
            sessionProducer.commit();
            this.queue.getMessagesAdded();
            this.queue.getMessageCount();
            this.releaseConsumers();
            sessionConsumer.rollback();
            this.queue.flushExecutor();
            Wait.waitFor(() -> this.getMessageCount(this.queue) == 2);
            Wait.assertEquals((long)2L, () -> ((Queue)this.queue).getMessageCount());
            Wait.assertEquals((long)2L, () -> ((Queue)this.queue).getMessagesAdded());
            ClientMessage msg = consumer.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            msg = consumer.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            sessionProducer.commit();
            sessionConsumer.commit();
            sessionProducer.close();
            sessionConsumer.close();
        }
        finally {
            this.releaseConsumers();
        }
    }

    protected void releaseConsumers() {
        this.callbackSemaphore.release();
    }

    protected void awaitBlocking() throws InterruptedException {
        Assertions.assertTrue((boolean)this.inCall.await(5000L));
    }

    protected void blockConsumers() throws InterruptedException {
        this.callbackSemaphore.acquire();
    }

    @Test
    public void testHangDuplicateQueues() throws Exception {
        final Semaphore blocked = new Semaphore(1);
        final CountDownLatch latchDelete = new CountDownLatch(1);
        class LocalFactory
        extends QueueFactoryImpl {
            LocalFactory(ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutor, HierarchicalRepository<AddressSettings> addressSettingsRepository, StorageManager storageManager, ActiveMQServer server) {
                super(executorFactory, scheduledExecutor, addressSettingsRepository, storageManager, server);
            }

            public Queue createQueueWith(QueueConfiguration config, PagingManager pagingManager, Filter filter) {
                PageSubscription pageSubscription = LocalFactory.getPageSubscription((QueueConfiguration)config, (PagingManager)pagingManager, (Filter)filter);
                class MyQueueWithBlocking
                extends QueueImpl {
                    final /* synthetic */ CountDownLatch val$latchDelete;
                    final /* synthetic */ Semaphore val$blocked;
                    final /* synthetic */ HangConsumerTest this$0;

                    MyQueueWithBlocking(QueueConfiguration queueConfiguration, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server) {
                        this.this$0 = this$0;
                        this.val$latchDelete = var12_12;
                        this.val$blocked = var13_13;
                        super(queueConfiguration, filter, pagingStore, pageSubscription, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, null);
                    }

                    public boolean allowsReferenceCallback() {
                        return false;
                    }

                    public synchronized int deleteMatchingReferences(int flushLimit, Filter filter) throws Exception {
                        this.val$latchDelete.countDown();
                        this.val$blocked.acquire();
                        this.val$blocked.release();
                        return super.deleteMatchingReferences(flushLimit, filter);
                    }

                    public void deliverScheduledMessages() {
                    }
                }
                queue = new MyQueueWithBlocking(this, config, filter, pageSubscription != null ? pageSubscription.getPagingStore() : null, pageSubscription, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor(), this.server, latchDelete, blocked);
                return queue;
            }
        }
        LocalFactory queueFactory = new LocalFactory(this.server.getExecutorFactory(), this.server.getScheduledPool(), this.server.getAddressSettingsRepository(), this.server.getStorageManager(), this.server);
        queueFactory.setPostOffice(this.server.getPostOffice());
        ((ActiveMQServerImpl)this.server).replaceQueueFactory((QueueFactory)queueFactory);
        this.queue = this.server.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setRoutingType(RoutingType.ANYCAST));
        blocked.acquire();
        ClientSessionFactory factory = this.locator.createSessionFactory();
        ClientSession session = factory.createSession(false, false, false);
        ClientProducer producer = session.createProducer(this.QUEUE);
        producer.send((Message)session.createMessage(true));
        session.commit();
        Thread tDelete = new Thread(() -> {
            try {
                this.server.destroyQueue(this.QUEUE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        tDelete.start();
        Assertions.assertTrue((boolean)latchDelete.await(10L, TimeUnit.SECONDS));
        try {
            this.server.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setRoutingType(RoutingType.ANYCAST));
        }
        catch (Exception exception) {
            // empty catch block
        }
        blocked.release();
        this.server.stop();
        tDelete.join();
        session.close();
        this.server.start();
        this.waitForServerToStart(this.server);
        this.server.stop();
    }

    @Test
    public void testForceDuplicationOnBindings() throws Exception {
        this.queue = this.server.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory factory = this.locator.createSessionFactory();
        ClientSession session = factory.createSession(false, false, false);
        ClientProducer producer = session.createProducer(this.QUEUE);
        producer.send((Message)session.createMessage(true));
        session.commit();
        long queueID = this.server.getStorageManager().generateID();
        long txID = this.server.getStorageManager().generateID();
        LocalQueueBinding newBinding = new LocalQueueBinding(this.QUEUE, (Queue)new QueueImpl(queueID, this.QUEUE, this.QUEUE, null, null, true, false, false, null, null, null, null, null, this.server, null), this.server.getNodeID());
        this.server.getStorageManager().addQueueBinding(txID, (Binding)newBinding);
        this.server.getStorageManager().commitBindings(txID);
        this.server.stop();
        this.server.start();
        this.waitForServerToStart(this.server);
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionWhileDelivering() throws Exception {
        this.queue = this.server.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setRoutingType(RoutingType.ANYCAST));
        HangInterceptor hangInt = new HangInterceptor();
        try {
            this.locator.addIncomingInterceptor((Interceptor)hangInt);
            ClientSessionFactory factory = this.locator.createSessionFactory();
            ClientSession session = factory.createSession(false, false, false);
            ClientProducer producer = session.createProducer(this.QUEUE);
            ClientConsumer consumer = session.createConsumer(this.QUEUE);
            producer.send((Message)session.createMessage(true));
            session.commit();
            hangInt.close();
            session.start();
            Assertions.assertTrue((boolean)hangInt.reusableLatch.await(10L, TimeUnit.SECONDS));
            hangInt.pendingException = new ActiveMQException();
            hangInt.open();
            session.close();
            session = factory.createSession(false, false);
            session.start();
            consumer = session.createConsumer(this.QUEUE);
            ClientMessage msg = consumer.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            session.commit();
        }
        finally {
            hangInt.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateDestinationsOnTopic() throws Exception {
        try {
            for (int i = 0; i < 5; ++i) {
                if (this.server.locateQueue(SimpleString.of((String)"tt")) == null) {
                    this.server.createQueue(QueueConfiguration.of((String)"tt").setRoutingType(RoutingType.ANYCAST).setFilterString("__AMQX=-1"));
                }
                this.server.stop();
                NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(this.server.getConfiguration().getBindingsLocation(), null, 1);
                JournalImpl messagesJournal = new JournalImpl(0x100000, 2, 2, 0, 0, (SequentialFileFactory)messagesFF, "activemq-bindings", "bindings", 1);
                messagesJournal.start();
                LinkedList infos = new LinkedList();
                messagesJournal.load(infos, null, null);
                int bindings = 0;
                for (RecordInfo info : infos) {
                    logger.debug("info: {}", (Object)info);
                    if (info.getUserRecordType() != 21) continue;
                    ++bindings;
                }
                Assertions.assertEquals((int)1, (int)bindings);
                logger.debug("Bindings: {}", (Object)bindings);
                messagesJournal.stop();
                if (i >= 4) continue;
                this.server.start();
            }
        }
        finally {
            try {
                this.server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    class MyActiveMQServer
    extends ActiveMQServerImpl {
        MyActiveMQServer(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager) {
            super(configuration, mbeanServer, securityManager);
        }

        protected ServerSessionImpl internalCreateSession(String name, String username, String password, String validatedUser, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, OperationContext context, boolean autoCreateQueue, Map<SimpleString, RoutingType> prefixes, String securityDomain, boolean isLegacyProducer) throws Exception {
            return new ServerSessionImpl(name, username, password, validatedUser, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.getConfiguration().isPersistDeliveryCountBeforeDelivery(), xa, connection, this.getStorageManager(), this.getPostOffice(), this.getResourceManager(), this.getSecurityStore(), this.getManagementService(), (ActiveMQServer)this, this.getConfiguration().getManagementAddress(), defaultAddress == null ? null : SimpleString.of((String)defaultAddress), (SessionCallback)new MyCallback(callback), context, this.getPagingManager(), prefixes, securityDomain, isLegacyProducer);
        }
    }

    class HangInterceptor
    implements Interceptor {
        Semaphore semaphore = new Semaphore(1);
        ReusableLatch reusableLatch = new ReusableLatch(1);
        volatile ActiveMQException pendingException = null;

        HangInterceptor() {
        }

        public void close() throws Exception {
            this.semaphore.acquire();
        }

        public void open() throws Exception {
            this.semaphore.release();
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet instanceof SessionReceiveMessage) {
                logger.debug("Receiving message");
                try {
                    this.reusableLatch.countDown();
                    this.semaphore.acquire();
                    this.semaphore.release();
                    this.reusableLatch.countUp();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.pendingException != null) {
                ActiveMQException exToThrow = this.pendingException;
                this.pendingException = null;
                throw exToThrow;
            }
            return true;
        }
    }

    class MyCallback
    implements SessionCallback {
        final SessionCallback targetCallback;

        public boolean hasCredits(ServerConsumer consumerID) {
            return true;
        }

        MyCallback(SessionCallback parameter) {
            this.targetCallback = parameter;
        }

        public void sendProducerCreditsMessage(int credits, SimpleString address) {
            this.targetCallback.sendProducerCreditsMessage(credits, address);
        }

        public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
            return false;
        }

        public void browserFinished(ServerConsumer consumer) {
        }

        public boolean isWritable(ReadyListener callback, Object protocolContext) {
            return true;
        }

        public void afterDelivery() throws Exception {
        }

        public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
            this.targetCallback.sendProducerCreditsFailMessage(credits, address);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int sendMessage(MessageReference ref, ServerConsumer consumer, int deliveryCount) {
            HangConsumerTest.this.inCall.countDown();
            try {
                HangConsumerTest.this.callbackSemaphore.acquire();
            }
            catch (InterruptedException e) {
                HangConsumerTest.this.inCall.countUp();
                return -1;
            }
            try {
                int n = this.targetCallback.sendMessage(ref, consumer, deliveryCount);
                return n;
            }
            finally {
                HangConsumerTest.this.callbackSemaphore.release();
                HangConsumerTest.this.inCall.countUp();
            }
        }

        public int sendLargeMessage(MessageReference ref, ServerConsumer consumer, long bodySize, int deliveryCount) {
            return this.targetCallback.sendLargeMessage(ref, consumer, bodySize, deliveryCount);
        }

        public int sendLargeMessageContinuation(ServerConsumer consumer, byte[] body, boolean continues, boolean requiresResponse) {
            return this.targetCallback.sendLargeMessageContinuation(consumer, body, continues, requiresResponse);
        }

        public void closed() {
            this.targetCallback.closed();
        }

        public void disconnect(ServerConsumer consumerId, String errorMessage) {
        }
    }
}

