/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.JMSException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InitialConnectionTest
extends ActiveMQTestBase {
    @Test
    public void testInitialInfinite() throws Exception {
        AtomicInteger errors = new AtomicInteger(0);
        ActiveMQServer server = this.createServer(false, true);
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(500L);
                server.start();
            }
            catch (Throwable e) {
                e.printStackTrace();
                errors.incrementAndGet();
            }
        });
        t.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("(tcp://localhost:61618,tcp://localhost:61616,tcp://localhost:61610)?ha=true&retryInterval=100&retryIntervalMultiplier=1.0&reconnectAttempts=-1&initialConnectAttempts=-1&useTopologyForLoadBalancing=true");
        connectionFactory.createConnection().close();
        connectionFactory.close();
        t.join();
        Assertions.assertEquals((int)0, (int)errors.get());
    }

    @Test
    public void testNegativeMaxTries() throws Exception {
        long timeStart = System.currentTimeMillis();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("(tcp://localhost:61618,tcp://localhost:61616,tcp://localhost:61610)?ha=true&retryInterval=100&retryIntervalMultiplier=1.0&reconnectAttempts=-1&initialConnectAttempts=2&useTopologyForLoadBalancing=true");
        boolean failed = false;
        try {
            connectionFactory.createConnection();
        }
        catch (JMSException e) {
            failed = true;
        }
        Assertions.assertTrue((boolean)failed);
        long timeEnd = System.currentTimeMillis();
        Assertions.assertTrue((timeEnd - timeStart >= 500L ? 1 : 0) != 0, (String)"3 connectors, at 100 milliseconds each try, initialConnectAttempt=2, it should have waited at least 600 (- 100 from the last try that we don't actually wait, just throw ) milliseconds");
    }
}

