/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.CompletionListener;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class JMSTransactionTest
extends JMSTestBase {
    @Test
    @Timeout(value=60L)
    public void testAsyncProduceMessageAndCommit() throws Throwable {
        String queueName = "TEST";
        int messages = 10;
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
        cf.setConfirmationWindowSize(1000000);
        cf.setBlockOnDurableSend(true);
        cf.setBlockOnNonDurableSend(true);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        final AtomicInteger sentMessages = new AtomicInteger(0);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)((Interceptor)(packet, connection1) -> {
            if (packet.getType() == 43) {
                commitLatch.countDown();
            }
            return true;
        }));
        try (Connection connection = cf.createConnection();
             Session session = connection.createSession(true, 0);){
            jakarta.jms.Queue queue = session.createQueue("TEST");
            MessageProducer p = session.createProducer((Destination)queue);
            for (int i = 0; i < 10; ++i) {
                TextMessage message = session.createTextMessage();
                message.setText("Message:" + i);
                p.send((Message)message, new CompletionListener(){

                    public void onCompletion(Message message) {
                        try {
                            commitLatch.await();
                            sentMessages.incrementAndGet();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    public void onException(Message message, Exception exception) {
                    }
                });
            }
            session.commit();
            Wait.assertEquals((int)10, sentMessages::get);
            Queue queueView = this.server.locateQueue(SimpleString.of((String)"TEST"));
            Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
        }
    }
}

