/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.Arrays;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JournalCrashTest
extends SpawnedTestBase {
    private static final int FIRST_RUN = 4;
    private static final int SECOND_RUN = 8;
    private static final int THIRD_RUN = 100;
    private static final int FOURTH_RUN = 400;
    private ActiveMQServer server;
    private ClientSessionFactory factory;
    private final SimpleString QUEUE = SimpleString.of((String)"queue");
    private ServerLocator locator;

    protected void startServer() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setJournalFileSize(ActiveMQDefaultConfiguration.getDefaultJournalFileSize()).setJournalCompactMinFiles(ActiveMQDefaultConfiguration.getDefaultJournalCompactMinFiles()).setJournalCompactPercentage(ActiveMQDefaultConfiguration.getDefaultJournalCompactPercentage()).setJournalMinFiles(2);
        this.server = super.createServer(true, config);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
    }

    public static void main(String[] arg) {
        try {
            if (arg.length != 3) {
                throw new IllegalArgumentException(Arrays.toString(arg));
            }
            String testDir = arg[0];
            int start = Integer.parseInt(arg[1]);
            int end = Integer.parseInt(arg[2]);
            JournalCrashTest restart = new JournalCrashTest();
            restart.setTestDir(testDir);
            restart.startServer();
            restart.sendMessages(start, end);
            Runtime.getRuntime().halt(100);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    public void sendMessages(int start, int end) throws Exception {
        try (ClientSession session = this.factory.createSession(false, false);){
            try {
                session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ClientProducer prod = session.createProducer(this.QUEUE);
            for (int i = start; i < end; ++i) {
                ClientMessage msg = session.createMessage(true);
                msg.putIntProperty(SimpleString.of((String)"key"), i);
                msg.getBodyBuffer().writeUTF("message " + i);
                prod.send((Message)msg);
            }
            session.commit();
        }
    }

    @Test
    public void testRestartJournal() throws Throwable {
        this.runExternalProcess(this.getTestDir(), 0, 4);
        this.runExternalProcess(this.getTestDir(), 4, 8);
        this.runExternalProcess(this.getTestDir(), 8, 100);
        this.runExternalProcess(this.getTestDir(), 100, 400);
        this.startServer();
        try (ClientSession session = this.factory.createSession(true, true);){
            ClientConsumer consumer = session.createConsumer(this.QUEUE);
            session.start();
            for (int i = 0; i < 400; ++i) {
                ClientMessage msg = consumer.receive(5000L);
                Assertions.assertNotNull((Object)msg, (String)("Msg at " + i));
                msg.acknowledge();
                Assertions.assertEquals((Object)i, (Object)msg.getObjectProperty(SimpleString.of((String)"key")));
            }
        }
    }

    private void runExternalProcess(String tempDir, int start, int end) throws Exception {
        Process process = SpawnedVMSupport.spawnVM((String)((Object)((Object)this)).getClass().getCanonicalName(), (String)"-Xms128m", (String)"-Xmx128m", (String[])new String[0], (boolean)true, (boolean)true, (String[])new String[]{tempDir, Integer.toString(start), Integer.toString(end)});
        Assertions.assertEquals((int)100, (int)process.waitFor());
    }
}

