/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PreserveOnRestartTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        this.server.getConfiguration().setAddressQueueScanPeriod(500L);
        this.server.getConfiguration().setMessageExpiryScanPeriod(500L);
        this.server.getConfiguration().addAddressSetting("#", new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteAddressesDelay(360000L).setAutoDeleteQueuesDelay(360000L).setAutoDeleteQueuesMessageCount(-1L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setMaxSizeMessages(20L));
        this.server.start();
    }

    @Test
    public void testRestartQueueNoPaging() throws Exception {
        this.testRestartQueue(false);
    }

    @Test
    public void testRestartQueuePaging() throws Exception {
        this.testRestartQueue(true);
    }

    public void testRestartQueue(boolean paging) throws Exception {
        int NUMBER_OF_MESSAGES = paging ? 100 : 10;
        String queueName = this.getName();
        ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(true, 0);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                producer.send((Message)session.createTextMessage("hello" + i));
            }
            session.commit();
        }
        Queue serverQueue = this.server.locateQueue(queueName);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)serverQueue).getMessageCount());
        this.server.stop();
        this.server.start();
        serverQueue = this.server.locateQueue(queueName);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)serverQueue).getMessageCount());
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(true, 0);
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(queueName));
            connection.start();
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("hello" + i), (Object)message.getText());
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
            session.commit();
        }
        Wait.assertEquals((long)0L, () -> ((Queue)serverQueue).getMessageCount());
        Wait.assertFalse(() -> ((PagingStore)serverQueue.getPagingStore()).isPaging());
        this.server.stop();
        this.server.start();
        Assertions.assertNull((Object)this.server.locateQueue(queueName));
    }
}

