/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoveSubscriptionRaceTest
extends ActiveMQTestBase {
    private static final String SUB_NAME = "SubscriptionStressTest";
    ActiveMQServer server;

    @BeforeEach
    public void setServer() throws Exception {
    }

    @Test
    public void testCreateSubscriptionCoreNoFiles() throws Exception {
        this.internalTest("core", false, 5, 1000, false);
    }

    @Test
    public void testCreateSubscriptionAMQPNoFiles() throws Exception {
        this.internalTest("amqp", false, 5, 1000, false);
    }

    @Test
    public void testCreateSubscriptionCoreRealFiles() throws Exception {
        this.internalTest("core", true, 2, 200, false);
    }

    @Test
    public void testCreateSubscriptionAMQPRealFiles() throws Exception {
        this.internalTest("amqp", true, 2, 200, false);
    }

    @Test
    public void testCreateSubscriptionCoreRealFilesDurable() throws Exception {
        this.internalTest("core", true, 2, 200, true);
    }

    @Test
    public void testCreateSubscriptionAMQPRealFilesDurable() throws Exception {
        this.internalTest("amqp", true, 2, 200, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTest(String protocol, boolean realFiles, int threads, int numberOfMessages, boolean durableSub) throws Exception {
        this.server = this.createServer(realFiles, true);
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName(SUB_NAME).addRoutingType(RoutingType.MULTICAST));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"Sub_1").setAddress(SUB_NAME).setRoutingType(RoutingType.MULTICAST));
        this.server.start();
        CountDownLatch runningLatch = new CountDownLatch(threads);
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger errors = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(Math.max(1, threads));
        this.runAfter(() -> executorService.shutdownNow());
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        CyclicBarrier flagStart = new CyclicBarrier(threads + 1);
        int i = 0;
        while (i < threads) {
            int threadNumber = i++;
            executorService.execute(() -> {
                try {
                    flagStart.await(10L, TimeUnit.SECONDS);
                    for (int n = 0; n < numberOfMessages && running.get(); ++n) {
                        Connection connection = factory.createConnection();
                        if (durableSub) {
                            connection.setClientID("t" + threadNumber);
                        }
                        connection.start();
                        Session session = connection.createSession(false, 1);
                        Topic topic = session.createTopic(SUB_NAME);
                        Object consumer = durableSub ? session.createDurableSubscriber(topic, "t" + threadNumber) : session.createConsumer((Destination)topic);
                        Message message = consumer.receiveNoWait();
                        if (message != null) {
                            message.acknowledge();
                        }
                        consumer.close();
                        if (durableSub) {
                            session.unsubscribe("t" + threadNumber);
                        }
                        connection.close();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    runningLatch.countDown();
                }
            });
        }
        Connection connection = factory.createConnection();
        connection.start();
        Queue queue = this.server.locateQueue("Sub_1");
        Assertions.assertNotNull((Object)queue);
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(SUB_NAME);
        MessageProducer producer = session.createProducer((Destination)topic);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("SubscriptionStressTest::Sub_1"));
        flagStart.await(10L, TimeUnit.SECONDS);
        try {
            for (int i2 = 0; i2 < numberOfMessages; ++i2) {
                producer.send((Message)session.createTextMessage("a"));
                Assertions.assertNotNull((Object)consumer.receive(5000L));
            }
            connection.close();
        }
        finally {
            running.set(false);
            Assertions.assertTrue((boolean)runningLatch.await(10L, TimeUnit.SECONDS));
        }
        Wait.assertEquals((int)0, this::countAddMessage, (long)5000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((PagingStore)queue.getPagingStore()).getAddressSize(), (long)2000L, (long)100L);
        Assertions.assertEquals((int)0, (int)errors.get());
    }

    int countAddMessage() throws Exception {
        StorageManager manager = this.server.getStorageManager();
        if (!(manager instanceof JournalStorageManager)) {
            return 0;
        }
        JournalStorageManager journalStorageManager = (JournalStorageManager)manager;
        journalStorageManager.getMessageJournal().scheduleCompactAndBlock(5000);
        HashMap<Integer, AtomicInteger> journalCounts = this.countJournal(this.server.getConfiguration());
        AtomicInteger value = journalCounts.get(45);
        if (value == null) {
            return 0;
        }
        return value.get();
    }
}

