/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XASession;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class XAJMSOrderTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    String protocol;
    boolean exclusive;
    ConnectionFactory protocolCF;

    @Override
    protected boolean usePersistence() {
        return true;
    }

    public XAJMSOrderTest(String protocol, boolean exclusive) {
        this.protocol = protocol;
        this.exclusive = exclusive;
    }

    @BeforeEach
    public void setupCF() {
        this.protocolCF = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
    }

    @Parameters(name="protocol={0}&exclusive={1}")
    public static Collection getParameters() {
        return Arrays.asList({"CORE", true}, {"CORE", false});
    }

    @Override
    protected void extraServerConfig(ActiveMQServer server) {
        if (this.exclusive) {
            server.getConfiguration().getAddressSettings().put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")).setDefaultExclusiveQueue(Boolean.valueOf(true)));
        }
    }

    @TestTemplate
    public void testPreparedRollbackACKWithRestart() throws Exception {
        TextMessage message;
        int i;
        MessageConsumer consumer;
        jakarta.jms.Queue queue;
        XASession session;
        Queue serverQueue = this.server.createQueue(QueueConfiguration.of((String)this.getName()).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        int NUMBER_OF_MESSAGES = 30;
        ConnectionFactory cf = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();
             Session session2 = connection.createSession(false, 1);){
            jakarta.jms.Queue queue2 = session2.createQueue(this.getName());
            MessageProducer producer = session2.createProducer((Destination)queue2);
            for (int i2 = 0; i2 < 30; ++i2) {
                TextMessage message2 = session2.createTextMessage("hello " + i2);
                message2.setIntProperty("i", i2);
                producer.send((Message)message2);
            }
        }
        Wait.assertEquals((long)30L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        XidImpl xid = this.newXID();
        try (XAConnection connection = ((XAConnectionFactory)cf).createXAConnection();){
            session = connection.createXASession();
            try {
                queue = session.createQueue(this.getName());
                consumer = session.createConsumer((Destination)queue);
                connection.start();
                session.getXAResource().start((Xid)xid, 0);
                for (i = 0; i < 5; ++i) {
                    message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    logger.debug("message {} received", (Object)message.getText());
                    Assertions.assertEquals((Object)("hello " + i), (Object)message.getText());
                    Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                }
                session.getXAResource().end((Xid)xid, 0x4000000);
                session.getXAResource().prepare((Xid)xid);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        this.server.stop();
        this.server.start();
        serverQueue = this.server.locateQueue(this.getName());
        connection = cf.createConnection();
        try {
            session = connection.createSession(true, 0);
            try {
                queue = session.createQueue(this.getName());
                consumer = session.createConsumer((Destination)queue);
                connection.start();
                for (i = 5; i < 30; ++i) {
                    message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    logger.debug("message {} received", (Object)message.getText());
                    Assertions.assertEquals((Object)("hello " + i), (Object)message.getText());
                    Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                }
                session.rollback();
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = ((XAConnectionFactory)cf).createXAConnection();
        try {
            session = connection.createXASession();
            try {
                session.getXAResource().rollback((Xid)xid);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = cf.createConnection();
        try {
            session = connection.createSession(true, 0);
            try {
                queue = session.createQueue(this.getName());
                consumer = session.createConsumer((Destination)queue);
                connection.start();
                for (i = 0; i < 30; ++i) {
                    message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    logger.debug("message {} received", (Object)message.getText());
                    Assertions.assertEquals((Object)("hello " + i), (Object)message.getText());
                    Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                }
                session.commit();
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Wait.assertEquals((long)0L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
    }
}

