/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.NodeManagerAction;
import org.apache.activemq.artemis.tests.integration.cluster.NodeManagerTest;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.jupiter.api.Assertions;

public class FileLockNodeManagerTest
extends NodeManagerTest {
    @Override
    public void performWork(NodeManagerAction ... actions) throws Exception {
        ArrayList<Process> processes = new ArrayList<Process>();
        for (NodeManagerAction action : actions) {
            String[] args = new String[action.works() + 1];
            args[0] = this.getTemporaryDir();
            action.getWork(args, 1);
            Process p = SpawnedVMSupport.spawnVM((String)((Object)((Object)this)).getClass().getName(), (String)"-Xms50m", (String)"-Xmx512m", (String[])new String[0], (boolean)true, (boolean)true, (String[])args);
            processes.add(p);
        }
        for (Process process : processes) {
            process.waitFor();
        }
        for (Process process : processes) {
            if (process.exitValue() != 9) continue;
            Assertions.fail((String)"failed see output");
        }
    }

    public static void main(String[] args) throws Exception {
        NodeManagerAction.execute(Arrays.copyOfRange(args, 1, args.length), (NodeManager)new FileLockNodeManager(new File(args[0]), false));
    }
}

