/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.bridge;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnector;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.bridge.BridgeTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BridgeReconnectTest
extends BridgeTestBase {
    @Parameter(index=0)
    public boolean persistCache;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int NUM_MESSAGES = 100;
    Map<String, Object> server0Params;
    Map<String, Object> server1Params;
    Map<String, Object> server2Params;
    ActiveMQServer server0;
    ActiveMQServer server1;
    ActiveMQServer server2;
    ServerLocator locator;
    ClientSession session0;
    ClientSession session1;
    ClientSession session2;
    private TransportConfiguration server1tc;
    private Map<String, TransportConfiguration> connectors;
    private ArrayList<String> staticConnectors;
    final String bridgeName = "bridge1";
    final String testAddress = "testAddress";
    final String queueName = "queue0";
    final String forwardAddress = "forwardAddress";
    final long retryInterval = 50L;
    final double retryIntervalMultiplier = 1.0;
    final int confirmationWindowSize = 1024;
    int reconnectAttempts = 3;

    @Parameters(name="persistentCache={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server0Params = new HashMap<String, Object>();
        this.server1Params = new HashMap<String, Object>();
        this.server2Params = new HashMap<String, Object>();
        this.connectors = new HashMap<String, TransportConfiguration>();
        this.server1 = this.createActiveMQServer(1, this.isNetty(), this.server1Params);
        this.server1tc = new TransportConfiguration(this.getConnector(), this.server1Params, "server1tc");
        this.connectors.put(this.server1tc.getName(), this.server1tc);
        this.staticConnectors = new ArrayList();
        this.staticConnectors.add(this.server1tc.getName());
    }

    protected boolean isNetty() {
        return false;
    }

    private String getConnector() {
        if (this.isNetty()) {
            return NETTY_CONNECTOR_FACTORY;
        }
        return INVM_CONNECTOR_FACTORY;
    }

    @TestTemplate
    public void testFailoverDeploysBridge() throws Exception {
        InVMNodeManager nodeManager = new InVMNodeManager(false);
        this.server0 = this.createActiveMQServer(0, this.server0Params, this.isNetty(), (NodeManager)nodeManager);
        this.server2 = this.createBackupActiveMQServer(2, this.server2Params, this.isNetty(), 0, (NodeManager)nodeManager);
        TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), this.server0Params, "server0tc");
        TransportConfiguration server2tc = new TransportConfiguration(this.getConnector(), this.server2Params, "server2tc");
        this.connectors.put(server2tc.getName(), server2tc);
        this.server0.getConfiguration().setConnectorConfigurations(this.connectors);
        this.server1.getConfiguration().setConnectorConfigurations(this.connectors);
        this.server2.getConfiguration().setConnectorConfigurations(this.connectors);
        this.reconnectAttempts = -1;
        BridgeConfiguration bridgeConfiguration = this.createBridgeConfig();
        bridgeConfiguration.setQueueName("queue0");
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        this.server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        this.server2.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"queue0").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        this.server1.getConfiguration().setQueueConfigs(queueConfigs0);
        QueueConfiguration queueConfig1 = QueueConfiguration.of((String)"queue0").setAddress("forwardAddress");
        ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
        queueConfigs1.add(queueConfig1);
        this.server0.getConfiguration().setQueueConfigs(queueConfigs1);
        this.server2.getConfiguration().setQueueConfigs(queueConfigs1);
        this.startServers();
        this.waitForServerStart(this.server0);
        this.server0.fail(true);
        this.waitForServerStart(this.server2);
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, server2tc}));
        ClientSessionFactory csf0 = this.addSessionFactory(this.locator.createSessionFactory(server2tc));
        this.session0 = csf0.createSession(false, true, true);
        Map bridges = this.server2.getClusterManager().getBridges();
        Assertions.assertTrue((!bridges.isEmpty() ? 1 : 0) != 0, (String)"backup must deploy bridge on failover");
    }

    @TestTemplate
    public void testFailoverAndReconnectImmediately() throws Exception {
        int i;
        InVMNodeManager nodeManager = new InVMNodeManager(false);
        this.server0 = this.createActiveMQServer(0, this.server0Params, this.isNetty(), (NodeManager)nodeManager);
        this.server2 = this.createBackupActiveMQServer(2, this.server2Params, this.isNetty(), 0, (NodeManager)nodeManager);
        TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), this.server0Params, "server0tc");
        TransportConfiguration server2tc = new TransportConfiguration(this.getConnector(), this.server2Params, "server2tc");
        this.connectors.put(server2tc.getName(), server2tc);
        this.server0.getConfiguration().setConnectorConfigurations(this.connectors);
        this.server1.getConfiguration().setConnectorConfigurations(this.connectors);
        this.reconnectAttempts = 1;
        BridgeConfiguration bridgeConfiguration = this.createBridgeConfig();
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        this.server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"queue0").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        this.server0.getConfiguration().setQueueConfigs(queueConfigs0);
        QueueConfiguration queueConfig1 = QueueConfiguration.of((String)"queue0").setAddress("forwardAddress");
        ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
        queueConfigs1.add(queueConfig1);
        this.server1.getConfiguration().setQueueConfigs(queueConfigs1);
        this.server2.getConfiguration().setQueueConfigs(queueConfigs1);
        this.startServers();
        logger.debug("** failing connection");
        this.server0.fail(true);
        this.waitForServerStart(this.server2);
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, server2tc}));
        ClientSessionFactory csf0 = this.addSessionFactory(this.locator.createSessionFactory(server2tc));
        this.session0 = csf0.createSession(false, true, true);
        ClientProducer prod0 = this.session0.createProducer("testAddress");
        ClientSessionFactory csf2 = this.addSessionFactory(this.locator.createSessionFactory(server2tc));
        this.session2 = csf2.createSession(false, true, true);
        ClientConsumer cons2 = this.session2.createConsumer("queue0");
        this.session2.start();
        int numMessages = 100;
        SimpleString propKey = SimpleString.of((String)"propkey");
        for (i = 0; i < 100; ++i) {
            ClientMessage message = this.session0.createMessage(true);
            message.putIntProperty(propKey, i);
            prod0.send((Message)message);
        }
        for (i = 0; i < 100; ++i) {
            ClientMessage r1 = cons2.receive(1500L);
            Assertions.assertNotNull((Object)r1);
            Assertions.assertEquals((Object)i, (Object)r1.getObjectProperty(propKey));
        }
        this.closeServers();
        this.assertNoMoreConnections();
    }

    private BridgeConfiguration createBridgeConfig() {
        return new BridgeConfiguration().setName("bridge1").setQueueName("queue0").setForwardingAddress("forwardAddress").setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(this.reconnectAttempts).setReconnectAttemptsOnSameNode(0).setConfirmationWindowSize(1024).setStaticConnectors(this.staticConnectors).setPassword("UnitTestsClusterPassword");
    }

    @TestTemplate
    public void testFailoverAndReconnectAfterAFewTries() throws Exception {
        int i;
        InVMNodeManager nodeManager = new InVMNodeManager(false);
        this.server0 = this.createActiveMQServer(0, this.server0Params, this.isNetty(), (NodeManager)nodeManager);
        this.server2 = this.createBackupActiveMQServer(2, this.server2Params, this.isNetty(), 0, (NodeManager)nodeManager);
        TransportConfiguration server2tc = new TransportConfiguration(this.getConnector(), this.server2Params, "server2tc");
        this.connectors.put(server2tc.getName(), server2tc);
        this.server0.getConfiguration().setConnectorConfigurations(this.connectors);
        this.server1.getConfiguration().setConnectorConfigurations(this.connectors);
        BridgeConfiguration bridgeConfiguration = this.createBridgeConfig();
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        this.server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"queue0").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        this.server0.getConfiguration().setQueueConfigs(queueConfigs0);
        QueueConfiguration queueConfig1 = QueueConfiguration.of((String)"queue0").setAddress("forwardAddress");
        ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
        queueConfigs1.add(queueConfig1);
        this.server1.getConfiguration().setQueueConfigs(queueConfigs1);
        this.server2.getConfiguration().setQueueConfigs(queueConfigs1);
        this.startServers();
        this.server0.fail(true);
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{server2tc})).setReconnectAttempts(100);
        ClientSessionFactory csf0 = this.addSessionFactory(this.locator.createSessionFactory(server2tc));
        this.session0 = csf0.createSession(false, true, true);
        ClientSessionFactory csf2 = this.addSessionFactory(this.locator.createSessionFactory(server2tc));
        this.session2 = csf2.createSession(false, true, true);
        ClientProducer prod0 = this.session0.createProducer("testAddress");
        ClientConsumer cons2 = this.session2.createConsumer("queue0");
        this.session2.start();
        int numMessages = 100;
        SimpleString propKey = SimpleString.of((String)"propkey");
        for (i = 0; i < 100; ++i) {
            ClientMessage message = this.session0.createMessage(false);
            message.putIntProperty(propKey, i);
            prod0.send((Message)message);
        }
        for (i = 0; i < 100; ++i) {
            ClientMessage r1 = cons2.receive(1500L);
            Assertions.assertNotNull((Object)r1);
            Assertions.assertEquals((Object)i, (Object)r1.getObjectProperty(propKey));
        }
        this.closeServers();
        this.assertNoMoreConnections();
    }

    @TestTemplate
    public void testReconnectSameNode() throws Exception {
        int i;
        this.server0 = this.createActiveMQServer(0, this.isNetty(), this.server0Params);
        TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), this.server0Params, "server0tc");
        this.server0.getConfiguration().setConnectorConfigurations(this.connectors);
        this.server1.getConfiguration().setConnectorConfigurations(this.connectors);
        BridgeConfiguration bridgeConfiguration = this.createBridgeConfig();
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        this.server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"queue0").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        this.server0.getConfiguration().setQueueConfigs(queueConfigs0);
        QueueConfiguration queueConfig1 = QueueConfiguration.of((String)"queue0").setAddress("forwardAddress");
        ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
        queueConfigs1.add(queueConfig1);
        this.server1.getConfiguration().setQueueConfigs(queueConfigs1);
        this.startServers();
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, this.server1tc}));
        ClientSessionFactory csf0 = this.locator.createSessionFactory(server0tc);
        this.session0 = csf0.createSession(false, true, true);
        ClientSessionFactory csf1 = this.locator.createSessionFactory(this.server1tc);
        this.session1 = csf1.createSession(false, true, true);
        ClientProducer prod0 = this.session0.createProducer("testAddress");
        ClientConsumer cons1 = this.session1.createConsumer("queue0");
        this.session1.start();
        Bridge bridge = (Bridge)this.server0.getClusterManager().getBridges().get("bridge1");
        Assertions.assertNotNull((Object)bridge);
        RemotingConnection forwardingConnection = this.getForwardingConnection(bridge);
        InVMConnector.failOnCreateConnection = true;
        InVMConnector.numberOfFailures = this.reconnectAttempts - 1;
        forwardingConnection.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        forwardingConnection = this.getForwardingConnection(bridge);
        forwardingConnection.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        ManagementService managementService = this.server0.getManagementService();
        QueueControl coreQueueControl = (QueueControl)managementService.getResource("queue.queue0");
        Assertions.assertEquals((int)0, (int)coreQueueControl.getDeliveringCount());
        int numMessages = 100;
        SimpleString propKey = SimpleString.of((String)"propkey");
        for (i = 0; i < 100; ++i) {
            ClientMessage message = this.session0.createMessage(false);
            message.putIntProperty(propKey, i);
            prod0.send((Message)message);
        }
        for (i = 0; i < 100; ++i) {
            ClientMessage r1 = cons1.receive(1500L);
            Assertions.assertNotNull((Object)r1);
            Assertions.assertEquals((Object)i, (Object)r1.getObjectProperty(propKey));
        }
        this.closeServers();
        this.assertNoMoreConnections();
    }

    @TestTemplate
    public void testReconnectSameNodeAfterDeliveryWithBlocking() throws Exception {
        this.server0 = this.createActiveMQServer(0, this.isNetty(), this.server0Params);
        TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), this.server0Params, "server0tc");
        this.server0.getConfiguration().setConnectorConfigurations(this.connectors);
        this.server1.getConfiguration().setConnectorConfigurations(this.connectors);
        BridgeConfiguration bridgeConfiguration = this.createBridgeConfig();
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        this.server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"queue0").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        this.server0.getConfiguration().setQueueConfigs(queueConfigs0);
        QueueConfiguration queueConfig1 = QueueConfiguration.of((String)"queue0").setAddress("forwardAddress");
        ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
        queueConfigs1.add(queueConfig1);
        this.server1.getConfiguration().setQueueConfigs(queueConfigs1);
        this.startServers();
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, this.server1tc}));
        ClientSessionFactory csf0 = this.locator.createSessionFactory(server0tc);
        this.session0 = csf0.createSession(false, true, true);
        ClientSessionFactory csf1 = this.locator.createSessionFactory(this.server1tc);
        this.session1 = csf1.createSession(false, true, true);
        ClientProducer prod0 = this.session0.createProducer("testAddress");
        ClientConsumer cons1 = this.session1.createConsumer("queue0");
        this.session1.start();
        ManagementService managementService = this.server0.getManagementService();
        QueueControl coreQueueControl = (QueueControl)managementService.getResource("queue.queue0");
        Assertions.assertEquals((int)0, (int)coreQueueControl.getDeliveringCount());
        int numMessages = 100;
        SimpleString propKey = SimpleString.of((String)"propkey");
        final CyclicBarrier routingBarrier = new CyclicBarrier(2);
        final CountDownLatch deliveryBeforeFailureLatch = new CountDownLatch(100);
        final CountDownLatch deliveryAfterFailureLatch = new CountDownLatch(200);
        final List sendingMessages = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Integer, ClientMessage> clientMessages = new ConcurrentHashMap<Integer, ClientMessage>();
        this.server0.getConfiguration().registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerPlugin(){

            public void afterDeliverBridge(Bridge bridge, MessageReference ref, HandleStatus status) throws ActiveMQException {
                super.afterDeliverBridge(bridge, ref, status);
                deliveryBeforeFailureLatch.countDown();
                deliveryAfterFailureLatch.countDown();
            }
        });
        this.server1.getConfiguration().registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerPlugin(){

            public void beforeSend(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue) throws ActiveMQException {
                sendingMessages.add(message);
                try {
                    deliveryAfterFailureLatch.await();
                }
                catch (InterruptedException e) {
                    logger.debug("Interrupted", (Throwable)e);
                }
            }

            public void beforeMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) throws ActiveMQException {
                if (sendingMessages.contains(message)) {
                    try {
                        routingBarrier.await();
                    }
                    catch (InterruptedException e) {
                        logger.debug("Interrupted", (Throwable)e);
                    }
                    catch (BrokenBarrierException e) {
                        logger.debug("Interrupted", (Throwable)e);
                    }
                }
            }
        });
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.session0.createMessage(false);
            message.putIntProperty(propKey, i);
            prod0.send((Message)message);
        }
        deliveryBeforeFailureLatch.await();
        Assertions.assertEquals((int)100, (int)coreQueueControl.getDeliveringCount());
        Bridge bridge = (Bridge)this.server0.getClusterManager().getBridges().get("bridge1");
        Assertions.assertNotNull((Object)bridge);
        RemotingConnection forwardingConnection = this.getForwardingConnection(bridge);
        forwardingConnection.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        for (int i = 0; i < 100; ++i) {
            ClientMessage r1 = cons1.receive(1500L);
            Assertions.assertNotNull((Object)r1);
            Assertions.assertNull((Object)clientMessages.putIfAbsent(r1.getIntProperty(propKey), r1));
        }
        this.closeServers();
        this.assertNoMoreConnections();
        HashMap<Integer, AtomicInteger> counts = this.countJournal(this.server1.getConfiguration());
        if (this.persistCache) {
            Assertions.assertEquals((int)100, (int)counts.get(37).intValue());
        } else {
            Assertions.assertNull((Object)counts.get(37));
        }
    }

    @TestTemplate
    public void testShutdownServerCleanlyAndReconnectSameNodeWithSleep() throws Exception {
        this.testShutdownServerCleanlyAndReconnectSameNode(true);
    }

    @TestTemplate
    public void testShutdownServerCleanlyAndReconnectSameNode() throws Exception {
        this.testShutdownServerCleanlyAndReconnectSameNode(false);
    }

    private void testShutdownServerCleanlyAndReconnectSameNode(boolean sleep) throws Exception {
        int i;
        Assumptions.assumeTrue((boolean)this.persistCache);
        this.server0 = this.createActiveMQServer(0, this.isNetty(), this.server0Params);
        TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), this.server0Params, "server0tc");
        this.server0.getConfiguration().setConnectorConfigurations(this.connectors);
        this.server1.getConfiguration().setConnectorConfigurations(this.connectors);
        this.reconnectAttempts = -1;
        long clientFailureCheckPeriod = 1000L;
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration().setName("bridge1").setQueueName("queue0").setForwardingAddress("forwardAddress").setClientFailureCheckPeriod(1000L).setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(this.reconnectAttempts).setReconnectAttemptsOnSameNode(0).setConfirmationWindowSize(1024).setStaticConnectors(this.staticConnectors).setPassword("UnitTestsClusterPassword");
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        this.server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"queue0").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        this.server0.getConfiguration().setQueueConfigs(queueConfigs0);
        QueueConfiguration queueConfig1 = QueueConfiguration.of((String)"queue0").setAddress("forwardAddress");
        ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
        queueConfigs1.add(queueConfig1);
        this.server1.getConfiguration().setQueueConfigs(queueConfigs1);
        this.startServers();
        this.waitForServerStart(this.server0);
        this.waitForServerStart(this.server1);
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, this.server1tc}));
        ClientSessionFactory csf0 = this.locator.createSessionFactory(server0tc);
        this.session0 = csf0.createSession(false, true, true);
        ClientProducer prod0 = this.session0.createProducer("testAddress");
        logger.debug("stopping server1");
        this.server1.stop();
        if (sleep) {
            Thread.sleep(2000L);
        }
        logger.debug("restarting server1");
        this.server1.start();
        logger.debug("server 1 restarted");
        ClientSessionFactory csf1 = this.locator.createSessionFactory(this.server1tc);
        this.session1 = csf1.createSession(false, true, true);
        ClientConsumer cons1 = this.session1.createConsumer("queue0");
        this.session1.start();
        int numMessages = 100;
        SimpleString propKey = SimpleString.of((String)"propkey");
        for (i = 0; i < 100; ++i) {
            ClientMessage message = this.session0.createMessage(false);
            message.putIntProperty(propKey, i);
            prod0.send((Message)message);
        }
        logger.debug("sent messages");
        for (i = 0; i < 100; ++i) {
            ClientMessage r1 = cons1.receive(30000L);
            Assertions.assertNotNull((Object)r1, (String)"received expected msg");
            Assertions.assertEquals((Object)i, (Object)r1.getObjectProperty(propKey), (String)"property value matches");
        }
        logger.debug("got messages");
        this.closeServers();
        this.assertNoMoreConnections();
    }

    private void closeServers() throws Exception {
        if (this.session0 != null) {
            this.session0.close();
        }
        if (this.session1 != null) {
            this.session1.close();
        }
        if (this.session2 != null) {
            this.session2.close();
        }
        if (this.locator != null) {
            this.locator.close();
        }
        this.server0.stop();
        this.server1.stop();
        if (this.server2 != null) {
            this.server2.stop();
        }
    }

    private void assertNoMoreConnections() {
        Assertions.assertEquals((int)0, (int)this.server0.getRemotingService().getConnections().size());
        Assertions.assertEquals((int)0, (int)this.server1.getRemotingService().getConnections().size());
        if (this.server2 != null) {
            Assertions.assertEquals((int)0, (int)this.server2.getRemotingService().getConnections().size());
        }
    }

    @TestTemplate
    public void testFailoverThenFailAgainAndReconnect() throws Exception {
        ClientMessage r1;
        int i;
        this.server0 = this.createActiveMQServer(0, this.isNetty(), this.server0Params);
        TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), this.server0Params, "server0tc");
        this.server0.getConfiguration().setConnectorConfigurations(this.connectors);
        BridgeConfiguration bridgeConfiguration = this.createBridgeConfig();
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        this.server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"queue0").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        this.server0.getConfiguration().setQueueConfigs(queueConfigs0);
        QueueConfiguration queueConfig1 = QueueConfiguration.of((String)"queue0").setAddress("forwardAddress");
        ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
        queueConfigs1.add(queueConfig1);
        this.server1.getConfiguration().setQueueConfigs(queueConfigs1);
        this.startServers();
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, this.server1tc}));
        ClientSessionFactory csf0 = this.locator.createSessionFactory(server0tc);
        this.session0 = csf0.createSession(false, true, true);
        ClientSessionFactory csf1 = this.locator.createSessionFactory(this.server1tc);
        this.session1 = csf1.createSession(false, true, true);
        ClientProducer prod0 = this.session0.createProducer("testAddress");
        ClientConsumer cons1 = this.session1.createConsumer("queue0");
        this.session1.start();
        Bridge bridge = (Bridge)this.server0.getClusterManager().getBridges().get("bridge1");
        RemotingConnection forwardingConnection = this.getForwardingConnection(bridge);
        InVMConnector.failOnCreateConnection = true;
        InVMConnector.numberOfFailures = this.reconnectAttempts - 1;
        forwardingConnection.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        int numMessages = 100;
        SimpleString propKey = SimpleString.of((String)"propkey");
        for (int i2 = 0; i2 < 100; ++i2) {
            ClientMessage message = this.session0.createMessage(false);
            message.putIntProperty(propKey, i2);
            prod0.send((Message)message);
        }
        int outOfOrder = -1;
        int supposed = -1;
        for (i = 0; i < 100; ++i) {
            r1 = cons1.receive(1500L);
            Assertions.assertNotNull((Object)r1);
            if (outOfOrder != -1 || i == r1.getIntProperty(propKey)) continue;
            outOfOrder = r1.getIntProperty(propKey);
            supposed = i;
        }
        if (outOfOrder != -1) {
            Assertions.fail((String)("Message " + outOfOrder + " was received out of order, it was supposed to be " + supposed));
        }
        logger.debug("=========== second failure, sending message");
        forwardingConnection = ((BridgeImpl)bridge).getForwardingConnection();
        InVMConnector.failOnCreateConnection = true;
        InVMConnector.numberOfFailures = this.reconnectAttempts - 1;
        forwardingConnection.fail(new ActiveMQException(ActiveMQExceptionType.UNBLOCKED));
        for (i = 0; i < 100; ++i) {
            ClientMessage message = this.session0.createMessage(false);
            message.putIntProperty(propKey, i);
            prod0.send((Message)message);
        }
        for (i = 0; i < 100; ++i) {
            r1 = cons1.receive(1500L);
            Assertions.assertNotNull((Object)r1, (String)"Didn't receive message");
            if (outOfOrder != -1 || i == r1.getIntProperty(propKey)) continue;
            outOfOrder = r1.getIntProperty(propKey);
            supposed = i;
        }
        if (outOfOrder != -1) {
            Assertions.fail((String)("Message " + outOfOrder + " was received out of order, it was supposed to be " + supposed));
        }
        this.closeServers();
        this.assertNoMoreConnections();
    }

    @TestTemplate
    public void testDeliveringCountOnBridgeConnectionFailure() throws Exception {
        this.server0 = this.createActiveMQServer(0, this.isNetty(), this.server0Params);
        TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), this.server0Params, "server0tc");
        this.server0.getConfiguration().setConnectorConfigurations(this.connectors);
        BridgeConfiguration bridgeConfiguration = this.createBridgeConfig();
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        this.server0.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"queue0").setAddress("testAddress");
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        this.server0.getConfiguration().setQueueConfigs(queueConfigs0);
        QueueConfiguration queueConfig1 = QueueConfiguration.of((String)"queue0").setAddress("forwardAddress");
        ArrayList<QueueConfiguration> queueConfigs1 = new ArrayList<QueueConfiguration>();
        queueConfigs1.add(queueConfig1);
        this.server1.getConfiguration().setQueueConfigs(queueConfigs1);
        this.startServers();
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{server0tc, this.server1tc}));
        ClientSessionFactory csf0 = this.locator.createSessionFactory(server0tc);
        this.session0 = csf0.createSession(false, true, true);
        ClientSessionFactory csf1 = this.locator.createSessionFactory(this.server1tc);
        this.session1 = csf1.createSession(false, true, true);
        ClientProducer prod0 = this.session0.createProducer("testAddress");
        this.session1.start();
        Bridge bridge = (Bridge)this.server0.getClusterManager().getBridges().get("bridge1");
        RemotingConnection forwardingConnection = this.getForwardingConnection(bridge);
        InVMConnector.failOnCreateConnection = true;
        InVMConnector.numberOfFailures = this.reconnectAttempts - 1;
        int numMessages = 100;
        SimpleString propKey = SimpleString.of((String)"propkey");
        Queue queue = (Queue)this.server0.getPostOffice().getBinding(SimpleString.of((String)"queue0")).getBindable();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.session0.createMessage(false);
            message.putIntProperty(propKey, i);
            prod0.send((Message)message);
            if (i != 50) continue;
            forwardingConnection.fail(new ActiveMQException(ActiveMQExceptionType.UNBLOCKED));
        }
        Wait.assertEquals((int)0, () -> ((Queue)queue).getDeliveringCount());
        this.closeServers();
        this.assertNoMoreConnections();
    }

    private void startServers() throws Exception {
        if (this.server2 != null) {
            this.server2.start();
        }
        this.server1.start();
        this.server0.start();
    }

    private RemotingConnection getForwardingConnection(Bridge bridge) throws Exception {
        long start = System.currentTimeMillis();
        do {
            RemotingConnection forwardingConnection;
            if ((forwardingConnection = ((BridgeImpl)bridge).getForwardingConnection()) != null) {
                return forwardingConnection;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < 50000L);
        throw new IllegalStateException("Failed to get forwarding connection");
    }

    @Override
    protected ActiveMQServer createActiveMQServer(int id, Map<String, Object> params, boolean netty, NodeManager nodeManager) throws Exception {
        ActiveMQServer server = super.createActiveMQServer(id, params, netty, nodeManager);
        server.getConfiguration().setPersistIDCache(this.persistCache);
        return server;
    }
}

