/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.util.ArrayList;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageRedistributionWithDiscoveryTest
extends ClusterTestBase {
    protected final String groupAddress = ActiveMQTestBase.getUDPDiscoveryAddress();
    protected final int groupPort = ActiveMQTestBase.getUDPDiscoveryPort();

    protected boolean isNetty() {
        return false;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupCluster();
    }

    protected void setupCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.setServer(messageLoadBalancingType, i);
        }
    }

    protected void setServer(MessageLoadBalancingType messageLoadBalancingType, int server) throws Exception {
        this.setupPrimaryServerWithDiscovery(server, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
        AddressSettings setting = new AddressSettings().setRedeliveryDelay(0L).setRedistributionDelay(0L);
        this.servers[server].getAddressSettingsRepository().addMatch("#", (Object)setting);
        this.setupDiscoveryClusterConnection("cluster" + server, server, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
    }

    @Test
    public void testRedistributeWithPreparedAndRestart() throws Exception {
        this.startServers(0);
        this.setupSessionFactory(0, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        ClientSession session0 = this.sfs[0].createSession(false, false, false);
        ClientProducer prod0 = session0.createProducer("queues.testaddress");
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = session0.createMessage(true);
            msg.putIntProperty("key", i);
            prod0.send((Message)msg);
            session0.commit();
        }
        session0.close();
        session0 = this.sfs[0].createSession(true, false, false);
        ClientConsumer consumer0 = session0.createConsumer("queue0");
        session0.start();
        ArrayList<XidImpl> xids = new ArrayList<XidImpl>();
        for (int i = 0; i < 100; ++i) {
            XidImpl xid = this.newXID();
            session0.start((Xid)xid, 0);
            ClientMessage msg = consumer0.receive(5000L);
            msg.acknowledge();
            session0.end((Xid)xid, 0x4000000);
            session0.prepare((Xid)xid);
            xids.add(xid);
        }
        session0.close();
        this.sfs[0].close();
        this.sfs[0] = null;
        this.servers[0].stop();
        this.servers[0] = null;
        this.setServer(MessageLoadBalancingType.ON_DEMAND, 0);
        this.startServers(1, 2);
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        ClientSession session1 = this.sfs[1].createSession(false, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        session1.start();
        ClientConsumer consumer1 = session1.createConsumer("queue0");
        this.startServers(0);
        this.setupSessionFactory(0, this.isNetty());
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        session0 = this.sfs[0].createSession(true, false, false);
        for (Xid xid : xids) {
            session0.rollback(xid);
        }
        for (int i = 0; i < 100; ++i) {
            ClientMessage clientMessage = consumer1.receive(15000L);
            Assertions.assertNotNull((Object)clientMessage);
            clientMessage.acknowledge();
        }
        session1.commit();
    }
}

