/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.impl.journal.DescribeJournal;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.files.FileMoveManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.BackupSyncDelay;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BackupSyncJournalTest
extends FailoverTestBase {
    protected static final int BACKUP_WAIT_TIME = 60;
    private ServerLocatorInternal locator;
    protected ClientSessionFactoryInternal sessionFactory;
    protected ClientSession session;
    protected ClientProducer producer;
    private BackupSyncDelay syncDelay;
    private final int defaultNMsgs = 20;
    private int n_msgs = 20;
    protected final FailoverWaiter failoverWaiter = new FailoverWaiter();

    protected void setNumberOfMessages(int nmsg) {
        this.n_msgs = nmsg;
    }

    protected int getNumberOfMessages() {
        return this.n_msgs;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.startBackupServer = false;
        super.setUp();
        this.setNumberOfMessages(20);
        this.locator = (ServerLocatorInternal)this.getServerLocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(15).setRetryInterval(200L);
        this.sessionFactory = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, 1);
        this.sessionFactory.addFailoverListener((FailoverEventListener)this.failoverWaiter);
        this.syncDelay = new BackupSyncDelay(this.backupServer, this.primaryServer);
    }

    @Test
    public void testNodeID() throws Exception {
        this.startBackupFinishSyncing();
        Assertions.assertTrue((boolean)this.backupServer.isStarted(), (String)"must be running");
        Assertions.assertEquals((Object)this.primaryServer.getServer().getNodeID(), (Object)this.backupServer.getServer().getNodeID(), (String)"backup and primary should have the same nodeID");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReserveFileIdValuesOnBackup() throws Exception {
        void var12_17;
        int totalRounds = 5;
        this.createProducerSendSomeMessages();
        JournalImpl messageJournal = BackupSyncJournalTest.getMessageJournalFromServer(this.primaryServer);
        for (int i = 0; i < 5; ++i) {
            messageJournal.forceMoveNextFile();
            this.sendMessages(this.session, this.producer, this.n_msgs);
        }
        Queue queue = this.primaryServer.getServer().locateQueue(ADDRESS);
        PagingStore store = queue.getPageSubscription().getPagingStore();
        if (store.isPaging()) {
            store.forceAnotherPage();
        }
        this.backupServer.start();
        BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, 60, false, this.backupServer.getServer());
        JournalImpl backupMsgJournal = BackupSyncJournalTest.getMessageJournalFromServer(this.backupServer);
        this.sendMessages(this.session, this.producer, this.n_msgs);
        if (store.isPaging()) {
            store.forceAnotherPage();
        }
        this.syncDelay.deliverUpToDateMsg();
        BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, 60, true, this.backupServer.getServer());
        this.sendMessages(this.session, this.producer, this.n_msgs);
        if (store.isPaging()) {
            store.forceAnotherPage();
        }
        Set<Pair<Long, Integer>> primaryIds = this.getFileIds(messageJournal);
        int size = messageJournal.getFileSize();
        PagingStore ps = this.primaryServer.getServer().getPagingManager().getPageStore(ADDRESS);
        if (ps.getPageSizeBytes() == 1024) {
            Assertions.assertTrue((boolean)ps.isStarted(), (String)"isStarted");
            Assertions.assertFalse((boolean)ps.startPaging(), (String)"start paging should return false, because we expect paging to be running");
        }
        this.finishSyncAndFailover();
        Assertions.assertEquals((int)size, (int)backupMsgJournal.getFileSize(), (String)"file sizes must be the same");
        Set<Pair<Long, Integer>> backupIds = this.getFileIds(backupMsgJournal);
        int total = 0;
        for (Pair<Long, Integer> pair : primaryIds) {
            total += ((Integer)pair.getB()).intValue();
        }
        int totalBackup = 0;
        for (Pair<Long, Integer> pair : backupIds) {
            totalBackup += ((Integer)pair.getB()).intValue();
        }
        boolean bl = false;
        while (var12_17 < 8) {
            this.receiveMsgsInRange(0, this.n_msgs);
            ++var12_17;
        }
        this.assertNoMoreMessages();
    }

    protected void assertNoMoreMessages() throws ActiveMQException {
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(ADDRESS);
        ClientMessage msg = consumer.receiveImmediate();
        Assertions.assertNull((Object)msg, (String)("there should be no more messages to receive! " + msg));
        consumer.close();
        this.session.commit();
    }

    protected void startBackupFinishSyncing() throws Exception {
        this.syncDelay.deliverUpToDateMsg();
        this.backupServer.start();
        BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, 60, true, this.backupServer.getServer());
    }

    @Test
    public void testReplicationDuringSync() throws Exception {
        try {
            this.createProducerSendSomeMessages();
            this.backupServer.start();
            BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, 60, false, this.backupServer.getServer());
            this.sendMessages(this.session, this.producer, this.n_msgs);
            this.session.commit();
            this.receiveMsgsInRange(0, this.n_msgs);
            this.finishSyncAndFailover();
            this.receiveMsgsInRange(0, this.n_msgs);
            this.assertNoMoreMessages();
        }
        catch (AssertionError error) {
            this.printJournal(this.primaryServer);
            this.printJournal(this.backupServer);
            throw error;
        }
    }

    void printJournal(TestableServer server) {
        try {
            System.out.println("\n\n BINDINGS JOURNAL\n\n");
            Configuration config = server.getServer().getConfiguration();
            DescribeJournal.describeBindingsJournal((File)config.getBindingsLocation());
            System.out.println("\n\n MESSAGES JOURNAL\n\n");
            DescribeJournal.describeMessagesJournal((File)config.getJournalLocation());
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    protected void finishSyncAndFailover() throws Exception {
        this.syncDelay.deliverUpToDateMsg();
        BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, 60, true, this.backupServer.getServer());
        Assertions.assertFalse((boolean)this.backupServer.getServer().isActive(), (String)"should not be initialized");
        this.crash(this.session);
        Assertions.assertTrue((boolean)this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS), (String)"backup initialized");
        this.assertNodeIdWasSaved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNodeIdWasSaved() throws Exception {
        Assertions.assertTrue((boolean)this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS), (String)"backup initialized");
        String journalDirectory = this.backupConfig.getJournalDirectory();
        File serverLockFile = new File(journalDirectory, "server.lock");
        Assertions.assertTrue((boolean)serverLockFile.exists(), (String)("server.lock must exist!\n " + serverLockFile));
        try (RandomAccessFile raFile = new RandomAccessFile(serverLockFile, "r");){
            FileChannel channel = raFile.getChannel();
            int size = 16;
            ByteBuffer id = ByteBuffer.allocateDirect(16);
            int read = channel.read(id, 3L);
            Assertions.assertEquals((int)16, (int)read, (String)"tried to read 16 bytes");
            byte[] bytes = new byte[16];
            id.position(0);
            id.get(bytes);
            UUID uuid = new UUID(1, bytes);
            SimpleString storedNodeId = SimpleString.of((String)uuid.toString());
            Assertions.assertEquals((Object)this.backupServer.getServer().getNodeID(), (Object)storedNodeId, (String)"nodeId must match");
        }
    }

    @Test
    public void testMessageSyncSimple() throws Exception {
        this.createProducerSendSomeMessages();
        this.startBackupCrashPrimary();
        this.receiveMsgsInRange(0, this.n_msgs);
        this.assertNoMoreMessages();
    }

    @Test
    public void testFailBack() throws Exception {
        this.createProducerSendSomeMessages();
        this.startBackupCrashPrimary();
        this.receiveMsgsInRange(0, this.n_msgs);
        this.assertNoMoreMessages();
        this.sendMessages(this.session, this.producer, this.n_msgs);
        this.receiveMsgsInRange(0, this.n_msgs);
        this.assertNoMoreMessages();
        this.sendMessages(this.session, this.producer, 2 * this.n_msgs);
        Assertions.assertFalse((boolean)this.primaryServer.getServer().getHAPolicy().isBackup(), (String)"must NOT be a backup");
        this.adaptPrimaryConfigForReplicatedFailBack(this.primaryServer);
        FileMoveManager primaryMoveManager = new FileMoveManager(this.primaryServer.getServer().getConfiguration().getJournalLocation(), -1, new String[0]);
        this.primaryServer.getServer().lockActivation();
        try {
            this.primaryServer.start();
            Assertions.assertTrue((boolean)this.primaryServer.getServer().getHAPolicy().isBackup(), (String)"must have become a backup");
            Assertions.assertEquals((int)0, (int)primaryMoveManager.getNumberOfFolders());
        }
        finally {
            this.primaryServer.getServer().unlockActivation();
        }
        this.waitForServerToStart(this.primaryServer.getServer());
        this.primaryServer.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)primaryMoveManager.getNumberOfFolders());
        Assertions.assertTrue((!this.primaryServer.getServer().getHAPolicy().isBackup() ? 1 : 0) != 0, (String)"must be active now");
        Assertions.assertTrue((boolean)this.primaryServer.getServer().waitForActivation(15L, TimeUnit.SECONDS), (String)"Fail-back must initialize primary!");
        Assertions.assertFalse((boolean)this.primaryServer.getServer().getHAPolicy().isBackup(), (String)"must be primary!");
        int i = 0;
        while (!this.backupServer.isStarted() && i++ < 100) {
            Thread.sleep(100L);
        }
        Assertions.assertTrue((boolean)this.backupServer.getServer().isStarted());
        Assertions.assertTrue((boolean)this.primaryServer.getServer().isStarted());
        this.receiveMsgsInRange(0, 2 * this.n_msgs);
        this.assertNoMoreMessages();
    }

    @Test
    public void testMessageSync() throws Exception {
        this.createProducerSendSomeMessages();
        this.receiveMsgsInRange(0, this.n_msgs / 2);
        this.startBackupCrashPrimary();
        this.receiveMsgsInRange(this.n_msgs / 2, this.n_msgs);
        this.assertNoMoreMessages();
    }

    @Test
    public void testRemoveAllMessageWithPurgeOnNoConsumers() throws Exception {
        boolean purgeOnNoConsumers = true;
        this.createProducerSendSomeMessages();
        this.primaryServer.getServer().locateQueue(ADDRESS).setPurgeOnNoConsumers(true);
        Assertions.assertEquals((int)this.n_msgs, (int)((QueueControl)this.primaryServer.getServer().getManagementService().getResource("queue." + ADDRESS.toString())).removeAllMessages());
        this.startBackupCrashPrimary();
        this.assertNoMoreMessages();
    }

    @Test
    public void testReceiveAllMessagesWithPurgeOnNoConsumers() throws Exception {
        boolean purgeOnNoConsumers = true;
        this.createProducerSendSomeMessages();
        this.primaryServer.getServer().locateQueue(ADDRESS).setPurgeOnNoConsumers(true);
        this.receiveMsgsInRange(0, this.n_msgs);
        this.startBackupCrashPrimary();
        this.assertNoMoreMessages();
    }

    private void startBackupCrashPrimary() throws Exception {
        Assertions.assertFalse((boolean)this.backupServer.isStarted(), (String)"backup is started?");
        this.primaryServer.removeInterceptor(this.syncDelay);
        this.backupServer.start();
        this.waitForBackup(this.sessionFactory, 60);
        this.failoverWaiter.reset();
        this.crash(this.session);
        this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.failoverWaiter.waitFailoverComplete(), (String)"Session didn't failover, the maxRetryAttempts and retryInterval may be too small");
    }

    protected void createProducerSendSomeMessages() throws ActiveMQException {
        this.session = this.addClientSession(this.sessionFactory.createSession(true, true));
        this.session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        if (this.producer != null) {
            this.producer.close();
        }
        this.producer = this.addClientProducer(this.session.createProducer(ADDRESS));
        this.sendMessages(this.session, this.producer, this.n_msgs);
        this.session.commit();
    }

    protected void receiveMsgsInRange(int start, int end) throws ActiveMQException {
        this.session.start();
        ClientConsumer consumer = this.addClientConsumer(this.session.createConsumer(ADDRESS));
        this.receiveMessages(consumer, start, end, true);
        consumer.close();
        this.session.commit();
    }

    private Set<Pair<Long, Integer>> getFileIds(JournalImpl journal) {
        HashSet<Pair<Long, Integer>> results = new HashSet<Pair<Long, Integer>>();
        for (JournalFile jf : journal.getDataFiles()) {
            results.add(this.getPair(jf));
        }
        results.add(this.getPair(journal.getCurrentFile()));
        return results;
    }

    private Pair<Long, Integer> getPair(JournalFile jf) {
        return new Pair((Object)jf.getFileID(), (Object)jf.getPosCount());
    }

    static JournalImpl getMessageJournalFromServer(TestableServer server) {
        JournalStorageManager sm = (JournalStorageManager)server.getServer().getStorageManager();
        return (JournalImpl)sm.getMessageJournal();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMAcceptor(primary);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMConnector(primary);
    }

    private class FailoverWaiter
    implements FailoverEventListener {
        private final ReusableLatch latch = new ReusableLatch(1);

        FailoverWaiter() {
        }

        public void reset() {
            this.latch.setCount(0);
        }

        public void failoverEvent(FailoverEventType eventType) {
            if (eventType == FailoverEventType.FAILOVER_COMPLETED) {
                this.latch.countDown();
            }
        }

        public boolean waitFailoverComplete() throws InterruptedException {
            return this.latch.await(10L, TimeUnit.SECONDS);
        }
    }
}

