/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnector;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class FailoverTestBase
extends ActiveMQTestBase {
    protected static final SimpleString ADDRESS = SimpleString.of((String)"FailoverTestAddress");
    protected static final int MIN_LARGE_MESSAGE = 1024;
    private static final int LARGE_MESSAGE_SIZE = 3072;
    protected static final int PAGE_MAX = 2048;
    protected static final int PAGE_SIZE = 1024;
    protected TestableServer primaryServer;
    protected TestableServer backupServer;
    protected Configuration backupConfig;
    protected Configuration primaryConfig;
    protected NodeManager nodeManager;
    protected NodeManager backupNodeManager;
    protected DistributedLockManagerConfiguration managerConfiguration;
    protected boolean startBackupServer = true;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.createConfigs();
        this.setPrimaryIdentity();
        this.primaryServer.start();
        this.waitForServerToStart(this.primaryServer.getServer());
        if (this.backupServer != null) {
            this.setBackupIdentity();
            if (this.startBackupServer) {
                this.backupServer.start();
                this.waitForBackup();
            }
        }
    }

    protected void waitForBackup() {
        FailoverTestBase.waitForRemoteBackupSynchronization(this.backupServer.getServer());
    }

    protected void setBackupIdentity() {
        this.backupServer.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/backupServers");
    }

    protected void setPrimaryIdentity() {
        this.primaryServer.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/primaryServer");
    }

    protected TestableServer createTestableServer(Configuration config) throws Exception {
        return this.createTestableServer(config, this.nodeManager);
    }

    protected TestableServer createTestableServer(Configuration config, NodeManager nodeManager) throws Exception {
        boolean isBackup = config.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration || config.getHAPolicyConfiguration() instanceof SharedStoreBackupPolicyConfiguration;
        return new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config, nodeManager, isBackup ? 2 : 1));
    }

    protected TestableServer createColocatedTestableServer(Configuration config, NodeManager primaryNodeManager, NodeManager backupNodeManager, int id) {
        return new SameProcessActiveMQServer(this.createColocatedInVMFailoverServer(true, config, primaryNodeManager, backupNodeManager, id));
    }

    protected static void setLargeMessageBody(int i, ClientMessage message) {
        try {
            message.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream(3072L));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static void assertLargeMessageBody(int i, ClientMessage message) {
        ActiveMQBuffer buffer = message.getBodyBuffer();
        for (int j = 0; j < 3072; ++j) {
            Assertions.assertTrue((boolean)buffer.readable(), (String)("msg " + i + ", expecting 3072 bytes, got " + j));
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(j), (byte)buffer.readByte(), (String)("equal at " + j));
        }
    }

    protected NodeManager createNodeManager() throws Exception {
        return new InVMNodeManager(false);
    }

    protected NodeManager createNodeManager(Configuration configuration) throws Exception {
        return new InVMNodeManager(false, configuration.getNodeManagerLockLocation());
    }

    protected void createConfigs() throws Exception {
        this.nodeManager = this.createNodeManager();
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration()).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(this.createBasicClusterConfig(backupConnector.getName(), primaryConnector.getName()));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.primaryConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addClusterConfiguration(this.createBasicClusterConfig(primaryConnector.getName(), new String[0])).addConnectorConfiguration(primaryConnector.getName(), primaryConnector);
        this.primaryServer = this.createTestableServer(this.primaryConfig);
    }

    protected NodeManager createReplicatedBackupNodeManager(Configuration backupConfig) {
        return new InVMNodeManager(true, backupConfig.getJournalLocation());
    }

    protected boolean supportsRetention() {
        return true;
    }

    protected void createReplicatedConfigs() throws Exception {
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        TransportConfiguration backupAcceptor = this.getAcceptorTransportConfiguration(false);
        this.backupConfig = this.createDefaultInVMConfig();
        this.primaryConfig = this.createDefaultInVMConfig();
        ReplicatedBackupUtils.configureReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.primaryConfig, primaryConnector, null);
        this.backupConfig.setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true)).setSecurityEnabled(false);
        this.setupHAPolicyConfiguration();
        this.backupNodeManager = this.createReplicatedBackupNodeManager(this.backupConfig);
        this.backupServer = this.createTestableServer(this.backupConfig, this.backupNodeManager);
        this.primaryConfig.clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true));
        this.nodeManager = this.createNodeManager(this.primaryConfig);
        this.primaryServer = this.createTestableServer(this.primaryConfig, this.nodeManager);
        if (this.supportsRetention()) {
            this.primaryServer.getServer().getConfiguration().setJournalRetentionDirectory(this.getJournalDir(0, false) + "_retention");
            this.backupServer.getServer().getConfiguration().setJournalRetentionDirectory(this.getJournalDir(0, true) + "_retention");
        }
    }

    protected void createPluggableReplicatedConfigs() throws Exception {
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        TransportConfiguration backupAcceptor = this.getAcceptorTransportConfiguration(false);
        this.backupConfig = this.createDefaultInVMConfig();
        this.primaryConfig = this.createDefaultInVMConfig();
        this.managerConfiguration = new DistributedLockManagerConfiguration(FileBasedLockManager.class.getName(), Collections.singletonMap("locks-folder", FailoverTestBase.newFolder(this.temporaryFolder, "manager").toString()));
        ReplicatedBackupUtils.configurePluggableQuorumReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.primaryConfig, primaryConnector, null, this.managerConfiguration, this.managerConfiguration);
        this.backupConfig.setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true)).setSecurityEnabled(false);
        this.setupHAPolicyConfiguration();
        this.backupNodeManager = this.createReplicatedBackupNodeManager(this.backupConfig);
        this.backupServer = this.createTestableServer(this.backupConfig, this.backupNodeManager);
        this.primaryConfig.clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true));
        this.nodeManager = this.createNodeManager(this.primaryConfig);
        this.primaryServer = this.createTestableServer(this.primaryConfig, this.nodeManager);
    }

    protected void setupHAPolicyConfiguration() {
        Assertions.assertTrue((boolean)(this.backupConfig.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration));
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(-1).setAllowFailBack(true);
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setRestartBackup(false);
    }

    protected final void adaptPrimaryConfigForReplicatedFailBack(TestableServer server) {
        Configuration configuration = server.getServer().getConfiguration();
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        if (server.getServer().getHAPolicy().isSharedStore()) {
            ClusterConnectionConfiguration cc = (ClusterConnectionConfiguration)configuration.getClusterConfigurations().get(0);
            Assertions.assertNotNull((Object)cc, (String)"cluster connection configuration");
            Assertions.assertNotNull((Object)cc.getStaticConnectors(), (String)"static connectors");
            cc.getStaticConnectors().add(backupConnector.getName());
            configuration.getConnectorConfigurations().put(backupConnector.getName(), backupConnector);
            return;
        }
        HAPolicy policy = server.getServer().getHAPolicy();
        if (policy instanceof ReplicatedPolicy) {
            ((ReplicatedPolicy)policy).setCheckForPrimaryServer(true);
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.logAndSystemOut("#test tearDown");
        InVMConnector.failOnCreateConnection = false;
        super.tearDown();
        Assertions.assertEquals((int)0, (int)InVMRegistry.instance.size());
        this.backupServer = null;
        this.primaryServer = null;
        this.nodeManager = null;
        this.backupNodeManager = null;
        ServerSocket serverSocket = new ServerSocket(61616);
        serverSocket.close();
        serverSocket = new ServerSocket(61617);
        serverSocket.close();
    }

    protected ClientSessionFactoryInternal createSessionFactoryAndWaitForTopology(ServerLocator locator, int topologyMembers) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(topologyMembers);
        locator.addClusterTopologyListener((ClusterTopologyListener)new LatchClusterTopologyListener(countDownLatch));
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        this.addSessionFactory((ClientSessionFactory)sf);
        Assertions.assertTrue((boolean)countDownLatch.await(5L, TimeUnit.SECONDS), (String)("topology members expected " + topologyMembers));
        return sf;
    }

    protected void waitForBackup(ClientSessionFactoryInternal sessionFactory, int seconds) throws Exception {
        ActiveMQServerImpl actualServer = (ActiveMQServerImpl)this.backupServer.getServer();
        if (actualServer.getHAPolicy().isSharedStore()) {
            this.waitForServerToStart((ActiveMQServer)actualServer);
        } else {
            FailoverTestBase.waitForRemoteBackup((ClientSessionFactory)sessionFactory, seconds, true, (ActiveMQServer)actualServer);
        }
    }

    protected abstract TransportConfiguration getAcceptorTransportConfiguration(boolean var1);

    protected abstract TransportConfiguration getConnectorTransportConfiguration(boolean var1);

    protected ServerLocatorInternal getServerLocator() throws Exception {
        return (ServerLocatorInternal)this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{this.getConnectorTransportConfiguration(true), this.getConnectorTransportConfiguration(false)})).setRetryInterval(50L).setInitialConnectAttempts(50);
    }

    protected void crash(ClientSession ... sessions) throws Exception {
        this.crash(true, sessions);
    }

    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        this.crash(true, waitFailure, sessions);
    }

    protected void crash(boolean failover, boolean waitFailure, ClientSession ... sessions) throws Exception {
        this.primaryServer.crash(failover, waitFailure, sessions);
    }

    private static File newFolder(File root, String subFolder) throws IOException {
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }

    public static final class LatchClusterTopologyListener
    implements ClusterTopologyListener {
        final CountDownLatch latch;
        List<String> primaryNode = new ArrayList<String>();
        List<String> backupNode = new ArrayList<String>();

        public LatchClusterTopologyListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            if (topologyMember.getPrimary() != null && !this.primaryNode.contains(topologyMember.getPrimary().getName())) {
                this.primaryNode.add(topologyMember.getPrimary().getName());
                this.latch.countDown();
            }
            if (topologyMember.getBackup() != null && !this.backupNode.contains(topologyMember.getBackup().getName())) {
                this.backupNode.add(topologyMember.getBackup().getName());
                this.latch.countDown();
            }
        }

        public void nodeDown(long uniqueEventID, String nodeID) {
        }
    }
}

