/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.failover.ReplicatedFailoverTest;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedPagedFailoverTest
extends ReplicatedFailoverTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected ActiveMQServer createInVMFailoverServer(boolean realFiles, Configuration configuration, NodeManager nodeManager, int id) {
        return this.createInVMFailoverServer(realFiles, configuration, 1024, 2048, new HashMap<String, AddressSettings>(), nodeManager, id);
    }

    @Override
    @Test
    public void testFailWithBrowser() throws Exception {
        this.internalBrowser(0);
    }

    @Test
    public void testFailWithBrowserWithClose() throws Exception {
        this.internalBrowser(1);
    }

    @Test
    public void testFailWithBrowserWithDelete() throws Exception {
        this.internalBrowser(2);
    }

    @Override
    @Test
    @Timeout(value=120L)
    public void testReplicatedFailback() throws Exception {
        super.testReplicatedFailback();
    }

    @Override
    @Test
    @Timeout(value=120L)
    public void testFailoverOnInitialConnection() throws Exception {
        super.testFailoverOnInitialConnection();
    }

    private void internalBrowser(int tamperMode) throws Exception {
        int numMessages = 50;
        int messagesPerPage = 10;
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS).setDurable(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        Queue queue = this.primaryServer.getServer().locateQueue(FailoverTest.ADDRESS);
        queue.getPageSubscription().getPagingStore().startPaging();
        Assertions.assertNotNull((Object)queue);
        for (int i = 0; i < numMessages; ++i) {
            producer.send((Message)this.createMessage(session, i, i % 2 == 0));
            if (i <= 0 || i % messagesPerPage != 0) continue;
            queue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        try (ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS, true);){
            session.start();
            for (int i = 0; i < numMessages; ++i) {
                ClientMessage msg = consumer.receive(500L);
                Assertions.assertNotNull((Object)msg);
            }
        }
        PagingStore store = queue.getPageSubscription().getPagingStore();
        if (tamperMode == 1) {
            for (long pageID = store.getFirstPage(); pageID <= store.getCurrentPage().getPageId() + 10L; ++pageID) {
                this.primaryServer.getServer().getStorageManager().pageClosed(store.getStoreName(), (long)((int)pageID));
            }
        } else if (tamperMode == 2) {
            for (long pageID = store.getFirstPage(); pageID <= store.getCurrentPage().getPageId() + 10L; ++pageID) {
                this.primaryServer.getServer().getStorageManager().pageDeleted(store.getStoreName(), (long)((int)pageID));
            }
        }
        try (ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS, false);){
            session.start();
            for (int i = 0; i < numMessages; ++i) {
                ClientMessage msg = consumer.receive(500L);
                if (msg == null) {
                    break;
                }
                msg.acknowledge();
            }
        }
        Wait.assertFalse(() -> ((PagingStore)queue.getPageSubscription().getPagingStore()).isPaging());
    }
}

