/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.lockmanager;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FakeServiceComponent;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class LockManagerBackupAuthenticationTest
extends FailoverTestBase {
    private static CountDownLatch registrationStarted;
    @Parameter(index=0)
    public boolean useNetty;

    @Parameters(name="useNetty={1}")
    public static Iterable<Object[]> getParams() {
        return Arrays.asList({false}, {true});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.startBackupServer = false;
        registrationStarted = new CountDownLatch(1);
        super.setUp();
    }

    @TestTemplate
    public void testWrongPasswordSetting() throws Exception {
        FakeServiceComponent fakeServiceComponent = new FakeServiceComponent("fake web server");
        Wait.assertTrue(() -> ((ActiveMQServer)this.primaryServer.getServer()).isActive());
        this.waitForServerToStart(this.primaryServer.getServer());
        this.backupServer.start();
        this.backupServer.getServer().addExternalComponent((ActiveMQComponent)fakeServiceComponent, true);
        Assertions.assertTrue((boolean)registrationStarted.await(5L, TimeUnit.SECONDS));
        Wait.waitFor(() -> !this.backupServer.isStarted());
        Assertions.assertFalse((boolean)this.backupServer.isStarted(), (String)"backup should have stopped");
        Wait.assertFalse(fakeServiceComponent::isStarted);
        this.backupServer.stop();
        this.primaryServer.stop();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
        this.backupConfig.setClusterPassword("crocodile");
        this.primaryConfig.setIncomingInterceptorClassNames(Arrays.asList(NotifyingInterceptor.class.getName()));
        this.backupConfig.setSecurityEnabled(true);
        this.primaryConfig.setSecurityEnabled(true);
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.useNetty ? this.getNettyAcceptorTransportConfiguration(live) : TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.useNetty ? this.getNettyConnectorTransportConfiguration(live) : TransportConfigurationUtils.getInVMConnector(live);
    }

    public static final class NotifyingInterceptor
    implements Interceptor {
        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 115) {
                registrationStarted.countDown();
            } else if (packet.getType() == 125) {
                registrationStarted.countDown();
            }
            return true;
        }
    }
}

