/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StoreConfigTest
extends JMSTestBase {
    @Override
    protected boolean usePersistence() {
        return true;
    }

    @Test
    public void testCreateCF() throws Exception {
        this.server.getConfiguration().getConnectorConfigurations().put("tst", new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        this.server.getConfiguration().getConnectorConfigurations().put("np", new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        ArrayList<String> transportConfigurations = new ArrayList<String>();
        transportConfigurations.add("tst");
        ConnectionFactoryConfigurationImpl factCFG = (ConnectionFactoryConfigurationImpl)new ConnectionFactoryConfigurationImpl().setName("tst").setConnectorNames(transportConfigurations);
        this.jmsServer.createConnectionFactory(true, (ConnectionFactoryConfiguration)factCFG, new String[]{"/someCF", "/someCF2"});
        ConnectionFactoryConfigurationImpl nonPersisted = (ConnectionFactoryConfigurationImpl)new ConnectionFactoryConfigurationImpl().setName("np").setConnectorNames(transportConfigurations);
        this.jmsServer.createConnectionFactory(false, (ConnectionFactoryConfiguration)nonPersisted, new String[]{"/nonPersisted"});
        try {
            this.jmsServer.addConnectionFactoryToBindingRegistry("np", "/someCF");
            Assertions.fail((String)"Failure expected and the API let duplicates");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.openCon("/someCF");
        this.openCon("/someCF2");
        this.openCon("/nonPersisted");
        this.jmsServer.stop();
        this.jmsServer.start();
        this.openCon("/someCF");
        this.openCon("/someCF2");
        this.assertNullJNDI("/nonPersisted");
        this.jmsServer.stop();
        this.jmsServer.start();
        this.jmsServer.addConnectionFactoryToBindingRegistry("tst", "/newJNDI");
        try {
            this.jmsServer.addConnectionFactoryToBindingRegistry("tst", "/newJNDI");
            Assertions.fail((String)"Failure expected and the API let duplicates");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.openCon("/someCF");
        this.openCon("/someCF2");
        this.openCon("/newJNDI");
        this.assertNullJNDI("/nonPersisted");
        this.jmsServer.stop();
        this.assertNullJNDI("/newJNDI");
        this.jmsServer.start();
        this.openCon("/someCF");
        this.openCon("/someCF2");
        this.openCon("/newJNDI");
    }

    @Test
    public void testCreateTopic() throws Exception {
        this.server.getConfiguration().getConnectorConfigurations().put("tst", new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        this.server.getConfiguration().getConnectorConfigurations().put("np", new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        ArrayList<String> transportConfigurations = new ArrayList<String>();
        transportConfigurations.add("tst");
        ConnectionFactoryConfigurationImpl factCFG = (ConnectionFactoryConfigurationImpl)new ConnectionFactoryConfigurationImpl().setName("tst").setConnectorNames(transportConfigurations);
        this.jmsServer.createConnectionFactory(true, (ConnectionFactoryConfiguration)factCFG, new String[]{"/someCF"});
        Assertions.assertTrue((boolean)this.jmsServer.createTopic(true, "topicOne", new String[]{"/t1", "/t.1"}));
        Assertions.assertTrue((boolean)this.jmsServer.createTopic(false, "topicTwo", new String[]{"/t2", "/t.2"}));
        Assertions.assertFalse((boolean)this.jmsServer.createTopic(false, "topicOne", new String[]{"/z1", "z2"}));
        this.assertNullJNDI("/z1");
        this.assertNullJNDI("/z2");
        this.checkDestination("/t1");
        this.checkDestination("/t.1");
        this.checkDestination("/t2");
        this.checkDestination("/t.2");
        this.jmsServer.stop();
        this.assertNullJNDI("/t1");
        this.assertNullJNDI("/t.1");
        this.assertNullJNDI("/t2");
        this.assertNullJNDI("/t.2");
        this.jmsServer.start();
        this.checkDestination("/t1");
        this.checkDestination("/t.1");
        this.assertNullJNDI("/t2");
        this.assertNullJNDI("/t.2");
        this.jmsServer.addTopicToBindingRegistry("topicOne", "/tI");
        this.jmsServer.stop();
        this.jmsServer.start();
        this.checkDestination("/tI");
        this.checkDestination("/t1");
        this.checkDestination("/t.1");
        this.assertNullJNDI("/t2");
        this.assertNullJNDI("/t.2");
        Assertions.assertTrue((boolean)this.jmsServer.removeTopicFromBindingRegistry("topicOne", "/tI"));
        Assertions.assertFalse((boolean)this.jmsServer.removeTopicFromBindingRegistry("topicOne", "nothing"));
        Assertions.assertFalse((boolean)this.jmsServer.removeTopicFromBindingRegistry("nothing", "nothing"));
        Assertions.assertFalse((boolean)this.jmsServer.removeTopicFromBindingRegistry("nothing"));
        this.assertNullJNDI("/tI");
        this.checkDestination("/t1");
        this.checkDestination("/t.1");
        this.jmsServer.stop();
        this.jmsServer.start();
        this.assertNullJNDI("/tI");
        this.checkDestination("/t1");
        this.checkDestination("/t.1");
        this.jmsServer.removeTopicFromBindingRegistry("topicOne");
        Assertions.assertTrue((boolean)this.jmsServer.createTopic(true, "topicOne", new String[]{"/topicx.1", "/topicx.2"}));
        this.jmsServer.stop();
        this.jmsServer.start();
        this.checkDestination("/topicx.1");
        this.checkDestination("/topicx.2");
    }

    private void checkDestination(String name) throws Exception {
        ConnectionFactory cf = (ConnectionFactory)this.namingContext.lookup("/someCF");
        Connection conn = cf.createConnection();
        Session sess = conn.createSession(false, 1);
        Destination dest = (Destination)this.namingContext.lookup(name);
        conn.start();
        MessageConsumer cons = sess.createConsumer(dest);
        MessageProducer prod = sess.createProducer(dest);
        prod.send(sess.createMessage());
        Assertions.assertNotNull((Object)cons.receiveNoWait());
        conn.close();
    }

    @Test
    public void testCreateQueue() throws Exception {
        this.server.getConfiguration().getConnectorConfigurations().put("tst", new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        ArrayList<String> transportConfigurations = new ArrayList<String>();
        transportConfigurations.add("tst");
        ConnectionFactoryConfigurationImpl factCFG = (ConnectionFactoryConfigurationImpl)new ConnectionFactoryConfigurationImpl().setName("tst").setConnectorNames(transportConfigurations);
        this.jmsServer.createConnectionFactory(true, (ConnectionFactoryConfiguration)factCFG, new String[]{"/someCF"});
        Assertions.assertTrue((boolean)this.jmsServer.createQueue(true, "queue1", null, true, new String[]{"/q1", "/q.1"}));
        Assertions.assertFalse((boolean)this.jmsServer.createQueue(true, "queue1", "someWeirdThing", true, new String[]{"/qx", "/qz"}));
        this.assertNullJNDI("/qx");
        this.assertNullJNDI("/qz");
        Assertions.assertTrue((boolean)this.jmsServer.createQueue(false, "queue2", null, true, new String[]{"/q2", "/q.2"}));
        this.checkDestination("/q1");
        this.checkDestination("/q.1");
        this.checkDestination("/q2");
        this.checkDestination("/q.2");
        this.jmsServer.stop();
        this.assertNullJNDI("/q1");
        this.assertNullJNDI("/q1.1");
        this.assertNullJNDI("/qI");
        this.assertNullJNDI("/q2");
        this.assertNullJNDI("/q.2");
        this.jmsServer.start();
        this.checkDestination("/q1");
        this.checkDestination("/q.1");
        this.assertNullJNDI("/q2");
        this.assertNullJNDI("/q.2");
        this.jmsServer.addQueueToBindingRegistry("queue1", "/qI");
        this.jmsServer.stop();
        this.jmsServer.start();
        this.checkDestination("/qI");
        this.checkDestination("/q1");
        this.checkDestination("/q.1");
        this.assertNullJNDI("/q2");
        this.assertNullJNDI("/q.2");
        Assertions.assertTrue((boolean)this.jmsServer.removeQueueFromBindingRegistry("queue1", "/q1"));
        Assertions.assertFalse((boolean)this.jmsServer.removeQueueFromBindingRegistry("queue1", "nothing"));
        this.assertNullJNDI("/q1");
        this.checkDestination("/q.1");
        this.checkDestination("/qI");
        this.jmsServer.stop();
        this.jmsServer.start();
        this.assertNullJNDI("/q1");
        this.checkDestination("/q.1");
        this.checkDestination("/qI");
        this.jmsServer.removeQueueFromBindingRegistry("queue1");
        Assertions.assertTrue((boolean)this.jmsServer.createQueue(true, "queue1", null, true, new String[]{"/newq1", "/newq.1"}));
        this.assertNullJNDI("/q1");
        this.assertNullJNDI("/q.1");
        this.assertNullJNDI("/qI");
        this.checkDestination("/newq1");
        this.checkDestination("newq.1");
        this.jmsServer.stop();
    }

    private void assertNullJNDI(String name) {
        Object obj = null;
        try {
            obj = this.namingContext.lookup(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertNull(obj);
    }

    private void openCon(String name) throws NamingException, JMSException {
        ConnectionFactory cf = (ConnectionFactory)this.namingContext.lookup(name);
        Connection conn = cf.createConnection();
        conn.createSession(false, 1);
        conn.close();
    }
}

