/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.tests.integration.jms.server.management.JMSUtil;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.InVMNodeManagerServer;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSFailoverListenerTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Configuration backupConf;
    protected Configuration primaryConf;
    protected ActiveMQServer primaryServer;
    protected ActiveMQServer backupServer;
    protected Map<String, Object> backupParams = new HashMap<String, Object>();
    private TransportConfiguration backuptc;
    private TransportConfiguration primarytc;
    private TransportConfiguration primaryAcceptortc;
    private TransportConfiguration backupAcceptortc;

    @Test
    public void testAutomaticFailover() throws Exception {
        BytesMessage bm;
        int i;
        ActiveMQConnectionFactory jbcf = ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.primarytc});
        jbcf.setReconnectAttempts(-1);
        jbcf.setRetryInterval(100L);
        jbcf.setConnectionTTL(500L);
        jbcf.setClientFailureCheckPeriod(100L);
        jbcf.setBlockOnDurableSend(true);
        jbcf.setBlockOnNonDurableSend(true);
        jbcf.setCallTimeout(1000L);
        int numMessages = 10;
        int bodySize = 1000;
        jbcf.setConsumerWindowSize(1000);
        ActiveMQConnection conn = JMSUtil.createConnectionAndWaitForTopology(jbcf, 2, 5);
        MyFailoverListener listener = new MyFailoverListener();
        conn.setFailoverListener((FailoverEventListener)listener);
        Session sess = conn.createSession(false, 1);
        ClientSession coreSession = ((ActiveMQSession)sess).getCoreSession();
        SimpleString jmsQueueName = SimpleString.of((String)"myqueue");
        coreSession.createQueue(QueueConfiguration.of((SimpleString)jmsQueueName).setRoutingType(RoutingType.ANYCAST));
        jakarta.jms.Queue queue = sess.createQueue("myqueue");
        MessageProducer producer = sess.createProducer((Destination)queue);
        producer.setDeliveryMode(2);
        MessageConsumer consumer = sess.createConsumer((Destination)queue);
        byte[] body = RandomUtil.randomBytes((int)1000);
        for (i = 0; i < 10; ++i) {
            bm = sess.createBytesMessage();
            bm.writeBytes(body);
            producer.send((Message)bm);
        }
        Wait.assertEquals((long)10L, () -> ((Queue)this.primaryServer.locateQueue(jmsQueueName)).getMessageCount());
        conn.start();
        logger.debug("sent messages and started connection");
        JMSUtil.crash(this.primaryServer, ((ActiveMQSession)sess).getCoreSession());
        Wait.assertTrue(() -> FailoverEventType.FAILURE_DETECTED == listener.get(0));
        for (i = 0; i < 10; ++i) {
            logger.debug("got message {}", (Object)i);
            bm = (BytesMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)bm);
            Assertions.assertEquals((long)body.length, (long)bm.getBodyLength());
        }
        TextMessage tm = (TextMessage)consumer.receiveNoWait();
        Assertions.assertNull((Object)tm);
        Assertions.assertEquals((Object)FailoverEventType.FAILOVER_COMPLETED, (Object)listener.get(1));
        conn.close();
        Assertions.assertEquals((int)2, (int)listener.size(), (String)"Expected 2 FailoverEvents to be triggered");
    }

    @Test
    public void testManualFailover() throws Exception {
        ActiveMQConnectionFactory jbcfPrimary = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        jbcfPrimary.setBlockOnNonDurableSend(true);
        jbcfPrimary.setBlockOnDurableSend(true);
        jbcfPrimary.setCallTimeout(1000L);
        ActiveMQConnectionFactory jbcfBackup = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY, this.backupParams)});
        jbcfBackup.setBlockOnNonDurableSend(true);
        jbcfBackup.setBlockOnDurableSend(true);
        jbcfBackup.setInitialConnectAttempts(-1);
        jbcfBackup.setReconnectAttempts(-1);
        jbcfBackup.setRetryInterval(100L);
        ActiveMQConnection connPrimary = (ActiveMQConnection)jbcfPrimary.createConnection();
        MyFailoverListener listener = new MyFailoverListener();
        connPrimary.setFailoverListener((FailoverEventListener)listener);
        Session sessPrimary = connPrimary.createSession(false, 1);
        ClientSession coreSessionPrimary = ((ActiveMQSession)sessPrimary).getCoreSession();
        SimpleString jmsQueueName = SimpleString.of((String)"myqueue");
        coreSessionPrimary.createQueue(QueueConfiguration.of((SimpleString)jmsQueueName).setRoutingType(RoutingType.ANYCAST));
        jakarta.jms.Queue queue = sessPrimary.createQueue("myqueue");
        int numMessages = 1000;
        MessageProducer producerPrimary = sessPrimary.createProducer((Destination)queue);
        for (int i = 0; i < 1000; ++i) {
            TextMessage tm = sessPrimary.createTextMessage("message" + i);
            producerPrimary.send((Message)tm);
        }
        JMSUtil.crash(this.primaryServer, coreSessionPrimary);
        Assertions.assertEquals((Object)FailoverEventType.FAILURE_DETECTED, (Object)listener.get(0));
        connPrimary.close();
        Connection connBackup = jbcfBackup.createConnection();
        Session sessBackup = connBackup.createSession(false, 1);
        MessageConsumer consumerBackup = sessBackup.createConsumer((Destination)queue);
        connBackup.start();
        for (int i = 0; i < 1000; ++i) {
            TextMessage tm = (TextMessage)consumerBackup.receive(1000L);
            Assertions.assertNotNull((Object)tm);
            Assertions.assertEquals((Object)("message" + i), (Object)tm.getText());
        }
        TextMessage tm = (TextMessage)consumerBackup.receiveNoWait();
        Assertions.assertEquals((Object)FailoverEventType.FAILOVER_FAILED, (Object)listener.get(1));
        Assertions.assertEquals((int)2, (int)listener.size(), (String)"Expected 2 FailoverEvents to be triggered");
        Assertions.assertNull((Object)tm);
        connBackup.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.startServers();
    }

    protected void startServers() throws Exception {
        InVMNodeManager nodeManager = new InVMNodeManager(false);
        this.backuptc = new TransportConfiguration(INVM_CONNECTOR_FACTORY, this.backupParams);
        this.primarytc = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        this.primaryAcceptortc = new TransportConfiguration(INVM_ACCEPTOR_FACTORY);
        this.backupAcceptortc = new TransportConfiguration(INVM_ACCEPTOR_FACTORY, this.backupParams);
        this.backupParams.put("serverId", 1);
        this.backupConf = this.createBasicConfig().addAcceptorConfiguration(this.backupAcceptortc).addConnectorConfiguration(this.primarytc.getName(), this.primarytc).addConnectorConfiguration(this.backuptc.getName(), this.backuptc).setJournalType(JMSFailoverListenerTest.getDefaultJournalType()).addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY, this.backupParams)).setBindingsDirectory(this.getBindingsDir()).setJournalMinFiles(2).setJournalDirectory(this.getJournalDir()).setPagingDirectory(this.getPageDir()).setLargeMessagesDirectory(this.getLargeMessagesDir()).setPersistenceEnabled(true).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration()).addClusterConfiguration(JMSFailoverListenerTest.basicClusterConnectionConfig(this.primarytc.getName(), this.backuptc.getName()));
        this.backupConf.setConnectionTtlCheckInterval(100L);
        this.backupServer = this.addServer((ActiveMQServer)new InVMNodeManagerServer(this.backupConf, (NodeManager)nodeManager));
        this.backupServer.setIdentity("JMSBackup");
        logger.debug("Starting backup");
        this.backupServer.start();
        this.primaryConf = this.createBasicConfig().setJournalDirectory(this.getJournalDir()).setBindingsDirectory(this.getBindingsDir()).addAcceptorConfiguration(this.primaryAcceptortc).setJournalType(JMSFailoverListenerTest.getDefaultJournalType()).setBindingsDirectory(this.getBindingsDir()).setJournalMinFiles(2).setJournalDirectory(this.getJournalDir()).setPagingDirectory(this.getPageDir()).setLargeMessagesDirectory(this.getLargeMessagesDir()).addConnectorConfiguration(this.primarytc.getName(), this.primarytc).setPersistenceEnabled(true).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addClusterConfiguration(JMSFailoverListenerTest.basicClusterConnectionConfig(this.primarytc.getName(), new String[0]));
        this.primaryConf.setConnectionTtlCheckInterval(100L);
        this.primaryServer = this.addServer((ActiveMQServer)new InVMNodeManagerServer(this.primaryConf, (NodeManager)nodeManager));
        this.primaryServer.setIdentity("JMSPrimary");
        logger.debug("Starting life");
        this.primaryServer.start();
        JMSUtil.waitForServer(this.backupServer);
    }

    private static class MyFailoverListener
    implements FailoverEventListener {
        private List<FailoverEventType> eventTypeList = new ArrayList<FailoverEventType>();

        private MyFailoverListener() {
        }

        public FailoverEventType get(int element) {
            this.waitForElements(element + 1);
            return this.eventTypeList.get(element);
        }

        public int size() {
            return this.eventTypeList.size();
        }

        private void waitForElements(int elements) {
            long timeout = System.currentTimeMillis() + 5000L;
            while (timeout > System.currentTimeMillis() && this.eventTypeList.size() < elements) {
                try {
                    Thread.sleep(1L);
                }
                catch (Throwable e) {
                    Assertions.fail((String)e.getMessage());
                }
            }
            Assertions.assertTrue((this.eventTypeList.size() >= elements ? 1 : 0) != 0);
        }

        public void failoverEvent(FailoverEventType eventType) {
            this.eventTypeList.add(eventType);
        }
    }
}

