/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.consumer;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConsumerTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String Q_NAME = "ConsumerTestQueue";
    private static final String T_NAME = "ConsumerTestTopic";
    private static final String T2_NAME = "ConsumerTestTopic2";
    private jakarta.jms.Queue jBossQueue;
    private Topic topic;
    private Topic topic2;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.topic = ActiveMQJMSClient.createTopic((String)T_NAME);
        this.topic2 = ActiveMQJMSClient.createTopic((String)T2_NAME);
        this.jmsServer.createQueue(false, Q_NAME, null, true, new String[]{Q_NAME});
        this.jmsServer.createTopic(true, T_NAME, new String[]{"/topic/ConsumerTestTopic"});
        this.jmsServer.createTopic(true, T2_NAME, new String[]{"/topic/ConsumerTestTopic2"});
        this.cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
    }

    @Test
    public void testTransactionalSessionRollback() throws Exception {
        this.conn = this.cf.createConnection();
        Session sess = this.conn.createSession(true, 0);
        MessageProducer prod = sess.createProducer((Destination)this.topic);
        MessageConsumer cons = sess.createConsumer((Destination)this.topic);
        this.conn.start();
        TextMessage msg1 = sess.createTextMessage("m1");
        TextMessage msg2 = sess.createTextMessage("m2");
        TextMessage msg3 = sess.createTextMessage("m3");
        prod.send((Message)msg1);
        sess.commit();
        prod.send((Message)msg2);
        sess.rollback();
        prod.send((Message)msg3);
        sess.commit();
        TextMessage m1 = (TextMessage)cons.receive(2000L);
        Assertions.assertNotNull((Object)m1);
        Assertions.assertEquals((Object)"m1", (Object)m1.getText());
        TextMessage m2 = (TextMessage)cons.receive(2000L);
        Assertions.assertNotNull((Object)m2);
        Assertions.assertEquals((Object)"m3", (Object)m2.getText());
        TextMessage m3 = (TextMessage)cons.receive(2000L);
        Assertions.assertNull((Object)m3, (String)"m3 should be null");
        logger.debug("received m1: {}", (Object)m1.getText());
        logger.debug("received m2: {}", (Object)m2.getText());
        logger.debug("received m3: {}", (Object)m3);
        sess.commit();
    }

    @Test
    public void testPreCommitAcks() throws Exception {
        int i;
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 100);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageProducer producer = session.createProducer((Destination)this.jBossQueue);
        MessageConsumer consumer = session.createConsumer((Destination)this.jBossQueue);
        int noOfMessages = 100;
        for (i = 0; i < noOfMessages; ++i) {
            producer.send((Message)session.createTextMessage("m" + i));
        }
        this.conn.start();
        for (i = 0; i < noOfMessages; ++i) {
            Message m = consumer.receive(500L);
            Assertions.assertNotNull((Object)m);
        }
        SimpleString queueName = SimpleString.of((String)Q_NAME);
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(queueName).getBindable()));
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(queueName).getBindable()));
    }

    @Test
    public void testIndividualACK() throws Exception {
        Message m;
        int i;
        Connection conn = this.cf.createConnection();
        Session session = conn.createSession(false, 101);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageProducer producer = session.createProducer((Destination)this.jBossQueue);
        MessageConsumer consumer = session.createConsumer((Destination)this.jBossQueue);
        int noOfMessages = 100;
        for (i = 0; i < noOfMessages; ++i) {
            producer.send((Message)session.createTextMessage("m" + i));
        }
        conn.start();
        for (i = 0; i < noOfMessages; ++i) {
            m = consumer.receive(500L);
            Assertions.assertNotNull((Object)m);
            if (i % 2 != 0) continue;
            m.acknowledge();
        }
        session.close();
        session = conn.createSession(false, 101);
        consumer = session.createConsumer((Destination)this.jBossQueue);
        for (i = 0; i < noOfMessages; ++i) {
            if (i % 2 == 0) continue;
            m = (TextMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
            Assertions.assertEquals((Object)("m" + i), (Object)m.getText());
        }
        SimpleString queueName = SimpleString.of((String)Q_NAME);
        conn.close();
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(queueName).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(queueName).getBindable()));
    }

    @Test
    public void testIndividualACKJms2() throws Exception {
        Message m;
        int i;
        JMSContext context = this.cf.createContext(101);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        JMSProducer producer = context.createProducer();
        JMSConsumer consumer = context.createConsumer((Destination)this.jBossQueue);
        int noOfMessages = 100;
        for (i = 0; i < noOfMessages; ++i) {
            producer.send((Destination)this.jBossQueue, (Message)context.createTextMessage("m" + i));
        }
        context.start();
        for (i = 0; i < noOfMessages; ++i) {
            m = consumer.receive(500L);
            Assertions.assertNotNull((Object)m);
            if (i % 2 != 0) continue;
            m.acknowledge();
        }
        context.close();
        context = this.cf.createContext(101);
        consumer = context.createConsumer((Destination)this.jBossQueue);
        for (i = 0; i < noOfMessages; ++i) {
            if (i % 2 == 0) continue;
            m = (TextMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
            Assertions.assertEquals((Object)("m" + i), (Object)m.getText());
        }
        SimpleString queueName = SimpleString.of((String)Q_NAME);
        context.close();
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(queueName).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(queueName).getBindable()));
    }

    @Test
    public void testIndividualACKMessageConsumer() throws Exception {
        Connection conn = this.cf.createConnection();
        Session session = conn.createSession(false, 101);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageProducer producer = session.createProducer((Destination)this.jBossQueue);
        MessageConsumer consumer = session.createConsumer((Destination)this.jBossQueue);
        int noOfMessages = 100;
        for (int i = 0; i < noOfMessages; ++i) {
            producer.setPriority(2);
            producer.send((Message)session.createTextMessage("m" + i));
        }
        conn.start();
        final AtomicInteger errors = new AtomicInteger(0);
        final ReusableLatch latch = new ReusableLatch();
        latch.setCount(noOfMessages);
        class MessageAckEven
        implements MessageListener {
            int count = 0;

            MessageAckEven() {
            }

            public void onMessage(Message msg) {
                try {
                    TextMessage txtmsg = (TextMessage)msg;
                    if (!txtmsg.getText().equals("m" + this.count)) {
                        errors.incrementAndGet();
                    }
                    if (this.count % 2 == 0) {
                        msg.acknowledge();
                    }
                    ++this.count;
                }
                catch (Exception e) {
                    errors.incrementAndGet();
                }
                finally {
                    latch.countDown();
                }
            }
        }
        consumer.setMessageListener((MessageListener)new MessageAckEven());
        Assertions.assertTrue((boolean)latch.await(5000L));
        session.close();
        session = conn.createSession(false, 101);
        consumer = session.createConsumer((Destination)this.jBossQueue);
        for (int i = 0; i < noOfMessages; ++i) {
            if (i % 2 == 0) continue;
            TextMessage m = (TextMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
            Assertions.assertEquals((Object)("m" + i), (Object)m.getText());
        }
        SimpleString queueName = SimpleString.of((String)Q_NAME);
        conn.close();
        Queue queue = this.server.locateQueue(queueName);
        Wait.assertEquals((int)0, () -> ((Queue)queue).getDeliveringCount());
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    public void testPreCommitAcksSetOnConnectionFactory() throws Exception {
        int i;
        ((ActiveMQConnectionFactory)this.cf).setPreAcknowledge(true);
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 2);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageProducer producer = session.createProducer((Destination)this.jBossQueue);
        MessageConsumer consumer = session.createConsumer((Destination)this.jBossQueue);
        int noOfMessages = 100;
        for (i = 0; i < noOfMessages; ++i) {
            producer.send((Message)session.createTextMessage("m" + i));
        }
        this.conn.start();
        for (i = 0; i < noOfMessages; ++i) {
            Message m = consumer.receive(500L);
            Assertions.assertNotNull((Object)m);
        }
        SimpleString queueName = SimpleString.of((String)Q_NAME);
        Queue queue = this.server.locateQueue(queueName);
        Wait.assertEquals((int)0, () -> ((Queue)queue).getDeliveringCount());
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    public void testPreCommitAcksWithMessageExpiry() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 100);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageProducer producer = session.createProducer((Destination)this.jBossQueue);
        MessageConsumer consumer = session.createConsumer((Destination)this.jBossQueue);
        int noOfMessages = 1000;
        for (int i = 0; i < noOfMessages; ++i) {
            TextMessage textMessage = session.createTextMessage("m" + i);
            producer.setTimeToLive(1L);
            producer.send((Message)textMessage);
        }
        Thread.sleep(2L);
        this.conn.start();
        Message m = consumer.receiveNoWait();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testPreCommitAcksWithMessageExpirySetOnConnectionFactory() throws Exception {
        ((ActiveMQConnectionFactory)this.cf).setPreAcknowledge(true);
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 2);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageProducer producer = session.createProducer((Destination)this.jBossQueue);
        MessageConsumer consumer = session.createConsumer((Destination)this.jBossQueue);
        int noOfMessages = 1000;
        for (int i = 0; i < noOfMessages; ++i) {
            TextMessage textMessage = session.createTextMessage("m" + i);
            producer.setTimeToLive(1L);
            producer.send((Message)textMessage);
        }
        Thread.sleep(2L);
        this.conn.start();
        Message m = consumer.receiveNoWait();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testBrowserAndConsumerSimultaneous() throws Exception {
        int i;
        ((ActiveMQConnectionFactory)this.cf).setConsumerWindowSize(0);
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageProducer producer = session.createProducer((Destination)this.jBossQueue);
        QueueBrowser browser = session.createBrowser(this.jBossQueue);
        Enumeration enumMessages = browser.getEnumeration();
        MessageConsumer consumer = session.createConsumer((Destination)this.jBossQueue);
        int noOfMessages = 10;
        for (i = 0; i < noOfMessages; ++i) {
            TextMessage textMessage = session.createTextMessage("m" + i);
            textMessage.setIntProperty("i", i);
            producer.send((Message)textMessage);
        }
        this.conn.start();
        for (i = 0; i < noOfMessages; ++i) {
            TextMessage msg = (TextMessage)enumMessages.nextElement();
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("i"));
            this.conn.start();
            TextMessage recvMessage = (TextMessage)consumer.receiveNoWait();
            Assertions.assertNotNull((Object)recvMessage);
            this.conn.stop();
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("i"));
        }
        Assertions.assertNull((Object)consumer.receiveNoWait());
        Assertions.assertFalse((boolean)enumMessages.hasMoreElements());
        this.conn.close();
    }

    @Test
    public void testBrowserAndConsumerSimultaneousDifferentConnections() throws Exception {
        ((ActiveMQConnectionFactory)this.cf).setConsumerWindowSize(0);
        this.conn = this.cf.createConnection();
        Connection connConsumer = this.cf.createConnection();
        Session sessionConsumer = connConsumer.createSession(false, 1);
        Session session = this.conn.createSession(false, 1);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageProducer producer = session.createProducer((Destination)this.jBossQueue);
        MessageConsumer consumer = sessionConsumer.createConsumer((Destination)this.jBossQueue);
        int noOfMessages = 1000;
        for (int i = 0; i < noOfMessages; ++i) {
            TextMessage textMessage = session.createTextMessage("m" + i);
            textMessage.setIntProperty("i", i);
            producer.send((Message)textMessage);
        }
        connConsumer.start();
        QueueBrowser browser = session.createBrowser(this.jBossQueue);
        Enumeration enumMessages = browser.getEnumeration();
        for (int i = 0; i < noOfMessages; ++i) {
            TextMessage msg = (TextMessage)enumMessages.nextElement();
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("i"));
            TextMessage recvMessage = (TextMessage)consumer.receiveNoWait();
            Assertions.assertNotNull((Object)recvMessage);
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("i"));
        }
        Message m = consumer.receiveNoWait();
        Assertions.assertFalse((boolean)enumMessages.hasMoreElements());
        Assertions.assertNull((Object)m);
        this.conn.close();
    }

    @Test
    public void testBrowserOnly() throws Exception {
        ((ActiveMQConnectionFactory)this.cf).setConsumerWindowSize(0);
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageProducer producer = session.createProducer((Destination)this.jBossQueue);
        int noOfMessages = 10;
        for (int i = 0; i < noOfMessages; ++i) {
            TextMessage textMessage = session.createTextMessage("m" + i);
            textMessage.setIntProperty("i", i);
            producer.send((Message)textMessage);
        }
        QueueBrowser browser = session.createBrowser(this.jBossQueue);
        Enumeration enumMessages = browser.getEnumeration();
        for (int i = 0; i < noOfMessages; ++i) {
            Assertions.assertTrue((boolean)enumMessages.hasMoreElements());
            TextMessage msg = (TextMessage)enumMessages.nextElement();
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("i"));
        }
        Assertions.assertFalse((boolean)enumMessages.hasMoreElements());
        this.conn.close();
    }

    @Test
    public void testClearExceptionListener() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageConsumer consumer = session.createConsumer((Destination)this.jBossQueue);
        consumer.setMessageListener(msg -> {});
        consumer.setMessageListener(null);
        consumer.receiveNoWait();
    }

    @Test
    public void testCantReceiveWhenListenerIsSet() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        this.jBossQueue = ActiveMQJMSClient.createQueue((String)Q_NAME);
        MessageConsumer consumer = session.createConsumer((Destination)this.jBossQueue);
        consumer.setMessageListener(msg -> {});
        try {
            consumer.receiveNoWait();
            Assertions.fail((String)"Should throw exception");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    @Test
    public void testSharedConsumer() throws Exception {
        this.conn = this.cf.createConnection();
        this.conn.start();
        Session session = this.conn.createSession(false, 1);
        this.topic = ActiveMQJMSClient.createTopic((String)T_NAME);
        MessageConsumer cons = session.createSharedConsumer(this.topic, "test1");
        MessageProducer producer = session.createProducer((Destination)this.topic);
        producer.send((Message)session.createTextMessage("test"));
        TextMessage txt = (TextMessage)cons.receive(5000L);
        Assertions.assertNotNull((Object)txt);
    }

    @Test
    public void testSharedDurableConsumer() throws Exception {
        this.conn = this.cf.createConnection();
        this.conn.start();
        Session session = this.conn.createSession(false, 1);
        this.topic = ActiveMQJMSClient.createTopic((String)T_NAME);
        MessageConsumer cons = session.createSharedDurableConsumer(this.topic, "test1");
        MessageProducer producer = session.createProducer((Destination)this.topic);
        producer.send((Message)session.createTextMessage("test"));
        TextMessage txt = (TextMessage)cons.receive(5000L);
        Assertions.assertNotNull((Object)txt);
    }

    @Test
    public void testSharedDurableConsumerWithClientID() throws Exception {
        this.conn = this.cf.createConnection();
        this.conn.setClientID("C1");
        this.conn.start();
        Session session = this.conn.createSession(false, 1);
        Connection conn2 = this.cf.createConnection();
        conn2.setClientID("C2");
        Session session2 = conn2.createSession(false, 1);
        Connection conn3 = this.cf.createConnection();
        boolean exception = false;
        try {
            conn3.setClientID("C2");
        }
        catch (Exception e) {
            exception = true;
        }
        Assertions.assertTrue((boolean)exception);
        conn3.close();
        this.topic = ActiveMQJMSClient.createTopic((String)T_NAME);
        MessageConsumer cons = session.createSharedDurableConsumer(this.topic, "test1");
        MessageProducer producer = session.createProducer((Destination)this.topic);
        producer.send((Message)session.createTextMessage("test"));
        TextMessage txt = (TextMessage)cons.receive(5000L);
        Assertions.assertNotNull((Object)txt);
    }

    @Test
    public void testValidateExceptionsThroughSharedConsumers() throws Exception {
        this.conn = this.cf.createConnection();
        this.conn.setClientID("C1");
        this.conn.start();
        Session session = this.conn.createSession(false, 1);
        Connection conn2 = this.cf.createConnection();
        conn2.setClientID("C2");
        MessageConsumer cons = session.createSharedConsumer(this.topic, "cons1");
        boolean exceptionHappened = false;
        try {
            MessageConsumer messageConsumer = session.createSharedConsumer(this.topic2, "cons1");
        }
        catch (JMSException e) {
            exceptionHappened = true;
        }
        Assertions.assertTrue((boolean)exceptionHappened);
        MessageProducer producer = session.createProducer((Destination)this.topic2);
        MessageConsumer cons2 = session.createSharedDurableConsumer(this.topic2, "cons1");
        this.conn.start();
        producer.send((Message)session.createTextMessage("hello!"));
        TextMessage msg = (TextMessage)cons2.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        exceptionHappened = false;
        try {
            session.unsubscribe("cons1");
        }
        catch (JMSException e) {
            exceptionHappened = true;
        }
        Assertions.assertTrue((boolean)exceptionHappened);
        cons2.close();
        this.conn.close();
        conn2.close();
    }

    @Test
    public void testUnsubscribeDurable() throws Exception {
        this.conn = this.cf.createConnection();
        this.conn.setClientID("C1");
        this.conn.start();
        Session session = this.conn.createSession(false, 1);
        MessageConsumer cons = session.createSharedDurableConsumer(this.topic, "c1");
        MessageProducer prod = session.createProducer((Destination)this.topic);
        for (int i = 0; i < 100; ++i) {
            prod.send((Message)session.createTextMessage("msg" + i));
        }
        Assertions.assertNotNull((Object)cons.receive(5000L));
        cons.close();
        session.unsubscribe("c1");
        cons = session.createSharedDurableConsumer(this.topic, "c1");
        Assertions.assertNull((Object)cons.receiveNoWait());
    }

    @Test
    public void testShareDurable() throws Exception {
        int i;
        ((ActiveMQConnectionFactory)this.cf).setConsumerWindowSize(0);
        this.conn = this.cf.createConnection();
        this.conn.start();
        Session session = this.conn.createSession(false, 1);
        Session session2 = this.conn.createSession(false, 1);
        MessageConsumer cons = session.createSharedDurableConsumer(this.topic, "c1");
        MessageConsumer cons2 = session2.createSharedDurableConsumer(this.topic, "c1");
        MessageProducer prod = session.createProducer((Destination)this.topic);
        for (i = 0; i < 100; ++i) {
            prod.send((Message)session.createTextMessage("msg" + i));
        }
        for (i = 0; i < 50; ++i) {
            Message msg = cons.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg = cons2.receive(5000L);
            Assertions.assertNotNull((Object)msg);
        }
        Assertions.assertNull((Object)cons.receiveNoWait());
        Assertions.assertNull((Object)cons2.receiveNoWait());
        cons.close();
        boolean exceptionHappened = false;
        try {
            session.unsubscribe("c1");
        }
        catch (JMSException e) {
            exceptionHappened = true;
        }
        Assertions.assertTrue((boolean)exceptionHappened);
        cons2.close();
        for (int i2 = 0; i2 < 100; ++i2) {
            prod.send((Message)session.createTextMessage("msg" + i2));
        }
        session.unsubscribe("c1");
        cons = session.createSharedDurableConsumer(this.topic, "c1");
        Assertions.assertNull((Object)cons.receiveNoWait());
    }

    @Test
    public void testShareDuraleWithJMSContext() throws Exception {
        ((ActiveMQConnectionFactory)this.cf).setConsumerWindowSize(0);
        JMSContext conn = this.cf.createContext(1);
        JMSConsumer consumer = conn.createSharedDurableConsumer(this.topic, "c1");
        JMSProducer producer = conn.createProducer();
        for (int i = 0; i < 100; ++i) {
            producer.setProperty("count", i).send((Destination)this.topic, "test" + i);
        }
        JMSContext conn2 = conn.createContext(1);
        JMSConsumer consumer2 = conn2.createSharedDurableConsumer(this.topic, "c1");
        for (int i = 0; i < 50; ++i) {
            String txt = (String)consumer.receiveBody(String.class, 5000L);
            Assertions.assertNotNull((Object)txt);
            txt = (String)consumer.receiveBody(String.class, 5000L);
            Assertions.assertNotNull((Object)txt);
        }
        Assertions.assertNull((Object)consumer.receiveNoWait());
        Assertions.assertNull((Object)consumer2.receiveNoWait());
        boolean exceptionHappened = false;
        try {
            conn.unsubscribe("c1");
        }
        catch (Exception e) {
            e.printStackTrace();
            exceptionHappened = true;
        }
        Assertions.assertTrue((boolean)exceptionHappened);
        consumer.close();
        consumer2.close();
        conn2.close();
        conn.unsubscribe("c1");
    }

    @Test
    public void defaultAutoCreatedQueueConfigTest() throws Exception {
        String queueName = "q1";
        this.server.getAddressSettingsRepository().addMatch("q1", (Object)new AddressSettings().setDefaultMaxConsumers(Integer.valueOf(5)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)));
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession();
        session.createConsumer((Destination)session.createQueue("q1"));
        Queue queue = this.server.locateQueue(SimpleString.of((String)"q1"));
        Assertions.assertEquals((int)5, (int)queue.getMaxConsumers());
        Assertions.assertTrue((boolean)queue.isPurgeOnNoConsumers());
        connection.close();
    }

    @Test
    public void testConsumerAfterWildcardAddressRemoval() throws Exception {
        String queue1 = "queue.#";
        String topic1 = "durable.#";
        String topic2 = "durable.test";
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)queue1), RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queue1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)topic1), RoutingType.MULTICAST));
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)topic2), RoutingType.MULTICAST));
        this.server.removeAddressInfo(SimpleString.of((String)topic1), null);
        this.conn = this.cf.createConnection();
        this.conn.setClientID("clientId");
        this.conn.start();
        Session sess = this.conn.createSession(false, 1);
        sess.createConsumer((Destination)sess.createTopic(topic2));
        sess.close();
    }

    @Test
    public void testConsumerAfterWildcardConsumer() throws Exception {
        String queue1 = "queue.#";
        String topic1 = "durable.#";
        String topic2 = "durable.test";
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)queue1), RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queue1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)topic1), RoutingType.MULTICAST));
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)topic2), RoutingType.MULTICAST));
        this.conn = this.cf.createConnection();
        this.conn.setClientID("clientId");
        this.conn.start();
        Session sess = this.conn.createSession(false, 1);
        MessageConsumer c = sess.createConsumer((Destination)sess.createTopic(topic1));
        c.close();
        sess.createConsumer((Destination)sess.createTopic(topic2));
        sess.close();
    }

    @Test
    public void testAddressRemovalWithWildcardConsumer() throws Exception {
        this.testAddressRemovalWithWithConsumers("durable.test", "durable.#");
    }

    @Test
    public void testAddressRemovalWithNonWildcardConsumer() throws Exception {
        this.testAddressRemovalWithWithConsumers("durable.#", "durable.test");
    }

    private void testAddressRemovalWithWithConsumers(String topic1, String topic2) throws Exception {
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)topic1), RoutingType.MULTICAST));
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)topic2), RoutingType.MULTICAST));
        this.conn = this.cf.createConnection();
        this.conn.setClientID("clientId");
        this.conn.start();
        Session sess = this.conn.createSession(false, 1);
        MessageConsumer c1 = sess.createDurableConsumer(sess.createTopic(topic1), "sub1");
        c1.close();
        this.server.removeAddressInfo(SimpleString.of((String)topic2), null);
        Assertions.assertEquals((int)1, (int)this.server.getPostOffice().getBindingsForAddress(SimpleString.of((String)topic1)).getBindings().size());
        c1 = sess.createDurableConsumer(sess.createTopic(topic1), "sub1");
        MessageConsumer c2 = sess.createDurableConsumer(sess.createTopic(topic2), "sub2");
        MessageProducer p1 = sess.createProducer((Destination)sess.createTopic("durable.test"));
        p1.send((Message)sess.createTextMessage("test"));
        Assertions.assertNotNull((Object)c1.receive(1000L));
        Assertions.assertNotNull((Object)c2.receive(1000L));
        sess.close();
    }
}

