/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.jms2client;

import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Topic;
import java.util.Random;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.tests.integration.jms.jms2client.JmsContextTest;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SharedConsumerTest
extends JMSTestBase {
    private JMSContext context;
    private final Random random = new Random();
    private Topic topic1;
    private Topic topic2;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context = this.createContext();
        this.topic1 = this.createTopic(JmsContextTest.class.getSimpleName() + "Topic1");
        this.topic2 = this.createTopic(JmsContextTest.class.getSimpleName() + "Topic2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sharedDurableSubSimpleRoundRobin() throws Exception {
        this.context = this.cf.createContext();
        try {
            int i;
            JMSConsumer con1 = this.context.createSharedDurableConsumer(this.topic1, "mySharedCon");
            JMSConsumer con2 = this.context.createSharedDurableConsumer(this.topic1, "mySharedCon");
            this.context.start();
            JMSProducer producer = this.context.createProducer();
            int numMessages = 10;
            for (i = 0; i < numMessages; ++i) {
                producer.send((Destination)this.topic1, "msg:" + i);
            }
            for (i = 0; i < numMessages; i += 2) {
                String msg = (String)con1.receiveBody(String.class, 5000L);
                msg = (String)con2.receiveBody(String.class, 5000L);
            }
        }
        finally {
            this.context.close();
        }
    }

    @Test
    public void sharedDurableSubUser() throws Exception {
        try (JMSContext context = this.cf.createContext("foo", "bar");){
            context.createSharedDurableConsumer(this.topic1, "mySharedCon");
            boolean found = false;
            for (Binding binding : this.server.getPostOffice().getBindingsForAddress(SimpleString.of((String)this.topic1.getTopicName())).getBindings()) {
                found = true;
                Assertions.assertTrue((boolean)(binding instanceof LocalQueueBinding));
                Assertions.assertEquals((Object)"mySharedCon", (Object)((LocalQueueBinding)binding).getQueue().getName().toString());
                Assertions.assertNotNull((Object)((LocalQueueBinding)binding).getQueue().getUser());
                Assertions.assertEquals((Object)"foo", (Object)((LocalQueueBinding)binding).getQueue().getUser().toString());
            }
            Assertions.assertTrue((boolean)found);
        }
    }

    @Test
    public void sharedDurableUnsubscribeNewTopic() throws Exception {
        this.context = this.cf.createContext();
        try {
            JMSConsumer con1 = this.context.createSharedDurableConsumer(this.topic1, "mySharedCon");
            JMSConsumer con2 = this.context.createSharedDurableConsumer(this.topic1, "mySharedCon");
            con1.close();
            con2.close();
            this.context.unsubscribe("mySharedCon");
            JMSConsumer jMSConsumer = this.context.createSharedDurableConsumer(this.topic2, "mySharedCon");
        }
        finally {
            this.context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sharedNonDurableUnsubscribeDifferentTopic() throws Exception {
        this.context = this.cf.createContext();
        try {
            JMSConsumer con1 = this.context.createSharedConsumer(this.topic1, "mySharedCon");
            JMSConsumer con2 = this.context.createSharedConsumer(this.topic1, "mySharedCon");
            con1.close();
            Binding binding = this.server.getPostOffice().getBinding(SimpleString.of((String)"nonDurable.mySharedCon"));
            Assertions.assertNotNull((Object)binding);
            con2.close();
            Wait.assertTrue(() -> this.server.getPostOffice().getBinding(SimpleString.of((String)"nonDurable.mySharedCon")) == null, (long)2000L, (long)100L);
            JMSConsumer jMSConsumer = this.context.createSharedConsumer(this.topic2, "mySharedCon");
        }
        finally {
            this.context.close();
        }
    }

    @Test
    public void sharedNonDurableSubOnDifferentSelector() throws Exception {
        this.context = this.cf.createContext();
        try {
            this.context.createSharedConsumer(this.topic1, "mySharedCon", "sel = 'sel1'");
            try {
                this.context.createSharedConsumer(this.topic1, "mySharedCon", "sel = 'sel2'");
                Assertions.fail((String)"expected JMSRuntimeException");
            }
            catch (JMSRuntimeException jMSRuntimeException) {
            }
            catch (Exception e) {
                Assertions.fail((String)("threw wrong exception expected JMSRuntimeException got " + e));
            }
        }
        finally {
            this.context.close();
        }
    }

    @Test
    public void sharedNonDurableSubOnDifferentSelectorSrcFilterNull() throws Exception {
        this.context = this.cf.createContext();
        try {
            this.context.createSharedConsumer(this.topic1, "mySharedCon");
            try {
                this.context.createSharedConsumer(this.topic1, "mySharedCon", "sel = 'sel2'");
                Assertions.fail((String)"expected JMSRuntimeException");
            }
            catch (JMSRuntimeException jMSRuntimeException) {
            }
            catch (Exception e) {
                Assertions.fail((String)("threw wrong exception expected JMSRuntimeException got " + e));
            }
        }
        finally {
            this.context.close();
        }
    }

    @Test
    public void sharedNonDurableSubOnDifferentSelectorTargetFilterNull() throws Exception {
        this.context = this.cf.createContext();
        try {
            this.context.createSharedConsumer(this.topic1, "mySharedCon", "sel = 'sel1'");
            try {
                this.context.createSharedConsumer(this.topic1, "mySharedCon");
                Assertions.fail((String)"expected JMSRuntimeException");
            }
            catch (JMSRuntimeException jMSRuntimeException) {
            }
            catch (Exception e) {
                Assertions.fail((String)("threw wrong exception expected JMSRuntimeException got " + e));
            }
        }
        finally {
            this.context.close();
        }
    }

    @Test
    public void sharedDurableSubOnDifferentTopic() throws Exception {
        this.context = this.cf.createContext();
        try {
            this.context.createSharedDurableConsumer(this.topic1, "mySharedCon");
            try {
                this.context.createSharedDurableConsumer(this.topic2, "mySharedCon");
                Assertions.fail((String)"expected JMSRuntimeException");
            }
            catch (JMSRuntimeException jMSRuntimeException) {
            }
            catch (Exception e) {
                Assertions.fail((String)("threw wrong exception expected JMSRuntimeException got " + e));
            }
        }
        finally {
            this.context.close();
        }
    }

    @Test
    public void sharedDurableSubOnDifferentSelector() throws Exception {
        this.context = this.cf.createContext();
        try {
            this.context.createSharedDurableConsumer(this.topic1, "mySharedCon", "sel = 'sel1'");
            try {
                this.context.createSharedDurableConsumer(this.topic1, "mySharedCon", "sel = 'sel2'");
                Assertions.fail((String)"expected JMSRuntimeException");
            }
            catch (JMSRuntimeException jMSRuntimeException) {
            }
            catch (Exception e) {
                Assertions.fail((String)("threw wrong exception expected JMSRuntimeException got " + e));
            }
        }
        finally {
            this.context.close();
        }
    }

    @Test
    public void sharedDurableSubOnDifferentSelectorSrcFilterNull() throws Exception {
        this.context = this.cf.createContext();
        try {
            this.context.createSharedDurableConsumer(this.topic1, "mySharedCon");
            try {
                this.context.createSharedDurableConsumer(this.topic1, "mySharedCon", "sel = 'sel2'");
                Assertions.fail((String)"expected JMSRuntimeException");
            }
            catch (JMSRuntimeException jMSRuntimeException) {
            }
            catch (Exception e) {
                Assertions.fail((String)("threw wrong exception expected JMSRuntimeException got " + e));
            }
        }
        finally {
            this.context.close();
        }
    }

    @Test
    public void sharedDurableSubOnDifferentSelectorTargetFilterNull() throws Exception {
        this.context = this.cf.createContext();
        try {
            this.context.createSharedDurableConsumer(this.topic1, "mySharedCon", "sel = 'sel1'");
            try {
                this.context.createSharedDurableConsumer(this.topic1, "mySharedCon");
                Assertions.fail((String)"expected JMSRuntimeException");
            }
            catch (JMSRuntimeException jMSRuntimeException) {
            }
            catch (Exception e) {
                Assertions.fail((String)("threw wrong exception expected JMSRuntimeException got " + e));
            }
        }
        finally {
            this.context.close();
        }
    }
}

