/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSXPathSelectorTest
extends MultiprotocolJMSClientTestSupport {
    private static final String NORMAL_QUEUE_NAME = "NORMAL";

    @Override
    protected URI getBrokerQpidJMSConnectionURI() {
        try {
            return new URI(this.getBrokerQpidJMSConnectionString() + "?jms.validateSelector=false");
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setPersistenceEnabled(false);
        server.getAddressSettingsRepository().addMatch(NORMAL_QUEUE_NAME, (Object)new AddressSettings());
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        super.createAddressAndQueues(server);
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)NORMAL_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)NORMAL_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testJMSSelectorsAMQPProducerAMQPConsumer() throws Exception {
        this.testJMSSelectors(this.AMQPConnection, this.AMQPConnection);
    }

    @Test
    public void testJMSSelectorsCoreProducerCoreConsumer() throws Exception {
        this.testJMSSelectors(this.CoreConnection, this.CoreConnection);
    }

    @Test
    public void testJMSSelectorsCoreProducerAMQPConsumer() throws Exception {
        this.testJMSSelectors(this.CoreConnection, this.AMQPConnection);
    }

    @Test
    public void testJMSSelectorsAMQPProducerCoreConsumer() throws Exception {
        this.testJMSSelectors(this.AMQPConnection, this.CoreConnection);
    }

    @Test
    public void testJMSSelectorsOpenWireProducerOpenWireConsumer() throws Exception {
        this.testJMSSelectors(this.OpenWireConnection, this.OpenWireConnection);
    }

    @Test
    public void testJMSSelectorsCoreProducerOpenWireConsumer() throws Exception {
        this.testJMSSelectors(this.CoreConnection, this.OpenWireConnection);
    }

    @Test
    public void testJMSSelectorsOpenWireProducerCoreConsumer() throws Exception {
        this.testJMSSelectors(this.OpenWireConnection, this.CoreConnection);
    }

    @Test
    public void testJMSSelectorsAMQPProducerOpenWireConsumer() throws Exception {
        this.testJMSSelectors(this.AMQPConnection, this.OpenWireConnection);
    }

    @Test
    public void testJMSSelectorsOpenWireProducerAMQPConsumer() throws Exception {
        this.testJMSSelectors(this.OpenWireConnection, this.AMQPConnection);
    }

    public void testJMSSelectors(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testJMSSelector(producerConnectionSupplier, consumerConnectionSupplier, NORMAL_QUEUE_NAME, "<root><a key='first' num='1'/><b key='second' num='2'>b</b></root>", "<root><b key='first' num='1'/><c key='second' num='2'>c</c></root>", "XPATH 'root/a'");
        this.testJMSSelector(producerConnectionSupplier, consumerConnectionSupplier, NORMAL_QUEUE_NAME, "<root><a key='first' num='1'/><b key='second' num='2'>b</b></root>", "<root><z key='first' num='1'/></root>", "XPATH 'root/a'");
        this.testJMSSelector(producerConnectionSupplier, consumerConnectionSupplier, NORMAL_QUEUE_NAME, "<root><a key='first' num='1'/><b key='second' num='2'>b</b></root>", "foo", "XPATH 'root/a'");
    }

    public void testJMSSelector(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String goodBody, String badBody, String selector) throws Exception {
        this.testJMSSelector(producerConnectionSupplier, consumerConnectionSupplier, queueName, goodBody, badBody, selector, 2, 4, 0L);
    }

    public void testJMSSelector(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String goodBody, String badBody, String selector, int deliveryMode, int priority, long timeToLive) throws Exception {
        this.sendMessage(producerConnectionSupplier, queueName, goodBody, badBody, deliveryMode, priority, timeToLive);
        this.receive(consumerConnectionSupplier, queueName, goodBody, selector);
    }

    private void receive(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String body, String selector) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue, selector);
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)body, (Object)msg.getText());
            Assertions.assertNull((Object)consumer.receiveNoWait());
            consumer.close();
        }
    }

    private void sendMessage(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, String goodBody, String badBody, int deliveryMode, int priority, long timeToLive) throws JMSException {
        try (Connection producerConnection = producerConnectionSupplier.createConnection();){
            Session producerSession = producerConnection.createSession(false, 1);
            Queue queue1 = producerSession.createQueue(queueName);
            MessageProducer p = producerSession.createProducer(null);
            TextMessage message1 = producerSession.createTextMessage();
            message1.setText(badBody);
            p.send((Destination)queue1, (Message)message1);
            TextMessage message2 = producerSession.createTextMessage();
            message2.setText(goodBody);
            p.send((Destination)queue1, (Message)message2, deliveryMode, priority, timeToLive);
        }
    }
}

