/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.DivertControl;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.transformer.AddHeadersTransformer;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DivertControlTest
extends ManagementTestBase {
    private ActiveMQServer server;
    private DivertConfiguration divertConfig;

    @Test
    public void testAttributes() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(this.divertConfig.getName(), this.divertConfig.getAddress()));
        DivertControl divertControl = this.createDivertManagementControl(this.divertConfig.getName(), this.divertConfig.getAddress());
        Assertions.assertEquals((Object)this.divertConfig.getFilterString(), (Object)divertControl.getFilter());
        Assertions.assertEquals((Object)this.divertConfig.isExclusive(), (Object)divertControl.isExclusive());
        Assertions.assertEquals((Object)this.divertConfig.getName(), (Object)divertControl.getUniqueName());
        Assertions.assertEquals((Object)this.divertConfig.getRoutingName(), (Object)divertControl.getRoutingName());
        Assertions.assertEquals((Object)this.divertConfig.getAddress(), (Object)divertControl.getAddress());
        Assertions.assertEquals((Object)this.divertConfig.getForwardingAddress(), (Object)divertControl.getForwardingAddress());
        Assertions.assertEquals((Object)this.divertConfig.getTransformerConfiguration().getClassName(), (Object)divertControl.getTransformerClassName());
        Assertions.assertEquals((Object)this.divertConfig.getTransformerConfiguration().getProperties(), (Object)divertControl.getTransformerProperties());
    }

    @Test
    public void testRetroactiveResourceAttribute() throws Exception {
        String address = RandomUtil.randomString();
        QueueConfiguration queueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        QueueConfiguration forwardQueueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setAddress(address).setDurable(Boolean.valueOf(false));
        this.divertConfig = new DivertConfiguration().setName(ResourceNames.getRetroactiveResourceDivertName((String)this.server.getInternalNamingPrefix(), (String)this.server.getConfiguration().getWildcardConfiguration().getDelimiterString(), (SimpleString)SimpleString.of((String)address)).toString()).setRoutingName(RandomUtil.randomString()).setAddress(queueConfig.getAddress().toString()).setForwardingAddress(forwardQueueConfig.getAddress().toString()).setExclusive(RandomUtil.randomBoolean()).setTransformerConfiguration(new TransformerConfiguration(AddHeadersTransformer.class.getName()));
        this.server.deployDivert(this.divertConfig);
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(this.divertConfig.getName(), this.divertConfig.getAddress()));
        DivertControl divertControl = this.createDivertManagementControl(this.divertConfig.getName(), this.divertConfig.getAddress());
        Assertions.assertTrue((boolean)divertControl.isRetroactiveResource());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        QueueConfiguration queueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        QueueConfiguration forwardQueueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        this.divertConfig = new DivertConfiguration().setName(RandomUtil.randomString()).setRoutingName(RandomUtil.randomString()).setAddress(queueConfig.getAddress().toString()).setForwardingAddress(forwardQueueConfig.getAddress().toString()).setExclusive(RandomUtil.randomBoolean()).setTransformerConfiguration(new TransformerConfiguration(AddHeadersTransformer.class.getName()));
        TransportConfiguration connectorConfig = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        Configuration config = this.createDefaultInVMConfig().setJMXManagementEnabled(true).addQueueConfiguration(queueConfig).addQueueConfiguration(forwardQueueConfig).addDivertConfiguration(this.divertConfig).addConnectorConfiguration(connectorConfig.getName(), connectorConfig);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)this.mbeanServer, (boolean)false));
        this.server.start();
    }

    protected DivertControl createDivertManagementControl(String name, String address) throws Exception {
        return ManagementControlHelper.createDivertControl(name, address, this.mbeanServer);
    }
}

