/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.management.SecurityManagementTestBase;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SecurityManagementWithModifiedConfigurationTest
extends SecurityManagementTestBase {
    private final String configuredClusterPassword = "this is not the default password";

    @TestTemplate
    public void testSendManagementMessageWithModifiedClusterAdminUser() throws Exception {
        this.doSendBrokerManagementMessage(ActiveMQDefaultConfiguration.getDefaultClusterUser(), "this is not the default password", true);
    }

    @TestTemplate
    public void testSendManagementMessageWithDefaultClusterAdminUser() throws Exception {
        this.doSendBrokerManagementMessage(ActiveMQDefaultConfiguration.getDefaultClusterUser(), ActiveMQDefaultConfiguration.getDefaultClusterPassword(), false);
    }

    @TestTemplate
    public void testSendManagementMessageWithGuest() throws Exception {
        this.doSendBrokerManagementMessage("guest", "guest", false);
    }

    @TestTemplate
    public void testSendManagementMessageWithoutUserCredentials() throws Exception {
        this.doSendBrokerManagementMessage(null, null, false);
    }

    @Override
    protected ActiveMQServer setupAndStartActiveMQServer() throws Exception {
        Configuration conf = this.createDefaultInVMConfig().setSecurityEnabled(true).setClusterPassword("this is not the default password");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf, (boolean)false));
        server.start();
        return server;
    }
}

