/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MQTTRejectingInterceptorTest
extends MQTTTestSupport {
    @Test
    @Timeout(value=60L)
    public void testRejectedMQTTMessage() throws Exception {
        String addressQueue = this.name;
        String msgText = "Test rejected message";
        MQTTClientProvider subscribeProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscribeProvider);
        subscribeProvider.subscribe(addressQueue, 0);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> packet.getClass() != MqttPublishMessage.class;
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        publishProvider.publish(addressQueue, "Test rejected message".getBytes(), 0, false);
        Assertions.assertNull((Object)subscribeProvider.receive(3000));
        subscribeProvider.disconnect();
        publishProvider.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testRejectedMqttConnectMessage() throws Exception {
        CountDownLatch publishThreadReady = new CountDownLatch(1);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)((MQTTInterceptor)(packet, connection) -> packet.getClass() != MqttConnectMessage.class));
        Thread publishThread = new Thread(() -> {
            MQTTClientProvider publishProvider = this.getMQTTClientProvider();
            publishThreadReady.countDown();
            try {
                this.initializeConnection(publishProvider);
                publishProvider.disconnect();
                Assertions.fail((String)"The connection should be rejected!");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        publishThread.start();
        publishThreadReady.await();
        publishThread.join(3000L);
        if (publishThread.isAlive()) {
            Assertions.fail((String)"The connection is stuck!");
        }
    }
}

