/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.util.LinkedList;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.jgroups.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MqttAcknowledgementTest
extends MQTTTestSupport {
    private volatile LinkedList<Integer> messageIds = new LinkedList();
    private volatile boolean messageArrived = false;
    private MqttClient subscriber;
    private MqttClient sender;

    @AfterEach
    public void clean() throws MqttException {
        this.messageArrived = false;
        this.messageIds.clear();
        if (this.subscriber.isConnected()) {
            this.subscriber.disconnect();
        }
        if (this.sender.isConnected()) {
            this.sender.disconnect();
        }
        this.subscriber.close();
        this.sender.close();
    }

    @Test
    @Timeout(value=60L)
    public void testAcknowledgementQOS1() throws Exception {
        this.test(1);
    }

    @Test
    @Timeout(value=60L)
    public void testAcknowledgementQOS0() throws Exception {
        Assertions.assertThrows(AssertionError.class, () -> this.test(0));
    }

    private void test(int qos) throws Exception {
        String subscriberId = UUID.randomUUID().toString();
        String senderId = UUID.randomUUID().toString();
        String topic = UUID.randomUUID().toString();
        this.subscriber = this.createMqttClient(subscriberId);
        this.subscriber.subscribe(topic, qos);
        this.sender = this.createMqttClient(senderId);
        this.sender.publish(topic, UUID.randomUUID().toString().getBytes(), qos, false);
        this.sender.publish(topic, UUID.randomUUID().toString().getBytes(), qos, false);
        boolean satisfied = Wait.waitFor(() -> this.messageIds.size() == 2, (long)5000L);
        if (!satisfied) {
            Assertions.fail();
        }
        this.subscriber.messageArrivedComplete(this.messageIds.getLast().intValue(), qos);
        this.subscriber.disconnect();
        this.subscriber.close();
        this.messageArrived = false;
        satisfied = Wait.waitFor(() -> {
            try {
                this.subscriber = this.createMqttClient(subscriberId);
                return true;
            }
            catch (MqttException e) {
                return false;
            }
        }, (long)60000L);
        if (!satisfied) {
            Assertions.fail();
        }
        if (!(satisfied = Wait.waitFor(() -> this.messageArrived, (long)5000L))) {
            Assertions.fail();
        }
    }

    private MqttClient createMqttClient(String clientId) throws MqttException {
        MqttClient client = new MqttClient("tcp://localhost:" + this.getPort(), clientId, (MqttClientPersistence)new MemoryPersistence());
        client.setCallback(this.createCallback());
        client.setManualAcks(true);
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(false);
        client.connect(options);
        return client;
    }

    private MqttCallback createCallback() {
        return new MqttCallback(){

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                MqttAcknowledgementTest.this.messageIds.add(message.getId());
                MqttAcknowledgementTest.this.messageArrived = true;
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }

            public void connectionLost(Throwable cause) {
            }
        };
    }
}

