/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class PahoMQTTTest
extends MQTTTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public String protocol;

    @Parameters(name="protocol={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({"tcp"}, {"ws"});
    }

    public PahoMQTTTest(String protocol) {
        this.protocol = protocol;
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testLotsOfClients() throws Exception {
        int CLIENTS = Integer.getInteger("PahoMQTTTest.CLIENTS", 100);
        logger.debug("Using: {} clients: ", (Object)CLIENTS);
        final AtomicInteger receiveCounter = new AtomicInteger();
        MqttClient client = this.createPahoClient("consumer");
        client.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                receiveCounter.incrementAndGet();
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        client.connect();
        client.subscribe("test");
        final AtomicReference asyncError = new AtomicReference();
        final CountDownLatch connectedDoneLatch = new CountDownLatch(CLIENTS);
        final CountDownLatch disconnectDoneLatch = new CountDownLatch(CLIENTS);
        final CountDownLatch sendBarrier = new CountDownLatch(1);
        for (int i = 0; i < CLIENTS; ++i) {
            Thread.sleep(10L);
            new Thread(null, null, "client:" + i){

                @Override
                public void run() {
                    try {
                        MqttClient client = PahoMQTTTest.this.createPahoClient(Thread.currentThread().getName());
                        client.connect();
                        connectedDoneLatch.countDown();
                        sendBarrier.await();
                        for (int i = 0; i < 10; ++i) {
                            Thread.sleep(1000L);
                            client.publish("test", "hello".getBytes(), 1, false);
                        }
                        client.disconnect();
                        client.close();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        asyncError.set(e);
                    }
                    finally {
                        disconnectDoneLatch.countDown();
                    }
                }
            }.start();
        }
        connectedDoneLatch.await();
        Assertions.assertNull(asyncError.get(), (String)("Async error: " + asyncError.get()));
        sendBarrier.countDown();
        logger.debug("All clients connected... waiting to receive sent messages...");
        this.within(30, TimeUnit.SECONDS, () -> Assertions.assertTrue((receiveCounter.get() == CLIENTS * 10 ? (byte)1 : (byte)0) != 0));
        logger.debug("All messages received.");
        disconnectDoneLatch.await();
        Assertions.assertNull(asyncError.get(), (String)("Async error: " + asyncError.get()));
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendAndReceiveMQTT() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumerId");
        MqttClient producer = this.createPahoClient("producerId");
        consumer.connect();
        consumer.subscribe("test");
        consumer.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch.countDown();
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        producer.connect();
        producer.publish("test", "hello".getBytes(), 1, false);
        PahoMQTTTest.waitForLatch(latch);
        producer.disconnect();
        producer.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSessionPresentWithCleanSession() throws Exception {
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        IMqttToken result = client.connectWithResult(options);
        Assertions.assertFalse((boolean)result.getSessionPresent());
        client.disconnect();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSessionPresent() throws Exception {
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(false);
        IMqttToken result = client.connectWithResult(options);
        Assertions.assertFalse((boolean)result.getSessionPresent());
        client.disconnect();
        result = client.connectWithResult(options);
        Assertions.assertTrue((boolean)result.getSessionPresent());
    }

    private MqttClient createPahoClient(String clientId) throws MqttException {
        return new MqttClient(this.protocol + "://localhost:" + this.getPort(), clientId, (MqttClientPersistence)new MemoryPersistence());
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testDollarAndHashSubscriptions() throws Exception {
        String CLIENT_ID_ADMIN = "test-client-admin";
        String CLIENT_ID_1 = "test-client-1";
        String CLIENT_ID_2 = "test-client-2";
        CountDownLatch clientAdminLatch = new CountDownLatch(3);
        CountDownLatch client1Latch = new CountDownLatch(2);
        CountDownLatch client2Latch = new CountDownLatch(1);
        MqttClient clientAdmin = this.createPahoClient("test-client-admin");
        MqttClient client1 = this.createPahoClient("test-client-1");
        MqttClient client2 = this.createPahoClient("test-client-2");
        clientAdmin.setCallback((MqttCallback)new TestMqttClientCallback(clientAdminLatch));
        client1.setCallback((MqttCallback)new TestMqttClientCallback(client1Latch));
        client2.setCallback((MqttCallback)new TestMqttClientCallback(client2Latch));
        clientAdmin.connect();
        client1.connect();
        client2.connect();
        client1.subscribe("$dollar/test-client-1/#");
        client2.subscribe("$dollar/test-client-2/#");
        clientAdmin.subscribe("#");
        MqttMessage m = new MqttMessage("test".getBytes());
        client1.publish("$dollar/test-client-1/foo", m);
        client2.publish("$dollar/test-client-2/foo", m);
        clientAdmin.publish("$dollar/test-client-1/bar", m);
        clientAdmin.publish("$dollar/test-client-1/bar", m);
        client1.publish("$dollar/test-client-1/baz", m);
        client2.publish("$dollar/test-client-2/baz", m);
        clientAdmin.publish("$dollar/test-client-1/baz", m);
        clientAdmin.publish("$dollar/test-client-2/baz", m);
        Assertions.assertTrue((boolean)client1Latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)client2Latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)clientAdminLatch.await(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((long)3L, (long)clientAdminLatch.getCount());
        clientAdmin.disconnect();
        clientAdmin.close();
        client1.disconnect();
        client1.close();
        client2.disconnect();
        client2.close();
    }

    private class TestMqttClientCallback
    implements MqttCallback {
        private CountDownLatch latch;

        TestMqttClientCallback(CountDownLatch latch) {
            this.latch = latch;
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            this.latch.countDown();
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }

        public void connectionLost(Throwable cause) {
        }
    }
}

