/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.eclipse.paho.mqttv5.common.packet.MqttUnsubAck;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class UnsubAckTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testUnsubscribeAck() throws Exception {
        int i;
        int SUBSCRIPTION_COUNT = 10;
        String TOPIC = RandomUtil.randomString();
        SimpleString[] topicNames = new SimpleString[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            topicNames[i2] = SimpleString.of((String)(i2 + "-" + TOPIC));
        }
        MqttAsyncClient consumer = this.createAsyncPahoClient("consumer");
        consumer.connect().waitForCompletion();
        MqttSubscription[] subscriptions = new MqttSubscription[10];
        for (i = 0; i < 10; ++i) {
            subscriptions[i] = new MqttSubscription(topicNames[i].toString(), 0);
        }
        consumer.subscribe(subscriptions).waitForCompletion();
        for (i = 0; i < 10; ++i) {
            Assertions.assertTrue((boolean)this.server.getPostOffice().isAddressBound(topicNames[i]));
        }
        String[] unsubTopicNames = new String[20];
        for (int i3 = 0; i3 <= 10; ++i3) {
            if (i3 != 10) {
                unsubTopicNames[i3 * 2] = topicNames[i3].toString();
            }
            if (i3 == 0) continue;
            unsubTopicNames[i3 * 2 - 1] = RandomUtil.randomString();
        }
        IMqttToken token = consumer.unsubscribe(unsubTopicNames);
        token.waitForCompletion();
        for (int i4 = 0; i4 < 10; ++i4) {
            Assertions.assertFalse((boolean)this.server.getPostOffice().isAddressBound(topicNames[i4]));
        }
        MqttUnsubAck response = (MqttUnsubAck)token.getResponse();
        Assertions.assertEquals((int)unsubTopicNames.length, (int)response.getReturnCodes().length);
        for (int i5 = 0; i5 < response.getReturnCodes().length; ++i5) {
            if (i5 % 2 == 0) {
                Assertions.assertEquals((int)0, (int)response.getReturnCodes()[i5]);
                continue;
            }
            Assertions.assertEquals((int)17, (int)response.getReturnCodes()[i5]);
        }
        System.out.println(response);
        consumer.disconnect();
        consumer.close();
    }
}

