/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FailoverDuplicateIDUsageTest
extends ActiveMQTestBase {
    ActiveMQServer server;

    @BeforeEach
    public void setupServer() throws Exception {
        this.server = this.createServer(true, true);
    }

    @Test
    public void testTempQueue() throws Exception {
        this.server.getConfiguration().getAcceptorConfigurations().clear();
        this.server.getConfiguration().clearAcceptorConfigurations().addAcceptorConfiguration("openwire", "tcp://localhost:61616?openwireUseDuplicateDetectionOnFailover=true");
        this.server.start();
        this.server.waitForActivation(10L, TimeUnit.SECONDS);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("failover:tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryQueue queue = session.createTemporaryQueue();
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 100; ++i) {
                producer.send((Message)session.createTextMessage("hello"));
            }
            Assertions.assertEquals((int)0, (int)this.countDuplicateDetection(this.server.getConfiguration()));
        }
    }

    @Test
    public void testNoDuplicate() throws Exception {
        this.testDuplicate(false);
    }

    @Test
    public void testDuplicate() throws Exception {
        this.testDuplicate(true);
    }

    private void testDuplicate(boolean useDuplicate) throws Exception {
        String queueName = this.getName();
        this.server.getConfiguration().getAcceptorConfigurations().clear();
        this.server.getConfiguration().clearAcceptorConfigurations().addAcceptorConfiguration("openwire", "tcp://localhost:61616?openwireUseDuplicateDetectionOnFailover=" + useDuplicate);
        this.server.start();
        this.server.waitForActivation(10L, TimeUnit.SECONDS);
        this.server.createQueue(QueueConfiguration.of((String)queueName).setRoutingType(RoutingType.ANYCAST));
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("failover:tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 100; ++i) {
                producer.send((Message)session.createTextMessage("hello"));
            }
        }
        this.server.stop();
        Assertions.assertEquals((int)(useDuplicate ? 100 : 0), (int)this.countDuplicateDetection(this.server.getConfiguration()));
    }

    private int countDuplicateDetection(Configuration configuration) throws Exception {
        HashMap<Integer, AtomicInteger> maps = this.countJournal(configuration);
        AtomicInteger value = maps.get(37);
        return value == null ? 0 : value.get();
    }
}

