/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Map;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class OpenWireFlowControlFailTest
extends OpenWireTestBase {
    public static final String OWHOST = "localhost";
    public static final int OWPORT = 61616;
    protected static final String urlString = "tcp://localhost:61616?wireFormat.cacheEnabled=true";

    @Override
    protected void configureAddressSettings(Map<String, AddressSettings> addressSettingsMap) {
        addressSettingsMap.put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")).setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL).setMaxSizeBytes(10000L));
    }

    @Test
    @Timeout(value=60L)
    public void testMessagesNotSent() throws Exception {
        Queue queue;
        AddressInfo addressInfo = new AddressInfo(SimpleString.of((String)"Test"), RoutingType.ANYCAST);
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(QueueConfiguration.of((SimpleString)addressInfo.getName()).setRoutingType(RoutingType.ANYCAST));
        StringBuffer textBody = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            textBody.append(" ");
        }
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(urlString);
        int numberOfMessage = 0;
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            queue = session.createQueue(addressInfo.getName().toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            boolean failed = false;
            try {
                for (int i = 0; i < 1000; ++i) {
                    TextMessage message = session.createTextMessage(textBody.toString());
                    message.setIntProperty("i", i);
                    producer.send((Message)message);
                    ++numberOfMessage;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                failed = true;
                try {
                    producer.send((Message)session.createTextMessage(textBody.toString()));
                    Assertions.fail((String)"Exception expected");
                }
                catch (JMSException expected) {
                    expected.printStackTrace();
                }
            }
            Assertions.assertTrue((boolean)failed);
        }
        factory = new ActiveMQConnectionFactory(urlString);
        try (Connection connection2 = factory.createConnection();){
            Session session2 = connection2.createSession(false, 1);
            queue = session2.createQueue(addressInfo.getName().toString());
            MessageConsumer consumer = session2.createConsumer((Destination)queue);
            connection2.start();
            for (int i = 0; i < numberOfMessage; ++i) {
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)textBody.toString(), (Object)message.getText());
            }
            TextMessage msg = (TextMessage)consumer.receive(500L);
            Assertions.assertNull((Object)msg);
        }
    }
}

