/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Map;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenWireScheduledDelayTest
extends OpenWireTestBase {
    @Override
    protected void configureAddressSettings(Map<String, AddressSettings> addressSettingsMap) {
        addressSettingsMap.put("#", new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")));
    }

    @Test
    public void testScheduledDelay() throws Exception {
        String QUEUE_NAME = RandomUtil.randomString();
        long DELAY = 2000L;
        String PROP_NAME = RandomUtil.randomString();
        String FIRST = RandomUtil.randomString();
        String SECOND = RandomUtil.randomString();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://127.0.0.1:61616");
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)destination);
        Message firstMessage = session.createMessage();
        firstMessage.setLongProperty("AMQ_SCHEDULED_DELAY", 2000L);
        firstMessage.setStringProperty(PROP_NAME, FIRST);
        long ETA = System.currentTimeMillis() + 2000L;
        producer.send(firstMessage);
        Message secondMessage = session.createMessage();
        secondMessage.setStringProperty(PROP_NAME, SECOND);
        producer.send(secondMessage);
        producer.close();
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Message received = consumer.receive(250L);
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)SECOND, (Object)received.getStringProperty(PROP_NAME));
        received = consumer.receive(2250L);
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)FIRST, (Object)received.getStringProperty(PROP_NAME));
        Assertions.assertTrue((System.currentTimeMillis() >= ETA ? (byte)1 : 0) != 0);
        connection.close();
    }
}

