/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSConsumer6Test
extends BasicOpenWireTest {
    public byte destinationType;

    @Parameters(name="destinationType={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({(byte)1}, {(byte)2});
    }

    public JMSConsumer6Test(byte destinationType) {
        this.destinationType = destinationType;
    }

    @TestTemplate
    public void testPassMessageListenerIntoCreateConsumer() throws Exception {
        AtomicInteger counter = new AtomicInteger(0);
        CountDownLatch done = new CountDownLatch(1);
        this.connection.start();
        ActiveMQSession session = (ActiveMQSession)this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination((Session)session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination, m -> {
            counter.incrementAndGet();
            if (counter.get() == 4) {
                done.countDown();
            }
        });
        Assertions.assertNotNull((Object)consumer);
        this.sendMessages((Session)session, (Destination)destination, 4);
        Assertions.assertTrue((boolean)done.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        Assertions.assertEquals((int)4, (int)counter.get());
    }

    @TestTemplate
    public void testAckOfExpired() throws Exception {
        TextMessage message;
        int i;
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.connection.setStatsEnabled(true);
        Session sendSession = this.connection.createSession(false, 1);
        MessageProducer producer = sendSession.createProducer((Destination)destination);
        producer.setTimeToLive(1000L);
        int count = 4;
        for (i = 0; i < 4; ++i) {
            message = sendSession.createTextMessage("" + i);
            producer.send((Message)message);
        }
        Thread.sleep(2000L);
        producer.setTimeToLive(0L);
        for (i = 0; i < 4; ++i) {
            message = sendSession.createTextMessage("no expiry" + i);
            producer.send((Message)message);
        }
        ActiveMQMessageConsumer amqConsumer = (ActiveMQMessageConsumer)consumer;
        for (int i2 = 0; i2 < 4; ++i2) {
            TextMessage msg = (TextMessage)amqConsumer.receive();
            Assertions.assertNotNull((Object)msg);
            Assertions.assertTrue((boolean)msg.getText().contains("no expiry"), (String)("message has \"no expiry\" text: " + msg.getText()));
            amqConsumer.acknowledge();
        }
        Assertions.assertEquals((long)4L, (long)amqConsumer.getConsumerStats().getExpiredMessageCount().getCount(), (String)"consumer has expiredMessages");
    }
}

