/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.tests.integration.openwire.amq.JmsTransactionTestSupport;

public class JmsResourceProvider {
    private boolean transacted;
    private int ackMode = 1;
    private boolean isTopic;
    private int deliveryMode = 2;
    private String durableName = "DummyName";
    private String clientID = this.getClass().getName();

    public Connection createConnection(ConnectionFactory cf) throws JMSException {
        Connection connection = cf.createConnection();
        if (this.getClientID() != null) {
            connection.setClientID(this.getClientID());
        }
        return connection;
    }

    public Session createSession(Connection conn) throws JMSException {
        return conn.createSession(this.transacted, this.ackMode);
    }

    public MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.isDurableSubscriber()) {
            return session.createDurableSubscriber((Topic)destination, this.durableName);
        }
        return session.createConsumer(destination);
    }

    public ConnectionConsumer createConnectionConsumer(Connection connection, Destination destination, ServerSessionPool ssp) throws JMSException {
        return connection.createConnectionConsumer(destination, null, ssp, 1);
    }

    public MessageProducer createProducer(Session session, Destination destination) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        return producer;
    }

    public Destination createDestination(Session session, JmsTransactionTestSupport support) throws JMSException {
        if (this.isTopic) {
            return support.createDestination(session, (byte)2);
        }
        return support.createDestination(session, (byte)1);
    }

    public boolean isDurableSubscriber() {
        return this.isTopic && this.durableName != null;
    }

    public int getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(int ackMode) {
        this.ackMode = ackMode;
    }

    public boolean isTopic() {
        return this.isTopic;
    }

    public void setTopic(boolean isTopic) {
        this.isTopic = isTopic;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
        if (transacted) {
            this.setAckMode(0);
        }
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void setDurableName(String durableName) {
        this.durableName = durableName;
    }
}

