/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedDivertConfiguration;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class DivertConfigurationStorageTest
extends StorageManagerTestBase {
    public DivertConfigurationStorageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @TestTemplate
    public void testStoreDivertConfiguration() throws Exception {
        TransformerConfiguration mytransformer = new TransformerConfiguration("mytransformer");
        mytransformer.getProperties().put("key1", "prop1");
        mytransformer.getProperties().put("key2", "prop2");
        mytransformer.getProperties().put("key3", "prop3");
        DivertConfiguration configuration = new DivertConfiguration().setName("name").setAddress("address").setExclusive(true).setForwardingAddress("forward").setRoutingName("routiingName").setTransformerConfiguration(mytransformer);
        this.journal.storeDivertConfiguration(new PersistedDivertConfiguration(configuration));
        this.rebootStorage();
        List divertConfigurations = this.journal.recoverDivertConfigurations();
        Assertions.assertEquals((int)1, (int)divertConfigurations.size());
        PersistedDivertConfiguration persistedDivertConfiguration = (PersistedDivertConfiguration)divertConfigurations.get(0);
        Assertions.assertEquals((Object)configuration.getName(), (Object)persistedDivertConfiguration.getDivertConfiguration().getName());
        Assertions.assertEquals((Object)configuration.getAddress(), (Object)persistedDivertConfiguration.getDivertConfiguration().getAddress());
        Assertions.assertEquals((Object)configuration.isExclusive(), (Object)persistedDivertConfiguration.getDivertConfiguration().isExclusive());
        Assertions.assertEquals((Object)configuration.getForwardingAddress(), (Object)persistedDivertConfiguration.getDivertConfiguration().getForwardingAddress());
        Assertions.assertEquals((Object)configuration.getRoutingName(), (Object)persistedDivertConfiguration.getDivertConfiguration().getRoutingName());
        Assertions.assertNotNull((Object)persistedDivertConfiguration.getDivertConfiguration().getTransformerConfiguration());
        Assertions.assertEquals((Object)"mytransformer", (Object)persistedDivertConfiguration.getDivertConfiguration().getTransformerConfiguration().getClassName());
        Map properties = persistedDivertConfiguration.getDivertConfiguration().getTransformerConfiguration().getProperties();
        Assertions.assertEquals((int)3, (int)properties.size());
        Assertions.assertEquals((Object)"prop1", properties.get("key1"));
        Assertions.assertEquals((Object)"prop2", properties.get("key2"));
        Assertions.assertEquals((Object)"prop3", properties.get("key3"));
    }

    @TestTemplate
    public void testStoreDivertConfigurationNoTransformer() throws Exception {
        DivertConfiguration configuration = new DivertConfiguration().setName("name").setAddress("address").setExclusive(true).setForwardingAddress("forward").setRoutingName("routiingName");
        this.journal.storeDivertConfiguration(new PersistedDivertConfiguration(configuration));
        this.rebootStorage();
        List divertConfigurations = this.journal.recoverDivertConfigurations();
        Assertions.assertEquals((int)1, (int)divertConfigurations.size());
        PersistedDivertConfiguration persistedDivertConfiguration = (PersistedDivertConfiguration)divertConfigurations.get(0);
        Assertions.assertEquals((Object)configuration.getName(), (Object)persistedDivertConfiguration.getDivertConfiguration().getName());
        Assertions.assertEquals((Object)configuration.getAddress(), (Object)persistedDivertConfiguration.getDivertConfiguration().getAddress());
        Assertions.assertEquals((Object)configuration.isExclusive(), (Object)persistedDivertConfiguration.getDivertConfiguration().isExclusive());
        Assertions.assertEquals((Object)configuration.getForwardingAddress(), (Object)persistedDivertConfiguration.getDivertConfiguration().getForwardingAddress());
        Assertions.assertEquals((Object)configuration.getRoutingName(), (Object)persistedDivertConfiguration.getDivertConfiguration().getRoutingName());
        Assertions.assertNull((Object)persistedDivertConfiguration.getDivertConfiguration().getTransformerConfiguration());
    }
}

