/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence.metrics;

import java.util.LinkedList;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountRecord;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountRecordInc;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JournalPageCountSizeTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private TransactionFailureCallback transactionFailure = (transactionID, records, recordsToDelete) -> {};

    @BeforeEach
    public void init() throws Exception {
        this.server = this.createServer(true);
        this.server.start();
    }

    @Override
    protected ConfigurationImpl createBasicConfig(int serverID) {
        return super.createBasicConfig(serverID);
    }

    @AfterEach
    public void destroy() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageCountRecordSize() throws Exception {
        long tx = this.server.getStorageManager().generateID();
        this.server.getStorageManager().storePageCounter(tx, 1L, 1L, 100L);
        this.server.getStorageManager().commit(tx);
        this.server.getStorageManager().stop();
        JournalStorageManager journalStorageManager = (JournalStorageManager)this.server.getStorageManager();
        LinkedList committedRecords = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        try {
            journalStorageManager.getMessageJournal().start();
            journalStorageManager.getMessageJournal().load(committedRecords, preparedTransactions, this.transactionFailure);
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])((RecordInfo)committedRecords.get((int)0)).data);
            PageCountRecord encoding = new PageCountRecord();
            encoding.decode(buff);
            Assertions.assertEquals((long)100L, (long)encoding.getPersistentSize());
        }
        finally {
            journalStorageManager.getMessageJournal().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageCursorCounterRecordSize() throws Exception {
        this.server.getStorageManager().storePageCounterInc(1L, 1, 1000L);
        this.server.getStorageManager().stop();
        JournalStorageManager journalStorageManager = (JournalStorageManager)this.server.getStorageManager();
        LinkedList committedRecords = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        try {
            journalStorageManager.getMessageJournal().start();
            journalStorageManager.getMessageJournal().load(committedRecords, preparedTransactions, this.transactionFailure);
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])((RecordInfo)committedRecords.get((int)0)).data);
            PageCountRecordInc encoding = new PageCountRecordInc();
            encoding.decode(buff);
            Assertions.assertEquals((long)1000L, (long)encoding.getPersistentSize());
        }
        finally {
            journalStorageManager.getMessageJournal().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageCursorCounterRecordSizeTX() throws Exception {
        long tx = this.server.getStorageManager().generateID();
        this.server.getStorageManager().storePageCounterInc(tx, 1L, 1, 1000L);
        this.server.getStorageManager().commit(tx);
        this.server.getStorageManager().stop();
        JournalStorageManager journalStorageManager = (JournalStorageManager)this.server.getStorageManager();
        LinkedList committedRecords = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        try {
            journalStorageManager.getMessageJournal().start();
            journalStorageManager.getMessageJournal().load(committedRecords, preparedTransactions, this.transactionFailure);
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])((RecordInfo)committedRecords.get((int)0)).data);
            PageCountRecordInc encoding = new PageCountRecordInc();
            encoding.decode(buff);
            Assertions.assertEquals((long)1000L, (long)encoding.getPersistentSize());
        }
        finally {
            journalStorageManager.getMessageJournal().stop();
        }
    }
}

