/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence.metrics;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToLongFunction;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.tests.integration.persistence.metrics.AbstractPersistentStatTestSupport;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalPendingMessageTest
extends AbstractPersistentStatTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String defaultQueueName = "test.queue";
    protected String defaultTopicName = "test.topic";
    protected static int maxMessageSize = 1000;

    @BeforeEach
    public void setupAddresses() throws Exception {
        this.server.getPostOffice().addAddressInfo(new AddressInfo(SimpleString.of((String)this.defaultQueueName), RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)this.defaultQueueName).setRoutingType(RoutingType.ANYCAST));
    }

    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        Configuration config = super.createDefaultConfig(netty);
        config.setGlobalMaxSize(100000L);
        return config;
    }

    @Test
    public void testQueueMessageSize() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        this.publishTestQueueMessages(200, publishedMessageSize);
        this.verifyPendingStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.killServer();
        this.restartServer();
        this.verifyPendingStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 200, publishedMessageSize.get());
    }

    @Test
    public void testQueueMessageSizeTx() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        this.publishTestQueueMessagesTx(200, publishedMessageSize);
        this.verifyPendingStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.killServer();
        this.restartServer();
        this.verifyPendingStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 200, publishedMessageSize.get());
    }

    @Test
    public void testQueueLargeMessageSize() throws Exception {
        ActiveMQConnectionFactory acf = (ActiveMQConnectionFactory)this.cf;
        acf.setMinLargeMessageSize(1000);
        Connection connection = this.cf.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        String testText = StringUtils.repeat((String)"t", (int)5000);
        ActiveMQTextMessage message = (ActiveMQTextMessage)session.createTextMessage(testText);
        session.createProducer((Destination)session.createQueue(this.defaultQueueName)).send((Message)message);
        this.verifyPendingStats(this.defaultQueueName, 1, message.getCoreMessage().getPersistentSize());
        this.verifyPendingDurableStats(this.defaultQueueName, 1, message.getCoreMessage().getPersistentSize());
        connection.close();
        this.killServer();
        this.restartServer();
        this.verifyPendingStats(this.defaultQueueName, 1, message.getCoreMessage().getPersistentSize());
        this.verifyPendingDurableStats(this.defaultQueueName, 1, message.getCoreMessage().getPersistentSize());
    }

    @Test
    public void testQueueLargeMessageSizeTX() throws Exception {
        ActiveMQConnectionFactory acf = (ActiveMQConnectionFactory)this.cf;
        acf.setMinLargeMessageSize(1000);
        Connection connection = this.cf.createConnection();
        connection.start();
        Session session = connection.createSession(true, 0);
        String testText = StringUtils.repeat((String)"t", (int)2000);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.defaultQueueName));
        ActiveMQTextMessage message = (ActiveMQTextMessage)session.createTextMessage(testText);
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)message);
        }
        this.verifyPendingStats(this.defaultQueueName, 0, message.getCoreMessage().getPersistentSize() * 10L);
        this.verifyPendingDurableStats(this.defaultQueueName, 0, message.getCoreMessage().getPersistentSize() * 10L);
        session.commit();
        this.verifyPendingStats(this.defaultQueueName, 10, message.getCoreMessage().getPersistentSize() * 10L);
        this.verifyPendingDurableStats(this.defaultQueueName, 10, message.getCoreMessage().getPersistentSize() * 10L);
        connection.close();
        this.killServer();
        this.restartServer();
        this.verifyPendingStats(this.defaultQueueName, 10, message.getCoreMessage().getPersistentSize());
        this.verifyPendingDurableStats(this.defaultQueueName, 10, message.getCoreMessage().getPersistentSize());
    }

    @Test
    public void testQueueBrowserMessageSize() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        this.publishTestQueueMessages(200, publishedMessageSize);
        this.browseTestQueueMessages(this.defaultQueueName);
        this.verifyPendingStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 200, publishedMessageSize.get());
    }

    @Test
    public void testQueueMessageSizeNonPersistent() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        this.publishTestQueueMessages(10, 1, publishedMessageSize);
        this.verifyPendingStats(this.defaultQueueName, 10, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 0, 0L);
    }

    @Test
    public void testQueueMessageSizePersistentAndNonPersistent() throws Exception {
        AtomicLong publishedNonPersistentMessageSize = new AtomicLong();
        AtomicLong publishedMessageSize = new AtomicLong();
        this.publishTestQueueMessages(5, 2, publishedMessageSize);
        this.publishTestQueueMessages(10, 1, publishedNonPersistentMessageSize);
        this.verifyPendingStats(this.defaultQueueName, 15, publishedMessageSize.get() + publishedNonPersistentMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 5, publishedMessageSize.get());
    }

    @Test
    public void testQueueMessageSizeAfterConsumption() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        this.publishTestQueueMessages(200, publishedMessageSize);
        this.verifyPendingStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.consumeTestQueueMessages(200);
        this.verifyPendingStats(this.defaultQueueName, 0, 0L);
        this.verifyPendingDurableStats(this.defaultQueueName, 0, 0L);
    }

    @Test
    public void testScheduledStats() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.defaultQueueName));
        producer.setDeliveryDelay(2000L);
        producer.send((Message)session.createTextMessage("test"));
        this.verifyPendingStats(this.defaultQueueName, 1, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 1, publishedMessageSize.get());
        this.verifyScheduledStats(this.defaultQueueName, 1, publishedMessageSize.get());
        this.consumeTestQueueMessages(1);
        this.verifyPendingStats(this.defaultQueueName, 0, 0L);
        this.verifyPendingDurableStats(this.defaultQueueName, 0, 0L);
        this.verifyScheduledStats(this.defaultQueueName, 0, 0L);
        connection.close();
    }

    @Test
    public void testDeliveringStats() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.start();
        Session session = connection.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.defaultQueueName));
        producer.send((Message)session.createTextMessage("test"));
        this.verifyPendingStats(this.defaultQueueName, 1, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 1, publishedMessageSize.get());
        this.verifyDeliveringStats(this.defaultQueueName, 0, 0L);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.defaultQueueName));
        Message msg = consumer.receive();
        this.verifyDeliveringStats(this.defaultQueueName, 1, publishedMessageSize.get());
        msg.acknowledge();
        this.verifyPendingStats(this.defaultQueueName, 0, 0L);
        this.verifyPendingDurableStats(this.defaultQueueName, 0, 0L);
        this.verifyDeliveringStats(this.defaultQueueName, 0, 0L);
        connection.close();
    }

    @Test
    public void testQueueMessageSizeAfterConsumptionNonPersistent() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        this.publishTestQueueMessages(200, 1, publishedMessageSize);
        this.verifyPendingStats(this.defaultQueueName, 200, publishedMessageSize.get());
        this.consumeTestQueueMessages(200);
        this.verifyPendingStats(this.defaultQueueName, 0, 0L);
        this.verifyPendingDurableStats(this.defaultQueueName, 0, 0L);
    }

    @Test
    public void testTopicMessageSize() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId");
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createTopic(this.defaultTopicName));
        this.publishTestTopicMessages(200, publishedMessageSize);
        this.verifyPendingStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultQueueName, 0, 0L);
        this.consumeTestMessages(consumer, 200);
        this.verifyPendingStats(this.defaultTopicName, 0, 0L);
        this.verifyPendingDurableStats(this.defaultQueueName, 0, 0L);
        connection.close();
    }

    @Test
    public void testTopicMessageSizeShared() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId");
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createSharedConsumer(session.createTopic(this.defaultTopicName), "sub1");
        MessageConsumer consumer2 = session.createSharedConsumer(session.createTopic(this.defaultTopicName), "sub1");
        this.publishTestTopicMessages(200, publishedMessageSize);
        this.verifyPendingStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultTopicName, 0, 0L);
        consumer2.close();
        this.consumeTestMessages(consumer, 200);
        this.verifyPendingStats(this.defaultTopicName, 0, 0L);
        this.verifyPendingDurableStats(this.defaultTopicName, 0, 0L);
        connection.close();
    }

    @Test
    public void testTopicNonPersistentMessageSize() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId");
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createTopic(this.defaultTopicName));
        this.publishTestTopicMessages(200, 1, publishedMessageSize);
        this.verifyPendingStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.consumeTestMessages(consumer, 200);
        this.verifyPendingStats(this.defaultTopicName, 0, 0L);
        connection.close();
    }

    @Test
    public void testTopicPersistentAndNonPersistentMessageSize() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        AtomicLong publishedNonPersistentMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId");
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createTopic(this.defaultTopicName));
        this.publishTestTopicMessages(100, 1, publishedNonPersistentMessageSize);
        this.publishTestTopicMessages(100, 2, publishedMessageSize);
        this.verifyPendingStats(this.defaultTopicName, 200, publishedMessageSize.get() + publishedNonPersistentMessageSize.get());
        this.consumeTestMessages(consumer, 200);
        this.verifyPendingStats(this.defaultTopicName, 0, 0L);
        connection.close();
    }

    @Test
    public void testMessageSizeOneDurable() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId");
        connection.start();
        this.publishTestMessagesDurable(connection, new String[]{"sub1"}, 200, publishedMessageSize, 2, false);
        this.verifyPendingStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.consumeDurableTestMessages(connection, "sub1", 200, publishedMessageSize);
        this.verifyPendingStats(this.defaultTopicName, 0, 0L);
        this.verifyPendingDurableStats(this.defaultTopicName, 0, 0L);
        connection.close();
    }

    @Test
    public void testMessageSizeOneDurablePartialConsumption() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId");
        connection.start();
        this.publishTestMessagesDurable(connection, new String[]{"sub1"}, 200, publishedMessageSize, 2, false);
        this.verifyPendingStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.consumeDurableTestMessages(connection, "sub1", 50, publishedMessageSize);
        this.verifyPendingStats(this.defaultTopicName, 150, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultTopicName, 150, (long)(0.75 * (double)publishedMessageSize.get()));
        connection.close();
    }

    @Test
    public void testMessageSizeTwoDurables() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId");
        connection.start();
        this.publishTestMessagesDurable(connection, new String[]{"sub1", "sub2"}, 200, publishedMessageSize, 2, false);
        this.verifyPendingStats(this.defaultTopicName, 400, 2L * publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultTopicName, 400, 2L * publishedMessageSize.get());
        this.consumeDurableTestMessages(connection, "sub1", 200, publishedMessageSize);
        this.verifyPendingStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultTopicName, 200, publishedMessageSize.get());
        connection.close();
        this.killServer();
        this.restartServer();
        this.verifyPendingStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultTopicName, 200, publishedMessageSize.get());
    }

    @Test
    public void testMessageSizeSharedDurable() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId");
        connection.start();
        Session s = connection.createSession();
        MessageConsumer c = s.createSharedDurableConsumer(s.createTopic(this.defaultTopicName), "sub1");
        this.publishTestMessagesDurable(connection, new String[]{"sub1"}, 200, publishedMessageSize, 2, true);
        this.verifyPendingStats(this.defaultTopicName, 200, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultTopicName, 200, publishedMessageSize.get());
        c.close();
        this.consumeDurableTestMessages(connection, "sub1", 200, publishedMessageSize);
        this.verifyPendingStats(this.defaultTopicName, 0, publishedMessageSize.get());
        this.verifyPendingDurableStats(this.defaultTopicName, 0, publishedMessageSize.get());
        connection.close();
    }

    protected List<Queue> getQueues(String address) throws Exception {
        ArrayList<Queue> queues = new ArrayList<Queue>();
        for (Binding binding : this.server.getPostOffice().getDirectBindings(SimpleString.of((String)address))) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            LocalQueueBinding queueBinding = (LocalQueueBinding)binding;
            queues.add(queueBinding.getQueue());
        }
        return queues;
    }

    protected void verifyDeliveringStats(String address, int count, long minimumSize) throws Exception {
        this.verifyStats(address, count, minimumSize, Queue::getDeliveringCount, Queue::getDeliveringSize);
        this.verifyStats(address, count, minimumSize, Queue::getDurableDeliveringCount, Queue::getDurableDeliveringSize);
    }

    protected void verifyScheduledStats(String address, int count, long minimumSize) throws Exception {
        this.verifyStats(address, count, minimumSize, Queue::getScheduledCount, Queue::getScheduledSize);
        this.verifyStats(address, count, minimumSize, Queue::getDurableScheduledCount, Queue::getDurableScheduledSize);
    }

    protected void verifyPendingStats(String address, int count, long minimumSize) throws Exception {
        this.verifyStats(address, count, minimumSize, Queue::getMessageCount, Queue::getPersistentSize);
    }

    protected void verifyPendingDurableStats(String address, int count, long minimumSize) throws Exception {
        this.verifyStats(address, count, minimumSize, Queue::getDurableMessageCount, Queue::getDurablePersistentSize);
    }

    protected void verifyStats(String address, int count, long minimumSize, ToLongFunction<Queue> countFunc, ToLongFunction<Queue> sizeFunc) throws Exception {
        List<Queue> queues = this.getQueues(address);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> queues.stream().mapToLong(countFunc).sum() == (long)count));
        this.verifySize(count, () -> queues.stream().mapToLong(sizeFunc).sum(), minimumSize);
    }

    protected void verifySize(int count, MessageSizeCalculator messageSizeCalculator, long minimumSize) throws Exception {
        if (count > 0) {
            Assertions.assertTrue((boolean)Wait.waitFor(() -> messageSizeCalculator.getMessageSize() > minimumSize));
        } else {
            Assertions.assertTrue((boolean)Wait.waitFor(() -> messageSizeCalculator.getMessageSize() == 0L));
        }
    }

    protected void consumeTestMessages(MessageConsumer consumer, int size) throws Exception {
        this.consumeTestMessages(consumer, size, this.defaultTopicName);
    }

    protected void consumeTestMessages(MessageConsumer consumer, int size, String topicName) throws Exception {
        for (int i = 0; i < size; ++i) {
            consumer.receive();
        }
    }

    protected void consumeDurableTestMessages(Connection connection, String sub, int size, AtomicLong publishedMessageSize) throws Exception {
        this.consumeDurableTestMessages(connection, sub, size, this.defaultTopicName, publishedMessageSize);
    }

    protected void publishTestMessagesDurable(Connection connection, String[] subNames, int publishSize, AtomicLong publishedMessageSize, int deliveryMode, boolean shared) throws Exception {
        this.publishTestMessagesDurable(connection, subNames, this.defaultTopicName, publishSize, 0, AbstractPersistentStatTestSupport.defaultMessageSize, publishedMessageSize, false, deliveryMode, shared);
    }

    protected void publishTestTopicMessages(int publishSize, AtomicLong publishedMessageSize) throws Exception {
        this.publishTestTopicMessages(publishSize, 2, publishedMessageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishTestTopicMessages(int publishSize, int deliveryMode, AtomicLong publishedMessageSize) throws Exception {
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId2");
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(this.defaultTopicName);
        try {
            MessageProducer prod = session.createProducer((Destination)topic);
            prod.setDeliveryMode(deliveryMode);
            for (int i = 0; i < publishSize; ++i) {
                prod.send((Message)this.createMessage(i, session, maxMessageSize, publishedMessageSize));
            }
        }
        finally {
            connection.close();
        }
    }

    protected void publishTestQueueMessagesTx(int count, AtomicLong publishedMessageSize) throws Exception {
        this.publishTestQueueMessages(count, this.defaultQueueName, 2, maxMessageSize, publishedMessageSize, true);
    }

    protected void publishTestQueueMessages(int count, AtomicLong publishedMessageSize) throws Exception {
        this.publishTestQueueMessages(count, this.defaultQueueName, 2, maxMessageSize, publishedMessageSize, false);
    }

    protected void publishTestQueueMessages(int count, int deliveryMode, AtomicLong publishedMessageSize) throws Exception {
        this.publishTestQueueMessages(count, this.defaultQueueName, deliveryMode, maxMessageSize, publishedMessageSize, false);
    }

    protected void consumeTestQueueMessages(int num) throws Exception {
        this.consumeTestQueueMessages(this.defaultQueueName, num);
    }

    protected static interface MessageSizeCalculator {
        public long getMessageSize() throws Exception;
    }
}

