/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.remoting;

import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SynchronousCloseTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultConfig(this.isNetty()).setSecurityEnabled(false);
        this.server = this.createServer(false, config);
        this.server.start();
    }

    protected boolean isNetty() {
        return false;
    }

    protected ClientSessionFactory createSessionFactory() throws Exception {
        ServerLocator locator = this.isNetty() ? this.createNettyNonHALocator() : this.createInVMNonHALocator();
        return this.createSessionFactory(locator);
    }

    @Test
    public void testSynchronousClose() throws Exception {
        Assertions.assertEquals((int)0, (int)this.server.getActiveMQServerControl().listRemoteAddresses().length);
        ClientSessionFactory sf = this.createSessionFactory();
        for (int i = 0; i < 2000; ++i) {
            ClientSession session = sf.createSession(false, true, true);
            session.close();
        }
        sf.close();
        sf.getServerLocator().close();
    }
}

