/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatStartBackupTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DistributedLockManagerConfiguration managerConfiguration;
    ActiveMQServer backupServer;
    ActiveMQServer server;

    File newTemporaryFolder(String name) {
        File newFolder = new File(this.temporaryFolder, name);
        newFolder.mkdirs();
        return newFolder;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.managerConfiguration = new DistributedLockManagerConfiguration(FileBasedLockManager.class.getName(), Collections.singletonMap("locks-folder", this.newTemporaryFolder("manager").toString()));
        int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
        Configuration liveConfiguration = this.createLiveConfiguration();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        this.server.setIdentity("PRIMARY");
        this.server.getConfiguration().setJournalFileSize(102400);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo("t1").addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)"t1").setAddress("t1").setRoutingType(RoutingType.ANYCAST));
        Configuration backupConfiguration = this.createBackupConfiguration();
        ((ReplicationBackupPolicyConfiguration)backupConfiguration.getHAPolicyConfiguration()).setAllowFailBack(true);
        this.backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        this.backupServer.setIdentity("BACKUP");
        this.backupServer.start();
        Wait.waitFor(() -> ((ActiveMQServer)this.backupServer).isStarted());
        Wait.assertTrue(() -> this.backupServer.isReplicaSync(), (long)timeout);
    }

    @Test
    public void testLoopStart() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            this.runAfter(executorService::shutdownNow);
            AtomicInteger errors = new AtomicInteger(0);
            AtomicBoolean running = new AtomicBoolean(true);
            this.runAfter(() -> running.set(false));
            CountDownLatch latch = new CountDownLatch(1);
            executorService.execute(() -> {
                try {
                    ConnectionFactory factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
                    try (Connection connection = factory.createConnection();){
                        Session session = connection.createSession(false, 1);
                        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("t1"));
                        MessageProducer producer = session.createProducer((Destination)session.createQueue("t1"));
                        connection.start();
                        while (running.get()) {
                            producer.send((Message)session.createTextMessage("hello"));
                            Assertions.assertNotNull((Object)consumer.receive(1000L));
                        }
                    }
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                    errors.incrementAndGet();
                }
                finally {
                    latch.countDown();
                }
            });
            for (int i = 0; i < 5; ++i) {
                logger.info("\n*******************************************************************************************************************************\ntest {}\n*******************************************************************************************************************************", (Object)i);
                this.backupServer.stop();
                Wait.assertFalse(() -> ((ActiveMQServer)this.backupServer).isStarted());
                this.backupServer.start();
                Wait.assertTrue(() -> ((ActiveMQServer)this.backupServer).isStarted());
                if (i % 2 == 1) {
                    Wait.assertTrue(() -> ((ActiveMQServer)this.backupServer).isReplicaSync());
                }
                Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ229254"}));
                Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ229006"}));
                loggerHandler.clear();
            }
            running.set(false);
            Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)0, (int)errors.get());
        }
    }

    protected HAPolicyConfiguration createReplicationLiveConfiguration() {
        ReplicationPrimaryPolicyConfiguration haPolicy = ReplicationPrimaryPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        return haPolicy;
    }

    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        ReplicationBackupPolicyConfiguration haPolicy = ReplicationBackupPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        haPolicy.setClusterName("cluster");
        return haPolicy;
    }

    protected Configuration createLiveConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setJournalType(JournalType.NIO);
        conf.setName("localhost::live");
        File liveDir = this.newTemporaryFolder("live");
        conf.setBrokerInstance(liveDir);
        conf.addAcceptorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        conf.setHAPolicyConfiguration(this.createReplicationLiveConfiguration());
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("backup");
        ccconf.setName("cluster");
        ccconf.setConnectorName("live");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.NIO).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    protected Configuration createBackupConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::backup");
        File backupDir = this.newTemporaryFolder("backup");
        conf.setBrokerInstance(backupDir);
        conf.setHAPolicyConfiguration(this.createReplicationBackupConfiguration());
        conf.addAcceptorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("live");
        ccconf.setName("cluster");
        ccconf.setConnectorName("backup");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.NIO).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }
}

