/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.routing;

import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.tests.integration.routing.RoutingTestBase;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AmqpRedirectTest
extends RoutingTestBase {
    @Test
    public void testRouterRejectionDueToOfflineTargetPool() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupPrimaryServerWithDiscovery(1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupRouterServerWithStaticConnectors(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, null, 0, 1);
        this.startServers(0);
        URI uri = new URI("tcp://localhost:61616");
        AmqpClient client = new AmqpClient(uri, "admin", "admin");
        AmqpConnection connection = client.createConnection();
        connection.setContainerId(this.getName());
        connection.setStateInspector(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                if (!connection.getRemoteProperties().containsKey(AmqpSupport.CONNECTION_OPEN_FAILED)) {
                    this.markAsInvalid("Broker did not set connection establishment failed hint");
                }
            }

            @Override
            public void inspectClosedResource(Connection connection) {
                ErrorCondition remoteError = connection.getRemoteCondition();
                if (remoteError == null || remoteError.getCondition() == null) {
                    this.markAsInvalid("Broker did not add error condition for connection");
                    return;
                }
                if (!remoteError.getCondition().equals(ConnectionError.CONNECTION_FORCED)) {
                    this.markAsInvalid("Broker did not set condition to " + ConnectionError.CONNECTION_FORCED);
                    return;
                }
                String expectedDescription = "Connection router bb1 is not ready";
                String actualDescription = remoteError.getDescription();
                if (!expectedDescription.equals(actualDescription)) {
                    this.markAsInvalid("Broker did not set description as expected, was: " + actualDescription);
                    return;
                }
            }
        });
        try {
            connection.connect();
            Assertions.fail((String)"Expected connection to fail, without redirect");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.getStateInspector().assertValid();
        connection.close();
        this.stopServers(0);
    }

    @Test
    public void testRouterRedirectDetails() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupPrimaryServerWithDiscovery(1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupRouterServerWithStaticConnectors(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, null, 1, 1);
        this.startServers(0, 1);
        URI uri = new URI("tcp://localhost:61616");
        AmqpClient client = new AmqpClient(uri, "admin", "admin");
        AmqpConnection connection = client.createConnection();
        connection.setContainerId(this.getName());
        connection.setStateInspector(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                if (!connection.getRemoteProperties().containsKey(AmqpSupport.CONNECTION_OPEN_FAILED)) {
                    this.markAsInvalid("Broker did not set connection establishment failed hint");
                }
            }

            @Override
            public void inspectClosedResource(Connection connection) {
                String actualDescription;
                ErrorCondition remoteError = connection.getRemoteCondition();
                if (remoteError == null || remoteError.getCondition() == null) {
                    this.markAsInvalid("Broker did not add error condition for connection");
                    return;
                }
                if (!remoteError.getCondition().equals(ConnectionError.REDIRECT)) {
                    this.markAsInvalid("Broker did not set condition to " + ConnectionError.REDIRECT);
                    return;
                }
                Integer redirectPort = 61617;
                String expectedDescription = "Connection router bb1 redirected this connection to localhost:" + redirectPort;
                if (!expectedDescription.equals(actualDescription = remoteError.getDescription())) {
                    this.markAsInvalid("Broker did not set description as expected, was: " + actualDescription);
                    return;
                }
                Map infoMap = remoteError.getInfo();
                if (infoMap == null) {
                    this.markAsInvalid("Broker did not set an info map on condition with redirect details");
                    return;
                }
                if (!infoMap.containsKey(AmqpSupport.NETWORK_HOST)) {
                    this.markAsInvalid("Info map does not contain key " + AmqpSupport.NETWORK_HOST);
                    return;
                }
                Object value = infoMap.get(AmqpSupport.NETWORK_HOST);
                if (!"localhost".equals(value)) {
                    this.markAsInvalid("Info map does not contain expected network-host value, was: " + value);
                    return;
                }
                if (!infoMap.containsKey(AmqpSupport.PORT)) {
                    this.markAsInvalid("Info map does not contain key " + AmqpSupport.PORT);
                    return;
                }
                value = infoMap.get(AmqpSupport.PORT);
                if (value == null || !redirectPort.equals(value)) {
                    this.markAsInvalid("Info map does not contain expected port value, was: " + value);
                    return;
                }
            }
        });
        try {
            connection.connect();
            Assertions.fail((String)"Expected connection to fail, with redirect");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.getStateInspector().assertValid();
        connection.close();
        this.stopServers(0, 1);
    }

    @Test
    public void testRouterRejectionUseAnother() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupRouterServerWithLocalTarget(0, KeyType.ROLE_NAME, "B", null);
        this.startServers(0);
        URI uri = new URI("tcp://localhost:61616");
        AmqpClient client = new AmqpClient(uri, "admin", "admin");
        AmqpConnection connection = client.createConnection();
        connection.setContainerId(this.getName());
        connection.setStateInspector(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                if (!connection.getRemoteProperties().containsKey(AmqpSupport.CONNECTION_OPEN_FAILED)) {
                    this.markAsInvalid("Broker did not set connection establishment failed hint");
                }
            }

            @Override
            public void inspectClosedResource(Connection connection) {
                ErrorCondition remoteError = connection.getRemoteCondition();
                if (remoteError == null || remoteError.getCondition() == null) {
                    this.markAsInvalid("Broker did not add error condition for connection");
                    return;
                }
                if (!remoteError.getCondition().equals(ConnectionError.CONNECTION_FORCED)) {
                    this.markAsInvalid("Broker did not set condition to " + ConnectionError.CONNECTION_FORCED);
                    return;
                }
                String expectedDescription = "Connection router bb1 rejected this connection";
                String actualDescription = remoteError.getDescription();
                if (!expectedDescription.equals(actualDescription)) {
                    this.markAsInvalid("Broker did not set description as expected, was: " + actualDescription);
                    return;
                }
            }
        });
        try {
            connection.connect();
            Assertions.fail((String)"Expected connection to fail, without redirect");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.getStateInspector().assertValid();
        connection.close();
        this.stopServers(0);
    }
}

