/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.spi.core.security.ActiveMQBasicSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BasicSecurityManagerTest
extends ActiveMQTestBase {
    private ServerLocator locator;
    private boolean bootstrapProperties;

    public BasicSecurityManagerTest(boolean bootstrapProperties) {
        this.bootstrapProperties = bootstrapProperties;
    }

    @Parameters(name="bootstrapProperties={0}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{false}, {true}};
        return Arrays.asList(params);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
    }

    public ActiveMQServer initializeServer() throws Exception {
        HashMap<String, String> initProperties = new HashMap<String, String>();
        if (this.bootstrapProperties) {
            initProperties.put("bootstrapUserFile", "users.properties");
            initProperties.put("bootstrapRoleFile", "roles.properties");
        } else {
            initProperties.put("bootstrapUser", "first");
            initProperties.put("bootstrapPassword", "secret");
            initProperties.put("bootstrapRole", "programmers");
        }
        ActiveMQBasicSecurityManager securityManager = new ActiveMQBasicSecurityManager().init(initProperties);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)true));
        return server;
    }

    @TestTemplate
    public void testAuthenticationForBootstrapUser() throws Exception {
        ActiveMQServer server = this.initializeServer();
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("first", "secret", false, true, true, false, 0);
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    @TestTemplate
    public void testAuthenticationForAddedUserHashed() throws Exception {
        this.internalTestAuthenticationForAddedUser(false);
    }

    @TestTemplate
    public void testAuthenticationForAddedUserPlainText() throws Exception {
        this.internalTestAuthenticationForAddedUser(true);
    }

    private void internalTestAuthenticationForAddedUser(boolean plaintext) throws Exception {
        ActiveMQServer server = this.initializeServer();
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        server.getActiveMQServerControl().addUser("foo", "bar", "baz", plaintext);
        try {
            ClientSession session = cf.createSession("foo", "bar", false, true, true, false, 0);
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    @TestTemplate
    public void testWithValidatedUser() throws Exception {
        ActiveMQServer server = this.initializeServer();
        server.getConfiguration().setPopulateValidatedUser(true);
        server.start();
        Role role = new Role("programmers", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        server.getSecurityRepository().addMatch("#", roles);
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("first", "secret", false, true, true, false, 0);
            server.createQueue(QueueConfiguration.of((String)"queue").setAddress("address").setRoutingType(RoutingType.ANYCAST));
            ClientProducer producer = session.createProducer("address");
            producer.send((Message)session.createMessage(true));
            session.commit();
            producer.close();
            ClientConsumer consumer = session.createConsumer("queue");
            session.start();
            ClientMessage message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"first", (Object)message.getValidatedUserID());
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    @TestTemplate
    public void testAuthenticationBadPassword() throws Exception {
        ActiveMQServer server = this.initializeServer();
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            cf.createSession("first", "badpassword", false, true, true, false, 0);
            Assertions.fail((String)"should throw exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testAuthorizationNegative() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = SimpleString.of((String)"address");
        SimpleString DURABLE_QUEUE = SimpleString.of((String)"durableQueue");
        SimpleString NON_DURABLE_QUEUE = SimpleString.of((String)"nonDurableQueue");
        ActiveMQServer server = this.initializeServer();
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, false, false, false, false, false, false, false, false, false, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("first", "secret", false, true, true, false, 0));
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CREATE_DURABLE_QUEUE' for queue durableQueue on address address"), (String)("Unexpected exception message: " + e.getMessage()));
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='DELETE_DURABLE_QUEUE' for queue durableQueue on address address"), (String)("Unexpected exception message: " + e.getMessage()));
        }
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CREATE_NON_DURABLE_QUEUE' for queue nonDurableQueue on address address"), (String)("Unexpected exception message: " + e.getMessage()));
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='DELETE_NON_DURABLE_QUEUE' for queue nonDurableQueue on address address"), (String)("Unexpected exception message: " + e.getMessage()));
        }
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='SEND' on address address"), (String)("Unexpected exception message: " + e.getMessage()));
        }
        try {
            ClientConsumer consumer = session.createConsumer(DURABLE_QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CONSUME' for queue durableQueue on address address"), (String)("Unexpected exception message: " + e.getMessage()));
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='MANAGE' on address activemq.management"), (String)("Unexpected exception message: " + e.getMessage()));
        }
        try {
            ClientConsumer browser = session.createConsumer(DURABLE_QUEUE, true);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='BROWSE' for queue durableQueue on address address"), (String)("Unexpected exception message: " + e.getMessage()));
        }
    }

    @TestTemplate
    public void testAuthorizationPositive() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = SimpleString.of((String)"address");
        SimpleString DURABLE_QUEUE = SimpleString.of((String)"durableQueue");
        SimpleString NON_DURABLE_QUEUE = SimpleString.of((String)"nonDurableQueue");
        ActiveMQServer server = this.initializeServer();
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", true, true, true, true, true, true, true, true, true, true, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("first", "secret", false, true, true, false, 0));
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE, true);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
    }
}

