/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.lang.management.ManagementFactory;
import java.net.URL;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MaskedCredentialsTest
extends ActiveMQTestBase {
    private ServerLocator locator;
    ClientSessionFactory cf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.start();
        this.locator = this.createInVMNonHALocator();
        this.cf = this.createSessionFactory(this.locator);
    }

    @Test
    public void testMaskedCredentials() throws Exception {
        this.addClientSession(this.cf.createSession(this.getMaskedCredential("first"), this.getMaskedCredential("secret"), false, true, true, false, 0));
    }

    @Test
    public void testMaskedCredentialsWithCustomCodec() throws Exception {
        this.testMaskedCredentialsWithCustomCodec("secret");
    }

    @Test
    public void testMaskedCredentialsWithCustomCodecNegative() throws Exception {
        try {
            this.testMaskedCredentialsWithCustomCodec("xxx");
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void testMaskedCredentialsWithCustomCodec(String password) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setPasswordCodec(DummyCodec.class.getName());
        this.testMaskedCredentialsWithCustomCodec(locator, password);
    }

    @Test
    public void testMaskedCredentialsWithCustomCodecURL() throws Exception {
        this.testMaskedCredentialsWithCustomCodecURL("secret");
    }

    @Test
    public void testMaskedCredentialsWithCustomCodecNegativeURL() throws Exception {
        try {
            this.testMaskedCredentialsWithCustomCodecURL("xxx");
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void testMaskedCredentialsWithCustomCodecURL(String password) throws Exception {
        ServerLocator locator = ActiveMQClient.createServerLocator((String)"vm://0?passwordCodec=org.apache.activemq.artemis.tests.integration.security.MaskedCredentialsTest.DummyCodec");
        locator.setPasswordCodec(DummyCodec.class.getName());
        this.testMaskedCredentialsWithCustomCodec(locator, password);
    }

    private void testMaskedCredentialsWithCustomCodec(ServerLocator locator, String password) throws Exception {
        this.cf = this.createSessionFactory(locator);
        String maskedPassword = PasswordMaskingUtil.wrap((String)PasswordMaskingUtil.resolveMask((String)password, (String)DummyCodec.class.getName()));
        this.addClientSession(this.cf.createSession("first", maskedPassword, false, true, true, false, 0));
    }

    private String getMaskedCredential(String credential) throws Exception {
        return PasswordMaskingUtil.wrap((String)PasswordMaskingUtil.getDefaultCodec().encode((Object)credential));
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = MaskedCredentialsTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }

    public static class DummyCodec
    implements SensitiveDataCodec<String> {
        private static final String MASK = "===";
        private static final String CLEARTEXT = "secret";

        public String decode(Object mask) throws Exception {
            if (!MASK.equals(mask)) {
                return mask.toString();
            }
            return CLEARTEXT;
        }

        public String encode(Object secret) throws Exception {
            if (!CLEARTEXT.equals(secret)) {
                return secret.toString();
            }
            return MASK;
        }
    }
}

