/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SecureConfigurationTest
extends ActiveMQTestBase {
    @Parameter(index=0)
    public String protocol;
    ActiveMQServer server;

    @Parameters(name="{index}: protocol={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"CORE"}, {"AMQP"}, {"OPENWIRE"});
    }

    @BeforeEach
    public void startSever() throws Exception {
        this.server = this.getActiveMQServer("multicast_topic.xml");
        this.server.start();
    }

    @AfterEach
    public void stopServer() throws Exception {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @TestTemplate
    public void testSecureSharedDurableSubscriber() throws Exception {
        Assumptions.assumeFalse((boolean)this.protocol.equals("OPENWIRE"));
        ConnectionFactory connectionFactory = this.getConnectionFactory("b", "b");
        String message = "blah";
        String messageRecieved = this.sendAndReceiveTextUsingTopic(connectionFactory, null, message, "secured_topic_shared_durable", (t, s) -> s.createSharedDurableConsumer(t, "secured_topic_shared_durable/queue"));
        Assertions.assertEquals((Object)message, (Object)messageRecieved);
        try {
            this.sendAndReceiveTextUsingTopic(connectionFactory, null, message, "secured_topic_shared_durable", (t, s) -> s.createSharedDurableConsumer(t, "secured_topic_shared_durable/non-existant-queue"));
            Assertions.fail((String)"Security exception expected, but did not occur, excepetion expected as not permissioned to dynamically create queue");
        }
        catch (JMSSecurityException jMSSecurityException) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testSecureSharedSubscriber() throws Exception {
        Assumptions.assumeFalse((boolean)this.protocol.equals("OPENWIRE"));
        ConnectionFactory connectionFactory = this.getConnectionFactory("b", "b");
        String message = "blah";
        String messageRecieved = this.sendAndReceiveTextUsingTopic(connectionFactory, null, message, "secured_topic_shared", (t, s) -> s.createSharedConsumer(t, "secured_topic_shared/queue"));
        Assertions.assertEquals((Object)message, (Object)messageRecieved);
        try {
            this.sendAndReceiveTextUsingTopic(connectionFactory, null, message, "secured_topic_shared", (t, s) -> s.createSharedConsumer(t, "secured_topic_shared/non-existant-queue"));
            Assertions.fail((String)"Security exception expected, but did not occur, excepetion expected as not permissioned to dynamically create queue");
        }
        catch (JMSSecurityException jMSSecurityException) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testCreateSecureDurableSubscriber() throws Exception {
        ConnectionFactory connectionFactory = this.getConnectionFactory("b", "b");
        String message = "blah";
        String messageRecieved = this.sendAndReceiveTextUsingTopic(connectionFactory, "clientId", message, "secured_topic_durable", (t, s) -> s.createDurableSubscriber(t, "secured_topic_durable/queue"));
        Assertions.assertEquals((Object)message, (Object)messageRecieved);
        try {
            this.sendAndReceiveTextUsingTopic(connectionFactory, "clientId", message, "secured_topic_durable", (t, s) -> s.createDurableSubscriber(t, "secured_topic_durable/non-existant-queue"));
            Assertions.fail((String)"Security exception expected, but did not occur, excepetion expected as not permissioned to dynamically create queue");
        }
        catch (JMSSecurityException jMSSecurityException) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testDeleteSecureDurableSubscriber() throws Exception {
        ConnectionFactory connectionFactory = this.getConnectionFactory("c", "c");
        String message = "blah";
        String messageRecieved = this.sendAndReceiveTextUsingTopic(connectionFactory, "clientId", message, "secured_topic_durable", (t, s) -> s.createDurableSubscriber(t, "secured_topic_durable/non-existant-queue"));
        Assertions.assertEquals((Object)message, (Object)messageRecieved);
        try {
            this.sendAndReceiveTextUsingTopic(connectionFactory, "clientId", message, "secured_topic_durable", (t, s) -> s.createDurableSubscriber(t, "secured_topic_durable/non-existant-queue", "age > 10", false));
            Assertions.fail((String)"Security exception expected, but did not occur, excepetion expected as not permissioned to dynamically delete queue");
        }
        catch (JMSSecurityException jMSSecurityException) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testTemporaryQueue() throws Exception {
        ConnectionFactory connectionFactory = this.getConnectionFactory("a", "a");
        String message = "blah";
        String messageRecieved = this.sendAndReceiveText(connectionFactory, "clientId", message, s -> s.createTemporaryQueue(), (d, s) -> s.createConsumer(d));
        Assertions.assertEquals((Object)message, (Object)messageRecieved);
        connectionFactory = this.getConnectionFactory("c", "c");
        try {
            this.sendAndReceiveText(connectionFactory, "clientId", message, s -> s.createTemporaryQueue(), (d, s) -> s.createConsumer(d));
            Assertions.fail((String)"Security exception expected, but did not occur, excepetion expected as not permissioned to create a temporary queue");
        }
        catch (JMSSecurityException jMSSecurityException) {
        }
        catch (JMSException e) {
            e.printStackTrace();
            Assertions.fail((String)"thrown a JMSEXception instead of a JMSSEcurityException");
        }
    }

    @TestTemplate
    public void testTemporaryTopic() throws Exception {
        ConnectionFactory connectionFactory = this.getConnectionFactory("a", "a");
        String message = "blah";
        String messageRecieved = this.sendAndReceiveText(connectionFactory, "clientId", message, s -> s.createTemporaryTopic(), (d, s) -> s.createConsumer(d));
        Assertions.assertEquals((Object)message, (Object)messageRecieved);
        connectionFactory = this.getConnectionFactory("c", "c");
        try {
            this.sendAndReceiveText(connectionFactory, "clientId", message, s -> s.createTemporaryTopic(), (d, s) -> s.createConsumer(d));
            Assertions.fail((String)"Security exception expected, but did not occur, excepetion expected as not permissioned to create a temporary queue");
        }
        catch (JMSSecurityException jMSSecurityException) {
        }
        catch (JMSException e) {
            e.printStackTrace();
            Assertions.fail((String)"thrown a JMSEXception instead of a JMSSEcurityException");
        }
    }

    @TestTemplate
    public void testSecureQueue() throws Exception {
        ConnectionFactory connectionFactory = this.getConnectionFactory("b", "b");
        String message = "blah";
        String messageRecieved = this.sendAndReceiveTextUsingQueue(connectionFactory, "clientId", message, "secured_queue", (q, s) -> s.createConsumer(q));
        Assertions.assertEquals((Object)message, (Object)messageRecieved);
        connectionFactory = this.getConnectionFactory("a", "a");
        messageRecieved = this.sendAndReceiveTextUsingQueue(connectionFactory, "clientId", message, "new-queue-1", (q, s) -> s.createConsumer(q));
        Assertions.assertEquals((Object)message, (Object)messageRecieved);
        connectionFactory = this.getConnectionFactory("b", "b");
        try {
            this.sendAndReceiveTextUsingQueue(connectionFactory, "clientId", message, "new-queue-2", (q, s) -> s.createConsumer(q));
            Assertions.fail((String)"Security exception expected, but did not occur, excepetion expected as not permissioned to dynamically create address, or queue");
        }
        catch (JMSSecurityException jMSSecurityException) {
            // empty catch block
        }
        connectionFactory = this.getConnectionFactory("a", "a");
        messageRecieved = this.sendAndReceiveTextUsingQueue(connectionFactory, "clientId", message, "new-queue-2", (q, s) -> s.createConsumer(q));
        Assertions.assertEquals((Object)message, (Object)messageRecieved);
    }

    private ConnectionFactory getConnectionFactory(String user, String password) {
        switch (this.protocol) {
            case "CORE": {
                return this.getActiveMQConnectionFactory(password, user);
            }
            case "AMQP": {
                return this.getAMQPConnectionFactory(password, user);
            }
            case "OPENWIRE": {
                return this.getOpenWireConnectionFactory(password, user);
            }
        }
        throw new IllegalStateException("Unsupported Protocol");
    }

    private org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory getActiveMQConnectionFactory(String user, String password) {
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory activeMQConnection = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory("tcp://localhost:61616");
        activeMQConnection.setUser(user);
        activeMQConnection.setPassword(password);
        return activeMQConnection;
    }

    private JmsConnectionFactory getAMQPConnectionFactory(String user, String password) {
        JmsConnectionFactory jmsConnectionFactory = new JmsConnectionFactory("amqp://localhost:61616");
        jmsConnectionFactory.setUsername(user);
        jmsConnectionFactory.setPassword(password);
        return jmsConnectionFactory;
    }

    private ActiveMQConnectionFactory getOpenWireConnectionFactory(String user, String password) {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        activeMQConnectionFactory.setUserName(user);
        activeMQConnectionFactory.setPassword(password);
        activeMQConnectionFactory.setWatchTopicAdvisories(false);
        return activeMQConnectionFactory;
    }

    private String sendAndReceiveTextUsingTopic(ConnectionFactory connectionFactory, String clientId, String message, String topicName, ConsumerSupplier<Topic> consumerSupplier) throws JMSException {
        return this.sendAndReceiveText(connectionFactory, clientId, message, s -> s.createTopic(topicName), consumerSupplier);
    }

    private String sendAndReceiveTextUsingQueue(ConnectionFactory connectionFactory, String clientId, String message, String queueName, ConsumerSupplier<Queue> consumerSupplier) throws JMSException {
        return this.sendAndReceiveText(connectionFactory, clientId, message, s -> s.createQueue(queueName), consumerSupplier);
    }

    private <D extends Destination> String sendAndReceiveText(ConnectionFactory connectionFactory, String clientId, String message, DestinationSupplier<D> destinationSupplier, ConsumerSupplier<D> consumerSupplier) throws JMSException {
        String messageRecieved;
        try (Connection connection = null;){
            connection = connectionFactory.createConnection();
            if (clientId != null && !clientId.isEmpty()) {
                connection.setClientID(clientId);
            }
            connection.start();
            try (Session session = connection.createSession(false, 1);){
                D destination = destinationSupplier.create(session);
                MessageConsumer messageConsumer = consumerSupplier.create(destination, session);
                Assertions.assertNull((Object)messageConsumer.receiveNoWait());
                TextMessage messageToSend = session.createTextMessage(message);
                session.createProducer(destination).send((Message)messageToSend);
                TextMessage received = (TextMessage)messageConsumer.receive(100L);
                messageRecieved = received != null ? received.getText() : null;
            }
        }
        return messageRecieved;
    }

    protected ActiveMQServer getActiveMQServer(String brokerConfig) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileJMSConfiguration fileConfiguration = new FileJMSConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(brokerConfig);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.addDeployable((Deployable)fileConfiguration);
        deploymentManager.readConfiguration();
        SecurityConfiguration securityConfiguration = new SecurityConfiguration();
        securityConfiguration.addUser("a", "a");
        securityConfiguration.addRole("a", "a");
        securityConfiguration.addUser("b", "b");
        securityConfiguration.addRole("b", "b");
        securityConfiguration.addUser("c", "c");
        securityConfiguration.addRole("c", "c");
        ActiveMQJAASSecurityManager sm = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), securityConfiguration);
        return this.addServer((ActiveMQServer)new ActiveMQServerImpl((Configuration)fc, (ActiveMQSecurityManager)sm));
    }

    private static interface ConsumerSupplier<D extends Destination> {
        public MessageConsumer create(D var1, Session var2) throws JMSException;
    }

    private static interface DestinationSupplier<D extends Destination> {
        public D create(Session var1) throws JMSException;
    }
}

