/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class StompWithSecurityPerAcceptorTest
extends StompTestBase {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.uri = new URI(this.scheme + "://" + this.hostname + ":61613");
        this.server = this.createServer();
        this.server.start();
        this.waitForServerToStart(this.server);
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        ConfigurationImpl config = this.createBasicConfig().setSecurityEnabled(this.isSecurityEnabled()).setPersistenceEnabled(this.isPersistenceEnabled()).addAcceptorConfiguration("stomp", "tcp://localhost:61613?securityDomain=PropertiesLogin");
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)new ActiveMQJAASSecurityManager()));
        return this.server;
    }

    @TestTemplate
    public void testSecurityPerAcceptorPositive() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        ClientStompFrame frame = conn.connect("first", "secret");
        Assertions.assertTrue((boolean)frame.getCommand().equals("CONNECTED"));
    }

    @TestTemplate
    public void testSecurityPerAcceptorNegative() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        ClientStompFrame frame = conn.connect("fail", "secret");
        Assertions.assertTrue((boolean)frame.getCommand().equals("ERROR"));
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = StompWithSecurityPerAcceptorTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

