/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;

public class FakeSequentialFileFactory
implements SequentialFileFactory {
    private final Map<String, FakeSequentialFile> fileMap = new ConcurrentHashMap<String, FakeSequentialFile>();
    private volatile int alignment;
    private final boolean supportsCallback;
    private Runnable writeDirectCallback;
    private volatile boolean holdCallbacks;
    private ListenerHoldCallback holdCallbackListener;
    private volatile boolean generateErrors;
    private final List<CallbackRunnable> callbacksInHold;

    public FakeSequentialFileFactory(int alignment, boolean supportsCallback) {
        this.alignment = alignment;
        this.supportsCallback = supportsCallback;
        this.callbacksInHold = new ArrayList<CallbackRunnable>();
    }

    public FakeSequentialFileFactory() {
        this(1, false);
    }

    public SequentialFileFactory setDatasync(boolean enabled) {
        return null;
    }

    public boolean isDatasync() {
        return false;
    }

    public long getBufferSize() {
        return 501760L;
    }

    public int getMaxIO() {
        return 1;
    }

    public void setWriteDirectCallback(Runnable writeDirectCallback) {
        this.writeDirectCallback = writeDirectCallback;
    }

    public SequentialFile createSequentialFile(String fileName) {
        FakeSequentialFile sf = this.fileMap.get(fileName);
        if (sf == null || sf.data == null) {
            sf = this.newSequentialFile(fileName);
            this.fileMap.put(fileName, sf);
        } else {
            sf.getData().position(0);
        }
        return sf;
    }

    public void clearBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        buffer.rewind();
        for (int i = 0; i < limit; ++i) {
            buffer.put((byte)0);
        }
        buffer.rewind();
    }

    public List<String> listFiles(String extension) {
        ArrayList<String> files = new ArrayList<String>();
        for (String s : this.fileMap.keySet()) {
            if (!s.endsWith("." + extension)) continue;
            files.add(s);
        }
        return files;
    }

    public Map<String, FakeSequentialFile> getFileMap() {
        return this.fileMap;
    }

    public void clear() {
        this.fileMap.clear();
    }

    public boolean isSupportsCallbacks() {
        return this.supportsCallback;
    }

    public ByteBuffer newBuffer(int size) {
        if (size % this.alignment != 0) {
            size = (size / this.alignment + 1) * this.alignment;
        }
        return ByteBuffer.allocate(size);
    }

    public int calculateBlockSize(int position) {
        int alignment = this.getAlignment();
        int pos = (position / alignment + (position % alignment != 0 ? 1 : 0)) * alignment;
        return pos;
    }

    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    public synchronized boolean isHoldCallbacks() {
        return this.holdCallbacks;
    }

    public synchronized void setHoldCallbacks(boolean holdCallbacks, ListenerHoldCallback holdCallbackListener) {
        this.holdCallbacks = holdCallbacks;
        this.holdCallbackListener = holdCallbackListener;
    }

    public boolean isGenerateErrors() {
        return this.generateErrors;
    }

    public void setGenerateErrors(boolean generateErrors) {
        this.generateErrors = generateErrors;
    }

    public synchronized void flushAllCallbacks() {
        for (Runnable runnable : this.callbacksInHold) {
            runnable.run();
        }
        this.callbacksInHold.clear();
    }

    public synchronized void flushCallback(int position) {
        Runnable run = this.callbacksInHold.get(position);
        run.run();
        this.callbacksInHold.remove(run);
    }

    public synchronized void setCallbackAsError(int position) {
        this.callbacksInHold.get(position).setSendError(true);
    }

    public synchronized int getNumberOfCallbacks() {
        return this.callbacksInHold.size();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public FakeSequentialFileFactory setAlignment(int alignment) {
        this.alignment = alignment;
        return this;
    }

    protected FakeSequentialFile newSequentialFile(String fileName) {
        return new FakeSequentialFile(fileName);
    }

    public void createDirs() throws Exception {
    }

    public void releaseBuffer(ByteBuffer buffer) {
    }

    public void stop() {
    }

    public void activateBuffer(SequentialFile file) {
    }

    public void start() {
    }

    public void deactivateBuffer() {
    }

    public void flush() {
    }

    public void onIOError(Throwable exception, String message, String file) {
    }

    public ByteBuffer allocateDirectBuffer(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    public void releaseDirectBuffer(ByteBuffer buffer) {
    }

    public File getDirectory() {
        return null;
    }

    public class FakeSequentialFile
    implements SequentialFile {
        private volatile boolean open;
        private String fileName;
        private ByteBuffer data;

        public ByteBuffer getData() {
            return this.data;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void flush() {
        }

        public FakeSequentialFile(String fileName) {
            this.fileName = fileName;
        }

        public synchronized void close() {
            this.open = false;
            if (this.data != null) {
                this.data.position(0);
            }
            this.notifyAll();
        }

        public ByteBuffer map(int position, long size) throws IOException {
            return null;
        }

        public void delete() {
            FakeSequentialFileFactory.this.fileMap.remove(this.fileName);
            if (this.open) {
                this.close();
            }
        }

        public String getFileName() {
            return this.fileName;
        }

        public void open() throws Exception {
            this.open(1, true);
        }

        public synchronized void open(int currentMaxIO, boolean useExecutor) throws Exception {
            this.open = true;
            this.checkAndResize(0);
        }

        public void fill(int size) throws Exception {
            if (!this.open) {
                throw new IllegalStateException("Is closed");
            }
            this.checkAndResize(size);
            for (int i = 0; i < size; ++i) {
                byte[] array = this.data.array();
                array[i] = 0;
            }
        }

        public int read(ByteBuffer bytes) throws Exception {
            return this.read(bytes, null);
        }

        public int read(ByteBuffer bytes, IOCallback callback) throws Exception {
            if (!this.open) {
                throw new IllegalStateException("Is closed");
            }
            byte[] bytesRead = new byte[Math.min(bytes.remaining(), this.data.remaining())];
            this.data.get(bytesRead);
            bytes.put(bytesRead);
            bytes.rewind();
            if (callback != null) {
                callback.done();
            }
            return bytesRead.length;
        }

        public void position(long pos) {
            if (!this.open) {
                throw new IllegalStateException("Is closed");
            }
            this.checkAlignment(pos);
            this.data.position((int)pos);
        }

        public long position() {
            return this.data.position();
        }

        public synchronized void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
            if (!this.open) {
                throw new IllegalStateException("Is closed");
            }
            int position = this.data == null ? 0 : this.data.position();
            this.checkAndResize(bytes.limit() + position);
            CallbackRunnable action = new CallbackRunnable(this, bytes, callback);
            if (FakeSequentialFileFactory.this.generateErrors) {
                action.setSendError(true);
            }
            if (FakeSequentialFileFactory.this.holdCallbacks) {
                this.addCallback(bytes, action);
            } else {
                action.run();
            }
            if (FakeSequentialFileFactory.this.writeDirectCallback != null) {
                FakeSequentialFileFactory.this.writeDirectCallback.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void blockingWriteDirect(ByteBuffer bytes, boolean sync, boolean releaseBuffer) throws Exception {
            SimpleWaitIOCallback callback = new SimpleWaitIOCallback();
            try {
                this.writeDirect(bytes, sync, (IOCallback)callback);
            }
            finally {
                callback.waitCompletion();
            }
        }

        public void sync() throws IOException {
            if (FakeSequentialFileFactory.this.supportsCallback) {
                throw new IllegalStateException("sync is not supported when supportsCallback=true");
            }
        }

        public long size() throws Exception {
            if (this.data == null) {
                return 0L;
            }
            return this.data.limit();
        }

        public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
            this.writeDirect(bytes, sync, null);
        }

        public void writeInternal(ByteBuffer bytes) throws Exception {
            this.writeDirect(bytes, true);
        }

        private void checkAndResize(int size) {
            int oldpos;
            int n = oldpos = this.data == null ? 0 : this.data.position();
            if (this.data == null || this.data.array().length < size) {
                byte[] newBytes = new byte[size];
                if (this.data != null) {
                    System.arraycopy(this.data.array(), 0, newBytes, 0, this.data.array().length);
                }
                this.data = ByteBuffer.wrap(newBytes);
                this.data.position(oldpos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCallback(ByteBuffer bytes, CallbackRunnable action) {
            FakeSequentialFileFactory fakeSequentialFileFactory = FakeSequentialFileFactory.this;
            synchronized (fakeSequentialFileFactory) {
                FakeSequentialFileFactory.this.callbacksInHold.add(action);
                if (FakeSequentialFileFactory.this.holdCallbackListener != null) {
                    FakeSequentialFileFactory.this.holdCallbackListener.callbackAdded(bytes);
                }
            }
        }

        public int calculateBlockStart(int position) throws Exception {
            int pos = (position / FakeSequentialFileFactory.this.alignment + (position % FakeSequentialFileFactory.this.alignment != 0 ? 1 : 0)) * FakeSequentialFileFactory.this.alignment;
            return pos;
        }

        public String toString() {
            return "FakeSequentialFile:" + this.fileName;
        }

        private void checkAlignment(long position) {
            if (position % (long)FakeSequentialFileFactory.this.alignment != 0L) {
                throw new IllegalStateException("Position is not aligned to " + FakeSequentialFileFactory.this.alignment);
            }
        }

        public void renameTo(String newFileName) throws Exception {
            FakeSequentialFileFactory.this.fileMap.remove(this.fileName);
            this.fileName = newFileName;
            FakeSequentialFileFactory.this.fileMap.put(newFileName, this);
        }

        public boolean fits(int size) {
            return this.data.position() + size <= this.data.limit();
        }

        public void setBuffering(boolean buffering) {
        }

        public void disableAutoFlush() {
        }

        public void enableAutoFlush() {
        }

        public SequentialFile cloneFile() {
            return null;
        }

        public void write(ActiveMQBuffer bytes, boolean sync, IOCallback callback) throws Exception {
            bytes.writerIndex(bytes.capacity());
            bytes.readerIndex(0);
            this.writeDirect(bytes.toByteBuffer(), sync, callback);
        }

        public void write(ActiveMQBuffer bytes, boolean sync) throws Exception {
            bytes.writerIndex(bytes.capacity());
            bytes.readerIndex(0);
            this.writeDirect(bytes.toByteBuffer(), sync);
        }

        public void write(EncodingSupport bytes, boolean sync, IOCallback callback) throws Exception {
            ByteBuffer buffer = FakeSequentialFileFactory.this.newBuffer(bytes.getEncodeSize());
            ActiveMQBuffer outbuffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)buffer);
            bytes.encode(outbuffer);
            this.write(outbuffer, sync, callback);
        }

        public void write(EncodingSupport bytes, boolean sync) throws Exception {
            ByteBuffer buffer = FakeSequentialFileFactory.this.newBuffer(bytes.getEncodeSize());
            ActiveMQBuffer outbuffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)buffer);
            bytes.encode(outbuffer);
            this.write(outbuffer, sync);
        }

        public boolean exists() {
            FakeSequentialFile file = FakeSequentialFileFactory.this.fileMap.get(this.fileName);
            return file != null && file.data != null && file.data.capacity() > 0;
        }

        public void setTimedBuffer(TimedBuffer buffer) {
        }

        public void copyTo(SequentialFile newFileName) {
        }

        public File getJavaFile() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ListenerHoldCallback {
        public void callbackAdded(ByteBuffer var1);
    }

    private class CallbackRunnable
    implements Runnable {
        final FakeSequentialFile file;
        final ByteBuffer bytes;
        final IOCallback callback;
        volatile boolean sendError;

        CallbackRunnable(FakeSequentialFile file, ByteBuffer bytes, IOCallback callback) {
            this.file = file;
            this.bytes = bytes;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (this.sendError) {
                this.callback.onError(ActiveMQExceptionType.UNSUPPORTED_PACKET.getCode(), "Fake aio error");
            } else {
                try {
                    this.file.data.put(this.bytes);
                    if (this.callback != null) {
                        this.callback.done();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.callback.onError(ActiveMQExceptionType.GENERIC_EXCEPTION.getCode(), e.getMessage());
                }
            }
        }

        public void setSendError(boolean sendError) {
            this.sendError = sendError;
        }
    }
}

