/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.paging.impl;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.cursor.PagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCursorProviderImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCursorProviderTestAccessor;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageReadWriter;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreTestAccessor;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersister;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.unit.core.postoffice.impl.fakes.FakeQueue;
import org.apache.activemq.artemis.tests.unit.util.FakePagingManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingStoreImplTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final SimpleString destinationTestName;
    protected ExecutorService executor;

    @Test
    public void testAddAndRemoveMessages() {
        long id1 = RandomUtil.randomLong();
        long id2 = RandomUtil.randomLong();
        PageTransactionInfoImpl trans = new PageTransactionInfoImpl(id2);
        trans.setRecordID(id1);
        int nr1 = RandomUtil.randomPositiveInt() % 98 + 2;
        for (int i = 0; i < nr1; ++i) {
            trans.increment(1, 0);
        }
        Assertions.assertEquals((int)nr1, (int)trans.getNumberOfMessages());
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)trans.getEncodeSize());
        trans.encode(buffer);
        PageTransactionInfoImpl trans2 = new PageTransactionInfoImpl(id1);
        trans2.decode(buffer);
        Assertions.assertEquals((long)id2, (long)trans2.getTransactionID());
        Assertions.assertEquals((int)nr1, (int)trans2.getNumberOfMessages());
    }

    @Test
    public void testDoubleStart() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)new FakeStoreFactory(factory), destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        storeImpl.start();
        storeImpl.stop();
    }

    @Test
    public void testPageWithNIO() throws Exception {
        ActiveMQTestBase.recreateDirectory(this.getTestDir());
        this.testConcurrentPaging(new NIOSequentialFileFactory(new File(this.getTestDir()), 1).setDatasync(false), 1);
    }

    @Test
    public void testStore() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        AddressSettings addressSettings = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, addressSettings, this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assertions.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        Assertions.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        ArrayList<ActiveMQBuffer> buffers = new ArrayList<ActiveMQBuffer>();
        ActiveMQBuffer buffer = this.createRandomBuffer(0L, 10);
        buffers.add(buffer);
        SimpleString destination = SimpleString.of((String)"test");
        CoreMessage msg = this.createMessage(1L, (PagingStore)storeImpl, destination, buffer);
        Assertions.assertTrue((boolean)storeImpl.isPaging());
        RoutingContextImpl ctx = new RoutingContextImpl(null);
        Assertions.assertTrue((boolean)storeImpl.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(storeImpl.getStoreName())));
        Assertions.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        storeImpl.addSyncPoint(OperationContextImpl.getContext());
        storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, addressSettings, this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assertions.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        storeImpl.stop();
    }

    @Test
    public void testDepageOnCurrentPage() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        SimpleString destination = SimpleString.of((String)"test");
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assertions.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        ArrayList<ActiveMQBuffer> buffers = new ArrayList<ActiveMQBuffer>();
        int numMessages = 10;
        for (int i = 0; i < numMessages; ++i) {
            ActiveMQBuffer buffer = this.createRandomBuffer((long)i + 1L, 10);
            buffers.add(buffer);
            CoreMessage msg = this.createMessage(i, (PagingStore)storeImpl, destination, buffer);
            RoutingContextImpl ctx = new RoutingContextImpl(null);
            Assertions.assertTrue((boolean)storeImpl.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(storeImpl.getStoreName())));
        }
        Assertions.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        storeImpl.addSyncPoint(OperationContextImpl.getContext());
        Page page = storeImpl.depage();
        page.open(true);
        LinkedList msg = page.read((StorageManager)new NullStorageManager());
        Assertions.assertEquals((int)numMessages, (int)msg.size());
        Assertions.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        page.close(false);
        page = storeImpl.depage();
        Assertions.assertNull((Object)page);
        Assertions.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        for (int i = 0; i < numMessages; ++i) {
            ActiveMQBuffer horn1 = (ActiveMQBuffer)buffers.get(i);
            ActiveMQBuffer horn2 = ((PagedMessage)msg.get(i)).getMessage().toCore().getBodyBuffer();
            horn1.resetReaderIndex();
            horn2.resetReaderIndex();
            for (int j = 0; j < horn1.writerIndex(); ++j) {
                Assertions.assertEquals((byte)horn1.readByte(), (byte)horn2.readByte());
            }
        }
    }

    @Test
    public void testRemoveInTheMiddle() throws Exception {
        NIOSequentialFileFactory factory = new NIOSequentialFileFactory(this.getTestDirfile(), 1);
        SimpleString destination = SimpleString.of((String)"test");
        FakeStoreFactory storeFactory = new FakeStoreFactory((SequentialFileFactory)factory);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        PageSubscription subscription = storeImpl.getCursorProvider().createSubscription(1L, null, true);
        FakeQueue fakeQueue = new FakeQueue(destination, 1L).setDurable(true).setPageSubscription(subscription);
        storeImpl.start();
        for (int repeat = 0; repeat < 5; ++repeat) {
            PagedReference reference;
            int i;
            logger.debug("###############################################################################################################################");
            logger.debug("#repeat {}", (Object)repeat);
            storeImpl.startPaging();
            Assertions.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
            storeImpl.getCursorProvider().disableCleanup();
            int numMessages = 100;
            int page = 1;
            for (i = 0; i < numMessages; ++i) {
                ActiveMQBuffer buffer = this.createRandomBuffer((long)i + 1L, 10);
                CoreMessage msg = this.createMessage(i, (PagingStore)storeImpl, destination, buffer);
                msg.putIntProperty("i", i);
                msg.putIntProperty("page", page);
                RoutingContextImpl ctx = new RoutingContextImpl(null);
                ctx.addQueue(fakeQueue.getName(), (Queue)fakeQueue);
                Assertions.assertTrue((boolean)storeImpl.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(storeImpl.getStoreName())));
                if (i <= 0 || i % 10 != 0) continue;
                storeImpl.forceAnotherPage();
                Assertions.assertEquals((long)(++page), (long)storeImpl.getNumberOfPages());
            }
            Assertions.assertEquals((long)(numMessages / 10), (long)storeImpl.getNumberOfPages());
            PageIterator iterator = subscription.iterator();
            for (i = 0; i < numMessages; ++i) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                reference = (PagedReference)iterator.next();
                Assertions.assertNotNull((Object)reference);
                Assertions.assertEquals((int)i, (int)reference.getPagedMessage().getMessage().getIntProperty("i"));
                int pageOnMsg = reference.getMessage().getIntProperty("page");
                if (pageOnMsg <= 2 || pageOnMsg >= 10) continue;
                subscription.ack(reference);
            }
            iterator.close();
            if (logger.isDebugEnabled()) {
                this.debugPage(storeImpl, subscription, storeImpl.getFirstPage(), storeImpl.getCurrentWritingPage());
            }
            PageCursorProviderTestAccessor.cleanup(storeImpl.getCursorProvider());
            Assertions.assertTrue((boolean)storeImpl.isPaging());
            int messagesRead = 0;
            iterator = subscription.iterator();
            while (iterator.hasNext() && (reference = (PagedReference)iterator.next()) != null) {
                Assertions.assertTrue((boolean)subscription.contains(reference));
                logger.debug("#received message {}, {}", (Object)messagesRead, (Object)reference);
                ++messagesRead;
                int pageOnMsg = reference.getMessage().getIntProperty("page");
                Assertions.assertTrue((pageOnMsg <= 2 || pageOnMsg >= 10 ? (byte)1 : 0) != 0, (String)("received " + reference));
                subscription.ack(reference);
            }
            iterator.close();
            Assertions.assertEquals((int)30, (int)messagesRead);
            Assertions.assertEquals((long)3L, (long)storeImpl.getNumberOfPages());
            PageCursorProviderTestAccessor.cleanup(storeImpl.getCursorProvider());
            Assertions.assertFalse((boolean)storeImpl.isPaging());
            Assertions.assertEquals((int)1, (int)PagingStoreTestAccessor.getUsedPagesSize((PagingStore)storeImpl));
            Assertions.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        }
    }

    private void debugPage(PagingStoreImpl storeImpl, PageSubscription subscription, long startPage, long endPage) throws Exception {
        for (long pgID = startPage; pgID <= endPage; ++pgID) {
            Page page = storeImpl.newPageObject(pgID);
            page.open(false);
            logger.debug("# Page {}", (Object)pgID);
            page.getMessages().forEach(p -> {
                Object acked;
                try {
                    acked = subscription.contains((PagedReference)new PagedReferenceImpl(p, subscription)) + "...";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    acked = "";
                }
                logger.debug("{}{}", acked, p);
            });
            page.close(false);
        }
    }

    @Test
    public void testRemoveCurrentPage() throws Exception {
        NIOSequentialFileFactory factory = new NIOSequentialFileFactory(this.getTestDirfile(), 1);
        SimpleString destination = SimpleString.of((String)"test");
        FakeStoreFactory storeFactory = new FakeStoreFactory((SequentialFileFactory)factory);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        PageSubscription subscription = storeImpl.getCursorProvider().createSubscription(1L, null, true);
        FakeQueue fakeQueue = new FakeQueue(destination, 1L).setDurable(true).setPageSubscription(subscription);
        storeImpl.getCursorProvider().disableCleanup();
        storeImpl.start();
        for (int repeat = 0; repeat < 5; ++repeat) {
            PagedReference reference;
            logger.debug("#repeat {}", (Object)repeat);
            storeImpl.startPaging();
            int numMessages = 97;
            int page = 1;
            for (int i = 1; i <= numMessages; ++i) {
                ActiveMQBuffer buffer = this.createRandomBuffer((long)i + 1L, 10);
                CoreMessage msg = this.createMessage(i, (PagingStore)storeImpl, destination, buffer);
                msg.putIntProperty("i", i);
                msg.putIntProperty("page", page);
                RoutingContextImpl ctx = new RoutingContextImpl(null);
                ctx.addQueue(fakeQueue.getName(), (Queue)fakeQueue);
                Assertions.assertTrue((boolean)storeImpl.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(storeImpl.getStoreName())));
                if (i <= 0 || i % 10 != 0) continue;
                storeImpl.forceAnotherPage();
                ++page;
            }
            Assertions.assertEquals((long)10L, (long)storeImpl.getNumberOfPages());
            Assertions.assertEquals((int)10, (int)factory.listFiles("page").size());
            int messagesRead = 0;
            PageIterator iterator = subscription.iterator();
            for (int i = 1; i <= numMessages; ++i) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                PagedReference reference2 = (PagedReference)iterator.next();
                Assertions.assertNotNull((Object)reference2);
                Assertions.assertEquals((int)i, (int)reference2.getPagedMessage().getMessage().getIntProperty("i"));
                int pageOnMsg = reference2.getMessage().getIntProperty("page");
                if (pageOnMsg != 10) continue;
                ++messagesRead;
                subscription.ack(reference2);
            }
            iterator.close();
            Assertions.assertEquals((int)7, (int)messagesRead);
            PageCursorProviderTestAccessor.cleanup(storeImpl.getCursorProvider());
            Assertions.assertEquals((int)10, (int)factory.listFiles("page").size());
            Assertions.assertTrue((boolean)storeImpl.isPaging());
            storeImpl.forceAnotherPage();
            Assertions.assertEquals((int)11, (int)factory.listFiles("page").size());
            PageCursorProviderTestAccessor.cleanup(storeImpl.getCursorProvider());
            Assertions.assertEquals((int)10, (int)factory.listFiles("page").size());
            Assertions.assertEquals((long)10L, (long)storeImpl.getNumberOfPages());
            Assertions.assertEquals((long)(11 + 10 * repeat), (long)storeImpl.getCurrentWritingPage());
            messagesRead = 0;
            iterator = subscription.iterator();
            while (iterator.hasNext() && (reference = (PagedReference)iterator.next()) != null) {
                ++messagesRead;
                int pageOnMsg = reference.getMessage().getIntProperty("page");
                Assertions.assertTrue((pageOnMsg != 10 ? (byte)1 : 0) != 0);
                subscription.ack(reference);
            }
            iterator.close();
            Assertions.assertEquals((int)90, (int)messagesRead);
            PageCursorProviderTestAccessor.cleanup(storeImpl.getCursorProvider());
            Assertions.assertFalse((boolean)storeImpl.isPaging());
        }
    }

    @Test
    public void testReadNumberOfMessages() throws Exception {
        NIOSequentialFileFactory factory = new NIOSequentialFileFactory(this.getTestDirfile(), 1);
        SimpleString destination = SimpleString.of((String)"test");
        FakeStoreFactory storeFactory = new FakeStoreFactory((SequentialFileFactory)factory);
        StorageManager storageManager = this.createStorageManagerMock();
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), storageManager, (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        PageSubscription subscription = storeImpl.getCursorProvider().createSubscription(1L, null, true);
        FakeQueue fakeQueue = new FakeQueue(destination, 1L).setDurable(true).setPageSubscription(subscription);
        storeImpl.getCursorProvider().disableCleanup();
        storeImpl.start();
        storeImpl.startPaging();
        for (int i = 1; i <= 10; ++i) {
            ActiveMQBuffer buffer = this.createRandomBuffer((long)i + 1L, 10);
            CoreMessage msg = this.createMessage(i, (PagingStore)storeImpl, destination, buffer);
            msg.putIntProperty("i", i);
            msg.putIntProperty("page", 1);
            RoutingContextImpl ctx = new RoutingContextImpl(null);
            ctx.addQueue(fakeQueue.getName(), (Queue)fakeQueue);
            Assertions.assertTrue((boolean)storeImpl.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(storeImpl.getStoreName())));
        }
        Assertions.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        Assertions.assertEquals((int)1, (int)factory.listFiles("page").size());
        String fileName = storeImpl.createFileName(1L);
        ArrayList messages = new ArrayList();
        SequentialFile file = factory.createSequentialFile(storeImpl.createFileName(1L));
        file.open();
        int size = PageReadWriter.readFromSequentialFile((StorageManager)storageManager, (SimpleString)storeImpl.getStoreName(), (SequentialFileFactory)factory, (SequentialFile)file, (long)1L, messages::add, (PageReadWriter.PageRecordFilter)PageReadWriter.SKIP_ALL, null, null);
        file.close();
        Assertions.assertEquals((int)0, (int)messages.size());
        Assertions.assertEquals((int)10, (int)size);
    }

    @Test
    public void testDepageMultiplePages() throws Exception {
        SequentialFileFactory factory = new NIOSequentialFileFactory(new File(this.getPageDir()), 1).setDatasync(false);
        SimpleString destination = SimpleString.of((String)"test");
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        store.start();
        Assertions.assertEquals((long)0L, (long)store.getNumberOfPages());
        store.startPaging();
        Assertions.assertEquals((long)1L, (long)store.getNumberOfPages());
        ArrayList<ActiveMQBuffer> buffers = new ArrayList<ActiveMQBuffer>();
        for (int i = 0; i < 10; ++i) {
            ActiveMQBuffer buffer = this.createRandomBuffer((long)i + 1L, 10);
            buffers.add(buffer);
            if (i == 5) {
                store.forceAnotherPage();
            }
            CoreMessage msg = this.createMessage(i, (PagingStore)store, destination, buffer);
            RoutingContextImpl ctx = new RoutingContextImpl(null);
            Assertions.assertTrue((boolean)store.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(store.getStoreName())));
        }
        Assertions.assertEquals((long)2L, (long)store.getNumberOfPages());
        store.addSyncPoint(OperationContextImpl.getContext());
        int sequence = 0;
        for (int pageNr = 0; pageNr < 2; ++pageNr) {
            Page page = store.depage();
            logger.debug("numberOfPages = {}", (Object)store.getNumberOfPages());
            page.open(true);
            LinkedList msg = page.read((StorageManager)new NullStorageManager());
            page.close(false, false);
            Assertions.assertEquals((int)5, (int)msg.size());
            for (int i = 0; i < 5; ++i) {
                Assertions.assertEquals((long)sequence++, (long)((PagedMessage)msg.get(i)).getMessage().getMessageID());
                ActiveMQTestBase.assertEqualsBuffers(18, (ActiveMQBuffer)buffers.get(pageNr * 5 + i), ((PagedMessage)msg.get(i)).getMessage().toCore().getBodyBuffer());
            }
        }
        Assertions.assertEquals((long)1L, (long)store.getNumberOfPages());
        Assertions.assertTrue((boolean)store.isPaging());
        CoreMessage msg = this.createMessage(1L, (PagingStore)store, destination, (ActiveMQBuffer)buffers.get(0));
        RoutingContextImpl ctx = new RoutingContextImpl(null);
        Assertions.assertTrue((boolean)store.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(store.getStoreName())));
        Page newPage = store.depage();
        newPage.open(true);
        Assertions.assertEquals((int)1, (int)newPage.read((StorageManager)new NullStorageManager()).size());
        newPage.delete(null);
        Assertions.assertEquals((long)1L, (long)store.getNumberOfPages());
        Assertions.assertTrue((boolean)store.isPaging());
        Assertions.assertNull((Object)store.depage());
        Assertions.assertFalse((boolean)store.isPaging());
        RoutingContextImpl ctx2 = new RoutingContextImpl(null);
        Assertions.assertFalse((boolean)store.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(store.getStoreName())));
        store.startPaging();
        ctx2 = new RoutingContextImpl(null);
        Assertions.assertTrue((boolean)store.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(store.getStoreName())));
        Page page = store.depage();
        Assertions.assertNotNull((Object)page);
        page.open(true);
        LinkedList msgs = page.read((StorageManager)new NullStorageManager());
        Assertions.assertEquals((int)1, (int)msgs.size());
        Assertions.assertEquals((long)1L, (long)((PagedMessage)msgs.get(0)).getMessage().getMessageID());
        ActiveMQTestBase.assertEqualsBuffers(18, (ActiveMQBuffer)buffers.get(0), ((PagedMessage)msgs.get(0)).getMessage().toCore().getBodyBuffer());
        Assertions.assertEquals((long)1L, (long)store.getNumberOfPages());
        Assertions.assertTrue((boolean)store.isPaging());
        Assertions.assertNull((Object)store.depage());
        Assertions.assertEquals((long)0L, (long)store.getNumberOfPages());
        page.open(true);
        page.close(false);
    }

    @Test
    public void testConcurrentDepage() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory(1, false);
        this.testConcurrentPaging(factory, 10);
    }

    protected void testConcurrentPaging(SequentialFileFactory factory, int numberOfThreads) throws Exception {
        Page page;
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        int MAX_SIZE = 10240;
        final AtomicLong messageIdGenerator = new AtomicLong(0L);
        final AtomicInteger aliveProducers = new AtomicInteger(numberOfThreads);
        final CountDownLatch latchStart = new CountDownLatch(numberOfThreads);
        ConcurrentHashMap buffers = new ConcurrentHashMap();
        ArrayList readPages = new ArrayList();
        AddressSettings settings = new AddressSettings().setPageSizeBytes(10240).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, SimpleString.of((String)"test"), settings, this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assertions.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        Assertions.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        SimpleString destination = SimpleString.of((String)"test");
        class WriterThread
        extends Thread {
            Exception e;
            final /* synthetic */ PagingStore val$storeImpl;
            final /* synthetic */ SimpleString val$destination;
            final /* synthetic */ ConcurrentHashMap val$buffers;
            final /* synthetic */ CountDownLatch val$latchStart;
            final /* synthetic */ AtomicInteger val$aliveProducers;

            WriterThread() {
                this.val$storeImpl = pagingStore;
                this.val$destination = simpleString;
                this.val$buffers = concurrentHashMap;
                this.val$latchStart = countDownLatch;
                this.val$aliveProducers = atomicInteger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RoutingContextImpl ctx2;
                    long id;
                    CoreMessage msg;
                    boolean firstTime = true;
                    while (this.val$storeImpl.page((Message)(msg = PagingStoreImplTest.this.createMessage(id = messageIdGenerator.incrementAndGet(), this.val$storeImpl, this.val$destination, PagingStoreImplTest.this.createRandomBuffer(id, 5))), (ctx2 = new RoutingContextImpl(null)).getTransaction(), ctx2.getContextListing(this.val$storeImpl.getStoreName()))) {
                        this.val$buffers.put(id, msg);
                        if (!firstTime) continue;
                        this.val$latchStart.countDown();
                        firstTime = false;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    this.e = e1;
                }
                finally {
                    this.val$aliveProducers.decrementAndGet();
                }
            }
        }
        WriterThread[] producerThread = new WriterThread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            producerThread[i] = new WriterThread();
            producerThread[i].start();
        }
        final class ReaderThread
        extends Thread {
            Exception e;
            final /* synthetic */ PagingStore val$storeImpl;
            final /* synthetic */ ArrayList val$readPages;

            ReaderThread() {
                this.val$storeImpl = pagingStore;
                this.val$readPages = arrayList;
            }

            @Override
            public void run() {
                try {
                    ActiveMQTestBase.waitForLatch(latchStart);
                    while (aliveProducers.get() > 0) {
                        Page page = this.val$storeImpl.depage();
                        if (page == null) continue;
                        this.val$readPages.add(page);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    this.e = e1;
                }
            }
        }
        ReaderThread consumer = new ReaderThread();
        consumer.start();
        for (int i = 0; i < numberOfThreads; ++i) {
            producerThread[i].join();
            if (producerThread[i].e == null) continue;
            throw producerThread[i].e;
        }
        consumer.join();
        if (consumer.e != null) {
            throw consumer.e;
        }
        ConcurrentHashMap<Long, Object> buffers2 = new ConcurrentHashMap<Long, Object>();
        for (Object page2 : readPages) {
            page2.open(true);
            LinkedList msgs = page2.read((StorageManager)new NullStorageManager());
            page2.close(false, false);
            LinkedListIterator iter = msgs.iterator();
            try {
                while (iter.hasNext()) {
                    PagedMessage msg2 = (PagedMessage)iter.next();
                    long id = msg2.getMessage().toCore().getBodyBuffer().readLong();
                    msg2.getMessage().toCore().getBodyBuffer().resetReaderIndex();
                    Message msgWritten = (Message)buffers.remove(id);
                    buffers2.put(id, msg2.getMessage());
                    Assertions.assertNotNull((Object)msgWritten);
                    Assertions.assertEquals((Object)msg2.getMessage().getAddress(), (Object)msgWritten.getAddress());
                    ActiveMQTestBase.assertEqualsBuffers(10, msgWritten.toCore().getBodyBuffer(), msg2.getMessage().toCore().getBodyBuffer());
                }
            }
            finally {
                if (iter == null) continue;
                iter.close();
            }
        }
        Assertions.assertEquals((int)0, (int)buffers.size());
        List files = factory.listFiles("page");
        Assertions.assertTrue((files.size() != 0 ? (byte)1 : 0) != 0);
        for (String file : files) {
            SequentialFile fileTmp = factory.createSequentialFile(file);
            fileTmp.open();
            Assertions.assertTrue((fileTmp.size() <= 10240L ? (byte)1 : 0) != 0, (String)("The page file size (" + fileTmp.size() + ") shouldn't be > 10240"));
            fileTmp.close();
        }
        PagingStoreImpl storeImpl2 = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, SimpleString.of((String)"test"), settings, this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        storeImpl2.start();
        long numberOfPages = storeImpl2.getNumberOfPages();
        Assertions.assertTrue((numberOfPages != 0L ? (byte)1 : 0) != 0);
        storeImpl2.startPaging();
        storeImpl2.startPaging();
        Assertions.assertEquals((long)numberOfPages, (long)storeImpl2.getNumberOfPages());
        long lastMessageId = messageIdGenerator.incrementAndGet();
        CoreMessage lastMsg = this.createMessage(lastMessageId, (PagingStore)storeImpl, destination, this.createRandomBuffer(lastMessageId, 5));
        storeImpl2.forceAnotherPage();
        RoutingContextImpl ctx = new RoutingContextImpl(null);
        storeImpl2.page((Message)lastMsg, ctx.getTransaction(), ctx.getContextListing(storeImpl2.getStoreName()));
        buffers2.put(lastMessageId, lastMsg);
        Page lastPage = null;
        while ((page = storeImpl2.depage()) != null) {
            lastPage = page;
            page.open(true);
            LinkedList msgs = page.read((StorageManager)new NullStorageManager());
            page.close(false, false);
            msgs.forEach(msg -> {
                long id = msg.getMessage().toCore().getBodyBuffer().readLong();
                Message msgWritten = (Message)buffers2.remove(id);
                Assertions.assertNotNull((Object)msgWritten);
                Assertions.assertEquals((Object)msg.getMessage().getAddress(), (Object)msgWritten.getAddress());
                ActiveMQTestBase.assertEqualsByteArrays(msgWritten.toCore().getBodyBuffer().writerIndex(), msgWritten.toCore().getBodyBuffer().toByteBuffer().array(), msg.getMessage().toCore().getBodyBuffer().toByteBuffer().array());
            });
        }
        lastPage.open(true);
        LinkedList lastMessages = lastPage.read((StorageManager)new NullStorageManager());
        lastPage.close(false, false);
        Assertions.assertEquals((int)1, (int)lastMessages.size());
        ((PagedMessage)lastMessages.get(0)).getMessage().toCore().getBodyBuffer().resetReaderIndex();
        Assertions.assertEquals((long)((PagedMessage)lastMessages.get(0)).getMessage().toCore().getBodyBuffer().readLong(), (long)lastMessageId);
        Assertions.assertEquals((int)0, (int)buffers2.size());
        Assertions.assertEquals((long)0L, (long)storeImpl.getAddressSize());
        storeImpl.stop();
    }

    @Test
    public void testRestartPage() throws Throwable {
        this.clearDataRecreateServerDirs();
        SequentialFileFactory factory = new NIOSequentialFileFactory(new File(this.getPageDir()), 1).setDatasync(false);
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        int MAX_SIZE = 10240;
        AddressSettings settings = new AddressSettings().setPageSizeBytes(10240).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, SimpleString.of((String)"test"), settings, this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assertions.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        storeImpl.depage();
        Assertions.assertNull((Object)storeImpl.getCurrentPage());
        storeImpl.startPaging();
        Assertions.assertNotNull((Object)storeImpl.getCurrentPage());
        storeImpl.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderOnPaging() throws Throwable {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            this.clearDataRecreateServerDirs();
            FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
            FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
            int MAX_SIZE = 10240;
            AddressSettings settings = new AddressSettings().setPageSizeBytes(10240).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
            PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, SimpleString.of((String)"test"), settings, this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), false);
            store.start();
            Assertions.assertEquals((long)0L, (long)store.getNumberOfPages());
            store.startPaging();
            Assertions.assertEquals((long)1L, (long)store.getNumberOfPages());
            SimpleString destination = SimpleString.of((String)"test");
            long NUMBER_OF_MESSAGES = 10000L;
            ArrayList errors = new ArrayList();
            ReusableLatch done = new ReusableLatch(0);
            done.countUp();
            executorService.execute(() -> this.lambda$testOrderOnPaging$2((PagingStore)store, destination, errors, done));
            Assertions.assertTrue((boolean)done.await(10L, TimeUnit.SECONDS));
            done.countUp();
            executorService.execute(() -> PagingStoreImplTest.lambda$testOrderOnPaging$4((PagingStore)store, errors, done));
            Assertions.assertTrue((boolean)done.await(10L, TimeUnit.SECONDS));
            store.stop();
            Iterator iterator = errors.iterator();
            if (iterator.hasNext()) {
                Throwable e = (Throwable)iterator.next();
                throw e;
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @Test
    public void testWriteIncompletePage() throws Exception {
        this.clearDataRecreateServerDirs();
        SequentialFileFactory factory = new NIOSequentialFileFactory(new File(this.getPageDir()), 1).setDatasync(false);
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        int MAX_SIZE = 0x100000;
        AddressSettings settings = new AddressSettings().setPageSizeBytes(0x100000).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, SimpleString.of((String)"test"), settings, this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assertions.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        Page page = storeImpl.getCurrentPage();
        int num1 = 20;
        for (int i = 0; i < num1; ++i) {
            this.writePageMessage((PagingStore)storeImpl, i);
        }
        long position = page.getFile().position();
        this.writePageMessage((PagingStore)storeImpl, 30L);
        page.getFile().position(position);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        for (int i = 0; i < buffer.capacity(); ++i) {
            buffer.put((byte)90);
        }
        buffer.rewind();
        page.getFile().writeDirect(buffer, true);
        storeImpl.stop();
        storeImpl.start();
        int num2 = 10;
        for (int i = 0; i < num2; ++i) {
            this.writePageMessage((PagingStore)storeImpl, i + num1);
        }
        storeImpl.stop();
        storeImpl.start();
        AtomicLong msgsRead = new AtomicLong(0L);
        while (msgsRead.get() < (long)(num1 + num2)) {
            page = storeImpl.depage();
            Assertions.assertNotNull((Object)page, (String)("no page after read " + msgsRead + " msg"));
            page.open(true);
            LinkedList messages = page.read((StorageManager)new NullStorageManager());
            messages.forEach(pgmsg -> {
                Message msg = pgmsg.getMessage();
                Assertions.assertEquals((long)msgsRead.longValue(), (long)msg.getMessageID());
                Assertions.assertEquals((long)msg.getMessageID(), (long)msg.getLongProperty("count"));
                msgsRead.incrementAndGet();
            });
            page.close(false);
        }
        storeImpl.stop();
    }

    @Test
    public void testLogStartPaging() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        store.start();
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            store.startPaging();
            store.stopPaging();
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ222038"}));
        }
    }

    @Test
    public void testLogStopPaging() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        store.start();
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            store.startPaging();
            store.stopPaging();
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ224108"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAddressLimitPercent() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        store.start();
        try {
            Assertions.assertEquals((int)0, (int)store.getAddressLimitPercent());
            store.addSize(100);
            Assertions.assertEquals((int)0, (int)store.getAddressLimitPercent());
            store.applySetting(new AddressSettings().setMaxSizeBytes(1000L));
            Assertions.assertEquals((int)10, (int)store.getAddressLimitPercent());
            store.addSize(900);
            Assertions.assertEquals((int)100, (int)store.getAddressLimitPercent());
            store.addSize(900);
            Assertions.assertEquals((int)190, (int)store.getAddressLimitPercent());
            store.addSize(-900);
            Assertions.assertEquals((int)100, (int)store.getAddressLimitPercent());
            store.addSize(-1);
            Assertions.assertEquals((int)99, (int)store.getAddressLimitPercent());
        }
        finally {
            store.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAddressLimitPercentGlobalSize() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        final AtomicLong limit = new AtomicLong();
        final AtomicLong globalSize = new AtomicLong();
        FakePagingManager pagingManager = new FakePagingManager(){

            @Override
            public boolean isUsingGlobalSize() {
                return limit.get() > 0L;
            }

            @Override
            public FakePagingManager addSize(int s, boolean sizeOnly) {
                globalSize.addAndGet(s);
                return this;
            }

            public long getGlobalSize() {
                return globalSize.get();
            }

            @Override
            public boolean isGlobalFull() {
                return globalSize.get() >= limit.get();
            }

            public long getMaxSize() {
                return limit.get();
            }
        };
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, (PagingManager)pagingManager, this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        store.start();
        try {
            Assertions.assertEquals((int)0, (int)store.getAddressLimitPercent());
            store.addSize(100);
            Assertions.assertEquals((int)0, (int)store.getAddressLimitPercent());
            limit.set(1000L);
            Assertions.assertEquals((int)10, (int)store.getAddressLimitPercent());
            store.addSize(900);
            Assertions.assertEquals((int)100, (int)store.getAddressLimitPercent());
            store.addSize(900);
            Assertions.assertEquals((int)190, (int)store.getAddressLimitPercent());
            store.addSize(-900);
            Assertions.assertEquals((int)100, (int)store.getAddressLimitPercent());
            store.addSize(-1);
            Assertions.assertEquals((int)99, (int)store.getAddressLimitPercent());
        }
        finally {
            store.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockUnblock() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK), this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), true);
        store.start();
        try {
            AtomicInteger calls = new AtomicInteger();
            Runnable trackMemoryChecks = calls::incrementAndGet;
            store.applySetting(new AddressSettings().setMaxSizeBytes(1000L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK));
            store.addSize(100);
            store.flushExecutors();
            store.checkMemory(trackMemoryChecks, null);
            Assertions.assertEquals((int)1, (int)calls.get());
            store.block();
            store.checkMemory(trackMemoryChecks, null);
            Assertions.assertEquals((int)1, (int)calls.get());
            store.unblock();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> 2 == calls.get(), (long)1000L, (long)50L));
            store.addSize(900);
            Assertions.assertEquals((int)100, (int)store.getAddressLimitPercent());
            store.flushExecutors();
            store.checkMemory(trackMemoryChecks, null);
            Assertions.assertEquals((int)2, (int)calls.get());
            store.block();
            store.addSize(-900);
            Assertions.assertEquals((int)10, (int)store.getAddressLimitPercent());
            Assertions.assertEquals((int)2, (int)calls.get());
            store.unblock();
            store.flushExecutors();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> 3 == calls.get(), (long)1000L, (long)50L));
            store.block();
            store.addSize(900);
            Assertions.assertEquals((int)100, (int)store.getAddressLimitPercent());
            store.checkMemory(trackMemoryChecks, null);
            Assertions.assertEquals((int)3, (int)calls.get(), (String)"no change");
            Assertions.assertEquals((int)3, (int)calls.get(), (String)"no change to be sure to be sure!");
            store.unblock();
            Assertions.assertEquals((int)3, (int)calls.get(), (String)"no change after unblock");
            store.addSize(-900);
            Assertions.assertEquals((int)10, (int)store.getAddressLimitPercent());
            Assertions.assertTrue((boolean)Wait.waitFor(() -> 4 == calls.get(), (long)1000L, (long)50L), (String)"change");
        }
        finally {
            store.stop();
        }
    }

    protected PagingManager createMockManager() {
        return new FakePagingManager();
    }

    private StorageManager createStorageManagerMock() {
        return new NullStorageManager();
    }

    private ExecutorFactory getExecutorFactory() {
        return () -> ArtemisExecutor.delegate((Executor)this.executor);
    }

    protected void writePageMessage(PagingStore storeImpl, long id) throws Exception {
        CoreMessage msg = this.createMessage(id, storeImpl, destinationTestName, this.createRandomBuffer(id, 10));
        msg.putLongProperty("count", id);
        RoutingContextImpl ctx2 = new RoutingContextImpl(null);
        storeImpl.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(storeImpl.getStoreName()));
    }

    private CoreMessage createMessage(long id, PagingStore store, SimpleString destination, ActiveMQBuffer buffer) {
        CoreMessage msg = new CoreMessage(id, 50 + buffer.capacity());
        msg.setAddress(destination);
        msg.getBodyBuffer().resetReaderIndex();
        msg.getBodyBuffer().resetWriterIndex();
        msg.getBodyBuffer().writeBytes(buffer, buffer.capacity());
        return msg;
    }

    protected ActiveMQBuffer createRandomBuffer(long id, int size) {
        return RandomUtil.randomBuffer((int)size, (long[])new long[]{id});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.executor.shutdown();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testCheckExecutionIsNotRepeated() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingManager mockManager = (PagingManager)Mockito.mock(PagingManager.class);
        ArtemisExecutor sameThreadExecutor = Runnable::run;
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, mockManager, this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK), sameThreadExecutor, sameThreadExecutor, true);
        store.start();
        try {
            store.applySetting(new AddressSettings().setMaxSizeBytes(1000L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK));
            Mockito.when((Object)mockManager.addSize(Mockito.anyInt())).thenReturn((Object)mockManager);
            store.addSize(100);
            CountingRunnable trackMemoryCheck1 = new CountingRunnable();
            Assertions.assertEquals((int)0, (int)trackMemoryCheck1.getCount());
            store.checkMemory((Runnable)trackMemoryCheck1, null);
            Assertions.assertEquals((int)1, (int)trackMemoryCheck1.getCount());
            CountingRunnable trackMemoryCheck2 = new CountingRunnable();
            Mockito.when((Object)mockManager.isDiskFull()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
            Assertions.assertEquals((int)0, (int)trackMemoryCheck2.getCount());
            store.checkMemory((Runnable)trackMemoryCheck2, null);
            Assertions.assertEquals((int)1, (int)trackMemoryCheck2.getCount());
            store.checkReleasedMemory();
            Assertions.assertEquals((int)1, (int)trackMemoryCheck2.getCount());
        }
        finally {
            store.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$testOrderOnPaging$4(PagingStore store, List errors, ReusableLatch done) {
        try {
            AtomicInteger msgsRead = new AtomicInteger(0);
            while ((long)msgsRead.get() < 10000L) {
                Page page = store.depage();
                AtomicInteger countOnPage = new AtomicInteger(0);
                if (page == null) continue;
                page.open(true);
                LinkedList messages = page.read((StorageManager)new NullStorageManager());
                messages.forEach(pgmsg -> {
                    Assertions.assertEquals((int)countOnPage.getAndIncrement(), (int)pgmsg.getMessageNumber());
                    Message msg = pgmsg.getMessage();
                    Assertions.assertEquals((long)msgsRead.getAndIncrement(), (long)msg.getMessageID());
                    Assertions.assertEquals((long)msg.getMessageID(), (long)msg.getLongProperty("count"));
                });
                page.close(false, false);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            errors.add(e);
        }
        finally {
            done.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$testOrderOnPaging$2(PagingStore store, SimpleString destination, List errors, ReusableLatch done) {
        try {
            for (long i = 0L; i < 10000L; ++i) {
                CoreMessage msg = this.createMessage(i, store, destination, this.createRandomBuffer(i, 1024));
                msg.putLongProperty("count", i);
                RoutingContextImpl ctx2 = new RoutingContextImpl(null);
                store.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(store.getStoreName()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            errors.add(e);
        }
        finally {
            done.countDown();
        }
    }

    static {
        MessagePersister.registerPersister((Persister)CoreMessagePersister.getInstance());
        MessagePersister.registerPersister((Persister)AMQPMessagePersister.getInstance());
        destinationTestName = SimpleString.of((String)"test");
    }

    static final class FakeStoreFactory
    implements PagingStoreFactory {
        final SequentialFileFactory factory;

        FakeStoreFactory() {
            this.factory = new FakeSequentialFileFactory();
        }

        FakeStoreFactory(SequentialFileFactory factory) {
            this.factory = factory;
        }

        public SequentialFileFactory newFileFactory(SimpleString destinationName) throws Exception {
            return this.factory;
        }

        public void removeFileFactory(SequentialFileFactory fileFactory) throws Exception {
        }

        public PagingStore newStore(SimpleString destinationName, AddressSettings addressSettings) {
            return null;
        }

        public List<PagingStore> reloadStores(HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
            return null;
        }

        public PageCursorProvider newCursorProvider(PagingStore store, StorageManager storageManager, AddressSettings addressSettings, ArtemisExecutor executor) {
            return new PageCursorProviderImpl(store, storageManager);
        }

        public void setPagingManager(PagingManager manager) {
        }

        public void stop() throws InterruptedException {
        }

        public void injectMonitor(FileStoreMonitor monitor) throws Exception {
        }

        public void beforePageRead() throws Exception {
        }

        public void afterPageRead() throws Exception {
        }

        public ByteBuffer allocateDirectBuffer(int size) {
            return ByteBuffer.allocateDirect(size);
        }

        public void freeDirectuffer(ByteBuffer buffer) {
        }
    }

    private static final class CountingRunnable
    implements Runnable {
        final AtomicInteger calls = new AtomicInteger();

        private CountingRunnable() {
        }

        @Override
        public void run() {
            this.calls.incrementAndGet();
        }

        public int getCount() {
            return this.calls.get();
        }
    }
}

